/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.ReferenceQueue;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.dgc.VMID;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteStub;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import sun.misc.GC;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.DGCImpl;
import sun.rmi.transport.Target;
import sun.rmi.transport.WeakRef;
import sun.security.action.GetLongAction;

public final class ObjectTable {
    private static final long gcInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.server.gcInterval", 60000L));
    private static final Object tableLock = new Object();
    private static final Map objTable = new HashMap();
    private static final Map implTable = new HashMap();
    private static final Object keepAliveLock = new Object();
    private static int keepAliveCount = 0;
    private static Thread reaper = null;
    static final ReferenceQueue reapQueue = new ReferenceQueue();
    private static GC.LatencyRequest gcLatencyRequest = null;

    private ObjectTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void decrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            if (--keepAliveCount == 0) {
                if (reaper == null) {
                    throw new AssertionError();
                }
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        ObjectTable.access$100().interrupt();
                        return null;
                    }
                });
                reaper = null;
                gcLatencyRequest.cancel();
                gcLatencyRequest = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void incrementKeepAliveCount() {
        Object object = keepAliveLock;
        synchronized (object) {
            ++keepAliveCount;
            if (reaper == null) {
                reaper = (Thread)AccessController.doPrivileged(new NewThreadAction(new Reaper(null), "Reaper", false));
                reaper.start();
            }
            if (gcLatencyRequest == null) {
                gcLatencyRequest = GC.requestLatency(gcInterval);
            }
        }
    }

    static Object access$200() {
        return tableLock;
    }

    static Thread access$100() {
        return reaper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unexportObject(Remote remote, boolean bl2) throws NoSuchObjectException {
        Object object = tableLock;
        synchronized (object) {
            Target target = ObjectTable.getTarget(remote);
            if (target == null) {
                throw new NoSuchObjectException("object not exported");
            }
            if (target.unexport(bl2)) {
                ObjectTable.removeTarget(target);
                return true;
            }
            return false;
        }
    }

    static Map access$300() {
        return implTable;
    }

    static void access$400(Target target) {
        ObjectTable.removeTarget(target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void putTarget(Target target) throws ExportException {
        Remote remote;
        ObjID objID = target.getObjID();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "add object " + objID);
        }
        if ((remote = target.getImpl()) == null) {
            throw new ExportException("internal error: attempt to export collected object");
        }
        Object object = tableLock;
        synchronized (object) {
            if (objTable.containsKey(objID)) {
                throw new ExportException("internal error: ObjID already in use");
            }
            if (implTable.containsKey(weakRef)) {
                throw new ExportException("object already exported");
            }
            objTable.put(objID, target);
            implTable.put(weakRef, target);
            if (!target.isPermanent()) {
                ObjectTable.incrementKeepAliveCount();
            }
        }
    }

    private static void removeTarget(Target target) {
        ObjID objID = target.getObjID();
        WeakRef weakRef = target.getWeakImpl();
        if (DGCImpl.dgcLog.isLoggable(Log.VERBOSE)) {
            DGCImpl.dgcLog.log(Log.VERBOSE, "remove object " + objID);
        }
        objTable.remove(objID);
        implTable.remove(weakRef);
        target.markRemoved();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void referenced(ObjID objID, long l2, VMID vMID) {
        Object object = tableLock;
        synchronized (object) {
            Target target = (Target)objTable.get(objID);
            if (target != null) {
                target.referenced(l2, vMID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void unreferenced(ObjID objID, long l2, VMID vMID, boolean bl2) {
        Object object = tableLock;
        synchronized (object) {
            Target target = (Target)objTable.get(objID);
            if (target != null) {
                target.unreferenced(l2, vMID, bl2);
            }
        }
    }

    public static RemoteStub getStub(Remote remote) throws NoSuchObjectException {
        Target target = ObjectTable.getTarget(remote);
        if (target == null) {
            throw new NoSuchObjectException("object not exported");
        }
        return target.getStub();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Target getTarget(Remote remote) {
        Object object = tableLock;
        synchronized (object) {
            return (Target)implTable.get(new WeakRef(remote));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Target getTarget(ObjID objID) {
        Object object = tableLock;
        synchronized (object) {
            return (Target)objTable.get(objID);
        }
    }

    private static class Reaper
    implements Runnable {
        private Reaper() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                do {
                    WeakRef weakRef = (WeakRef)reapQueue.remove();
                    Object object = ObjectTable.access$200();
                    synchronized (object) {
                        Target target = (Target)ObjectTable.access$300().get(weakRef);
                        if (target != null) {
                            if (!target.isEmpty()) {
                                throw new Error("object with known references collected");
                            }
                            if (target.isPermanent()) {
                                throw new Error("permanent object collected");
                            }
                            ObjectTable.access$400(target);
                        }
                    }
                } while (!Thread.interrupted());
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        Reaper(1 var1_1) {
            this();
        }
    }
}

