/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;

public class DesktopProperty
implements UIDefaults.ActiveValue {
    private static boolean updatePending;
    private static ReferenceQueue queue;
    private WeakPCL pcl;
    private String key;
    private Object value;
    private Object fallback;
    private Toolkit toolkit;
    static Class class$com$sun$java$swing$plaf$windows$DesktopProperty;

    static {
        queue = new ReferenceQueue();
    }

    static void access$000() {
        DesktopProperty.updateAllUIs();
    }

    static void flushUnreferencedProperties() {
        WeakPCL weakPCL;
        while ((weakPCL = (WeakPCL)queue.poll()) != null) {
            weakPCL.dispose();
        }
    }

    public void invalidate() {
        if (this.pcl != null) {
            this.toolkit.removePropertyChangeListener(this.getKey(), this.pcl);
            this.toolkit = null;
            this.pcl = null;
            this.value = null;
        }
    }

    private static void updateAllUIs() {
        Class clazz = UIManager.getLookAndFeel().getClass();
        if (clazz.getPackage().equals((class$com$sun$java$swing$plaf$windows$DesktopProperty == null ? (class$com$sun$java$swing$plaf$windows$DesktopProperty = DesktopProperty.class$("com.sun.java.swing.plaf.windows.DesktopProperty")) : class$com$sun$java$swing$plaf$windows$DesktopProperty).getPackage())) {
            XPStyle.invalidateStyle();
        }
        Frame[] frameArray = Frame.getFrames();
        for (int i2 = 0; i2 < frameArray.length; ++i2) {
            DesktopProperty.updateWindowUI(frameArray[i2]);
        }
    }

    protected void updateUI() {
        if (!DesktopProperty.isUpdatePending()) {
            DesktopProperty.setUpdatePending(true);
            Runnable runnable = new Runnable(this){
                private final DesktopProperty this$0;

                public void run() {
                    DesktopProperty.access$000();
                    DesktopProperty.access$100(false);
                }
                {
                    this.this$0 = desktopProperty;
                }
            };
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static synchronized boolean isUpdatePending() {
        return updatePending;
    }

    static void access$100(boolean bl2) {
        DesktopProperty.setUpdatePending(bl2);
    }

    private static synchronized void setUpdatePending(boolean bl2) {
        updatePending = bl2;
    }

    private static void updateWindowUI(Window window) {
        SwingUtilities.updateComponentTreeUI(window);
        Window[] windowArray = window.getOwnedWindows();
        for (int i2 = 0; i2 < windowArray.length; ++i2) {
            DesktopProperty.updateWindowUI(windowArray[i2]);
        }
    }

    protected Object getDefaultValue() {
        return this.fallback;
    }

    protected Object getValueFromDesktop() {
        if (this.toolkit == null) {
            this.toolkit = Toolkit.getDefaultToolkit();
        }
        Object object = this.toolkit.getDesktopProperty(this.getKey());
        this.pcl = new WeakPCL(this, this.toolkit, this.getKey());
        this.toolkit.addPropertyChangeListener(this.getKey(), this.pcl);
        return object;
    }

    protected String getKey() {
        return this.key;
    }

    static ReferenceQueue access$200() {
        return queue;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    protected Object configureValue(Object object) {
        if (object != null) {
            if (object instanceof Color) {
                return new ColorUIResource((Color)object);
            }
            if (object instanceof Font) {
                return new FontUIResource((Font)object);
            }
            if (object instanceof UIDefaults.ProxyLazyValue) {
                object = ((UIDefaults.ProxyLazyValue)object).createValue(null);
            } else if (object instanceof UIDefaults.ActiveValue) {
                object = ((UIDefaults.ActiveValue)object).createValue(null);
            }
        }
        return object;
    }

    public Object createValue(UIDefaults uIDefaults) {
        if (this.value == null) {
            this.value = this.configureValue(this.getValueFromDesktop());
            if (this.value == null) {
                this.value = this.configureValue(this.getDefaultValue());
            }
        }
        return this.value;
    }

    public DesktopProperty(String string, Object object, Toolkit toolkit) {
        this.key = string;
        this.fallback = object;
        this.toolkit = toolkit;
        DesktopProperty.flushUnreferencedProperties();
    }

    private static class WeakPCL
    extends WeakReference
    implements PropertyChangeListener {
        private Toolkit kit;
        private String key;

        void dispose() {
            this.kit.removePropertyChangeListener(this.key, this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            DesktopProperty desktopProperty = (DesktopProperty)this.get();
            if (desktopProperty == null) {
                this.dispose();
            } else {
                desktopProperty.invalidate();
                desktopProperty.updateUI();
            }
        }

        WeakPCL(Object object, Toolkit toolkit, String string) {
            super(object, DesktopProperty.access$200());
            this.kit = toolkit;
            this.key = string;
        }
    }
}

