/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ByteLookupTable;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.IndexColorModel;
import java.awt.image.LookupTable;
import java.awt.image.Raster;
import java.awt.image.RasterOp;
import java.awt.image.ShortLookupTable;
import java.awt.image.WritableRaster;
import sun.awt.image.ImagingLib;

public class LookupOp
implements BufferedImageOp,
RasterOp {
    private LookupTable ltable;
    private int numComponents;
    RenderingHints hints;

    public final RenderingHints getRenderingHints() {
        return this.hints;
    }

    public final LookupTable getTable() {
        return this.ltable;
    }

    public LookupOp(LookupTable lookupTable, RenderingHints renderingHints) {
        this.ltable = lookupTable;
        this.hints = renderingHints;
        this.numComponents = this.ltable.getNumComponents();
    }

    public final Rectangle2D getBounds2D(BufferedImage bufferedImage) {
        return this.getBounds2D(bufferedImage.getRaster());
    }

    public final Rectangle2D getBounds2D(Raster raster) {
        return raster.getBounds();
    }

    public WritableRaster createCompatibleDestRaster(Raster raster) {
        return raster.createCompatibleWritableRaster();
    }

    public final Point2D getPoint2D(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = new Point2D.Float();
        }
        point2D2.setLocation(point2D.getX(), point2D.getY());
        return point2D2;
    }

    public final BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        Object object;
        ColorModel colorModel;
        ColorModel colorModel2 = bufferedImage.getColorModel();
        int n2 = colorModel2.getNumColorComponents();
        if (colorModel2 instanceof IndexColorModel) {
            throw new IllegalArgumentException("LookupOp cannot be performed on an indexed image");
        }
        int n3 = this.ltable.getNumComponents();
        if (n3 != 1 && n3 != colorModel2.getNumComponents() && n3 != colorModel2.getNumColorComponents()) {
            throw new IllegalArgumentException("Number of arrays in the  lookup table (" + n3 + " is not compatible with the " + " src image: " + bufferedImage);
        }
        boolean bl2 = false;
        int n4 = bufferedImage.getWidth();
        int n5 = bufferedImage.getHeight();
        if (bufferedImage2 == null) {
            bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            colorModel = colorModel2;
        } else {
            if (n4 != bufferedImage2.getWidth()) {
                throw new IllegalArgumentException("Src width (" + n4 + ") not equal to dst width (" + bufferedImage2.getWidth() + ")");
            }
            if (n5 != bufferedImage2.getHeight()) {
                throw new IllegalArgumentException("Src height (" + n5 + ") not equal to dst height (" + bufferedImage2.getHeight() + ")");
            }
            colorModel = bufferedImage2.getColorModel();
            if (colorModel2.getColorSpace().getType() != colorModel.getColorSpace().getType()) {
                bl2 = true;
                bufferedImage2 = this.createCompatibleDestImage(bufferedImage, null);
            }
        }
        BufferedImage bufferedImage3 = bufferedImage2;
        if (ImagingLib.filter(this, bufferedImage, bufferedImage2) == null) {
            int n6;
            int n7;
            object = bufferedImage.getRaster();
            WritableRaster writableRaster = bufferedImage2.getRaster();
            if (colorModel2.hasAlpha() && (n2 - 1 == n3 || n3 == 1)) {
                n7 = ((Raster)object).getMinX();
                n6 = ((Raster)object).getMinY();
                int[] nArray = new int[n2 - 1];
                for (int i2 = 0; i2 < n2 - 1; ++i2) {
                    nArray[i2] = i2;
                }
                object = ((WritableRaster)object).createWritableChild(n7, n6, ((Raster)object).getWidth(), ((Raster)object).getHeight(), n7, n6, nArray);
            }
            if (colorModel.hasAlpha() && ((n7 = writableRaster.getNumBands()) - 1 == n3 || n3 == 1)) {
                n6 = writableRaster.getMinX();
                int n8 = writableRaster.getMinY();
                int[] nArray = new int[n2 - 1];
                for (int i3 = 0; i3 < n2 - 1; ++i3) {
                    nArray[i3] = i3;
                }
                writableRaster = writableRaster.createWritableChild(n6, n8, writableRaster.getWidth(), writableRaster.getHeight(), n6, n8, nArray);
            }
            this.filter((Raster)object, writableRaster);
        }
        if (bl2) {
            object = new ColorConvertOp(this.hints);
            ((ColorConvertOp)object).filter(bufferedImage2, bufferedImage3);
        }
        return bufferedImage3;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage bufferedImage, ColorModel colorModel) {
        BufferedImage bufferedImage2;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = 0;
        if (colorModel == null) {
            ColorModel colorModel2 = bufferedImage.getColorModel();
            WritableRaster writableRaster = bufferedImage.getRaster();
            if (colorModel2 instanceof ComponentColorModel) {
                DataBuffer dataBuffer = writableRaster.getDataBuffer();
                boolean bl2 = colorModel2.hasAlpha();
                boolean bl3 = colorModel2.isAlphaPremultiplied();
                int n5 = colorModel2.getTransparency();
                int[] nArray = null;
                if (this.ltable instanceof ByteLookupTable) {
                    if (dataBuffer.getDataType() == 1) {
                        if (bl2) {
                            nArray = new int[2];
                            nArray[1] = n5 == 2 ? 1 : 8;
                        } else {
                            nArray = new int[]{8};
                        }
                    }
                } else if (this.ltable instanceof ShortLookupTable) {
                    n4 = 1;
                    if (dataBuffer.getDataType() == 0) {
                        if (bl2) {
                            nArray = new int[2];
                            nArray[1] = n5 == 2 ? 1 : 16;
                        } else {
                            nArray = new int[]{16};
                        }
                    }
                }
                if (nArray != null) {
                    colorModel2 = new ComponentColorModel(colorModel2.getColorSpace(), nArray, bl2, bl3, n5, n4);
                }
            }
            bufferedImage2 = new BufferedImage(colorModel2, colorModel2.createCompatibleWritableRaster(n2, n3), colorModel2.isAlphaPremultiplied(), null);
        } else {
            bufferedImage2 = new BufferedImage(colorModel, colorModel.createCompatibleWritableRaster(n2, n3), colorModel.isAlphaPremultiplied(), null);
        }
        return bufferedImage2;
    }

    private final void byteFilter(ByteLookupTable byteLookupTable, Raster raster, WritableRaster writableRaster, int n2, int n3, int n4) {
        int[] nArray = null;
        byte[][] byArray = byteLookupTable.getTable();
        int n5 = byteLookupTable.getOffset();
        int n6 = 1;
        if (byArray.length == 1) {
            n6 = 0;
        }
        int n7 = byArray[0].length;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n8 = 0;
            int n9 = 0;
            while (n9 < n4) {
                nArray = raster.getSamples(0, i2, n2, 1, n9, nArray);
                for (int i3 = 0; i3 < n2; ++i3) {
                    int n10 = nArray[i3] - n5;
                    if (n10 < 0 || n10 > n7) {
                        throw new IllegalArgumentException("index (" + n10 + "(out of range: " + " srcPix[" + i3 + "]=" + nArray[i3] + " offset=" + n5);
                    }
                    nArray[i3] = byArray[n8][n10];
                }
                writableRaster.setSamples(0, i2, n2, 1, n9, nArray);
                ++n9;
                n8 += n6;
            }
        }
    }

    private final void shortFilter(ShortLookupTable shortLookupTable, Raster raster, WritableRaster writableRaster, int n2, int n3, int n4) {
        int[] nArray = null;
        short[][] sArray = shortLookupTable.getTable();
        int n5 = shortLookupTable.getOffset();
        int n6 = 1;
        if (sArray.length == 1) {
            n6 = 0;
        }
        int n7 = 0;
        int n8 = 0;
        int n9 = 65535;
        for (n8 = 0; n8 < n3; ++n8) {
            int n10 = 0;
            int n11 = 0;
            while (n11 < n4) {
                nArray = raster.getSamples(0, n8, n2, 1, n11, nArray);
                for (n7 = 0; n7 < n2; ++n7) {
                    int n12 = nArray[n7] - n5;
                    if (n12 < 0 || n12 > n9) {
                        throw new IllegalArgumentException("index out of range " + n12 + " x is " + n7 + "srcPix[x]=" + nArray[n7] + " offset=" + n5);
                    }
                    nArray[n7] = sArray[n10][n12];
                }
                writableRaster.setSamples(0, n8, n2, 1, n11, nArray);
                ++n11;
                n10 += n6;
            }
        }
    }

    public final WritableRaster filter(Raster raster, WritableRaster writableRaster) {
        int n2 = raster.getNumBands();
        int n3 = writableRaster.getNumBands();
        int n4 = raster.getHeight();
        int n5 = raster.getWidth();
        int[] nArray = new int[n2];
        if (writableRaster == null) {
            writableRaster = this.createCompatibleDestRaster(raster);
        } else if (n4 != writableRaster.getHeight() || n5 != writableRaster.getWidth()) {
            throw new IllegalArgumentException("Width or height of Rasters do not match");
        }
        n3 = writableRaster.getNumBands();
        if (n2 != n3) {
            throw new IllegalArgumentException("Number of channels in the src (" + n2 + ") does not match number of channels" + " in the destination (" + n3 + ")");
        }
        int n6 = this.ltable.getNumComponents();
        if (n6 != 1 && n6 != raster.getNumBands()) {
            throw new IllegalArgumentException("Number of arrays in the  lookup table (" + n6 + " is not compatible with the " + " src Raster: " + raster);
        }
        if (ImagingLib.filter(this, raster, writableRaster) != null) {
            return writableRaster;
        }
        if (this.ltable instanceof ByteLookupTable) {
            this.byteFilter((ByteLookupTable)this.ltable, raster, writableRaster, n5, n4, n2);
        } else if (this.ltable instanceof ShortLookupTable) {
            this.shortFilter((ShortLookupTable)this.ltable, raster, writableRaster, n5, n4, n2);
        } else {
            int n7 = raster.getMinX();
            int n8 = raster.getMinY();
            int n9 = writableRaster.getMinX();
            int n10 = writableRaster.getMinY();
            int n11 = 0;
            while (n11 < n4) {
                int n12 = n7;
                int n13 = n9;
                int n14 = 0;
                while (n14 < n5) {
                    raster.getPixel(n12, n8, nArray);
                    this.ltable.lookupPixel(nArray, nArray);
                    writableRaster.setPixel(n13, n10, nArray);
                    ++n14;
                    ++n12;
                    ++n13;
                }
                ++n11;
                ++n8;
                ++n10;
            }
        }
        return writableRaster;
    }
}

