/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.InvalidMarkException;

public abstract class Buffer {
    private int mark = -1;
    private int position = 0;
    private int limit;
    private int capacity;
    long address;

    public final int capacity() {
        return this.capacity;
    }

    public final int limit() {
        return this.limit;
    }

    final int markValue() {
        return this.mark;
    }

    final int nextGetIndex() {
        if (this.position >= this.limit) {
            throw new BufferUnderflowException();
        }
        return this.position++;
    }

    final int nextPutIndex() {
        if (this.position >= this.limit) {
            throw new BufferOverflowException();
        }
        return this.position++;
    }

    public final int position() {
        return this.position;
    }

    public final int remaining() {
        return this.limit - this.position;
    }

    public final boolean hasRemaining() {
        return this.position < this.limit;
    }

    public abstract boolean isReadOnly();

    final int checkIndex(int n2) {
        if (n2 < 0 || n2 >= this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n2;
    }

    final int nextGetIndex(int n2) {
        if (this.position + n2 > this.limit) {
            throw new BufferUnderflowException();
        }
        int n3 = this.position;
        this.position += n2;
        return n3;
    }

    final int nextPutIndex(int n2) {
        if (this.position + n2 > this.limit) {
            throw new BufferOverflowException();
        }
        int n3 = this.position;
        this.position += n2;
        return n3;
    }

    final int checkIndex(int n2, int n3) {
        if (n2 < 0 || n2 + n3 > this.limit) {
            throw new IndexOutOfBoundsException();
        }
        return n2;
    }

    static void checkBounds(int n2, int n3, int n4) {
        if ((n2 | n3 | n2 + n3 | n4 - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
    }

    Buffer(int n2, int n3, int n4, int n5) {
        if (n5 < 0) {
            throw new IllegalArgumentException();
        }
        this.capacity = n5;
        this.limit(n4);
        this.position(n3);
        if (n2 >= 0) {
            if (n2 > n3) {
                throw new IllegalArgumentException();
            }
            this.mark = n2;
        }
    }

    public final Buffer clear() {
        this.position = 0;
        this.limit = this.capacity;
        this.mark = -1;
        return this;
    }

    public final Buffer flip() {
        this.limit = this.position;
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer mark() {
        this.mark = this.position;
        return this;
    }

    public final Buffer reset() {
        int n2 = this.mark;
        if (n2 < 0) {
            throw new InvalidMarkException();
        }
        this.position = n2;
        return this;
    }

    public final Buffer rewind() {
        this.position = 0;
        this.mark = -1;
        return this;
    }

    public final Buffer limit(int n2) {
        if (n2 > this.capacity || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.limit = n2;
        if (this.position > this.limit) {
            this.position = this.limit;
        }
        if (this.mark > this.limit) {
            this.mark = -1;
        }
        return this;
    }

    public final Buffer position(int n2) {
        if (n2 > this.limit || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.position = n2;
        if (this.mark > this.position) {
            this.mark = -1;
        }
        return this;
    }
}

