/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.crimson.jaxp.DefaultValidationErrorHandler;
import org.apache.crimson.parser.XMLReaderImpl;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends SAXParser {
    private XMLReader xmlReader = new XMLReaderImpl();
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    private void setFeatures(Hashtable hashtable) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                boolean bl2 = (Boolean)hashtable.get(string);
                this.xmlReader.setFeature(string, bl2);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.xmlReader.getProperty(string);
    }

    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.xmlReader.setProperty(string, object);
    }

    SAXParserImpl(SAXParserFactory sAXParserFactory, Hashtable hashtable) throws SAXException {
        this.validating = sAXParserFactory.isValidating();
        String string = "http://xml.org/sax/features/validation";
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature(string, this.validating);
        this.namespaceAware = sAXParserFactory.isNamespaceAware();
        String string2 = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(string2, this.namespaceAware);
        if (!this.namespaceAware) {
            String string3 = "http://xml.org/sax/features/namespace-prefixes";
            this.xmlReader.setFeature(string3, true);
        }
        this.setFeatures(hashtable);
    }
}

