/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import sun.awt.image.GifImageDecoder;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetchable;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.ImageRepresentation;
import sun.awt.image.JPEGImageDecoder;
import sun.awt.image.PNGImageDecoder;
import sun.awt.image.PixelStore;
import sun.awt.image.XbmImageDecoder;

public abstract class InputStreamImageSource
implements ImageProducer,
ImageFetchable {
    PixelStore pixelstore;
    ImageConsumerQueue consumers;
    ImageDecoder decoder;
    ImageDecoder decoders;
    boolean awaitingFetch = false;

    synchronized int countConsumers() {
        ImageDecoder imageDecoder = this.decoders;
        int n2 = this.countConsumers(this.consumers);
        while (imageDecoder != null) {
            n2 += this.countConsumers(imageDecoder.queue);
            imageDecoder = imageDecoder.next;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void badDecoder() {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        this.errorAllConsumers(imageConsumerQueue, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFetch() {
        block19: {
            this.updateFromStore();
            Object object = this;
            synchronized (object) {
                if (this.consumers == null) {
                    this.awaitingFetch = false;
                    return;
                }
            }
            object = this.getDecoder();
            if (object == null) {
                this.badDecoder();
            } else {
                this.setDecoder((ImageDecoder)object);
                try {
                    try {
                        ((ImageDecoder)object).produceImage();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                        Object var4_6 = null;
                        this.removeDecoder((ImageDecoder)object);
                        if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                            this.errorAllConsumers(((ImageDecoder)object).queue, true);
                        } else {
                            this.errorAllConsumers(((ImageDecoder)object).queue, false);
                        }
                        break block19;
                    }
                    catch (ImageFormatException imageFormatException) {
                        imageFormatException.printStackTrace();
                        Object var4_7 = null;
                        this.removeDecoder((ImageDecoder)object);
                        if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                            this.errorAllConsumers(((ImageDecoder)object).queue, true);
                        } else {
                            this.errorAllConsumers(((ImageDecoder)object).queue, false);
                        }
                    }
                    Object var4_5 = null;
                    this.removeDecoder((ImageDecoder)object);
                    if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                        this.errorAllConsumers(((ImageDecoder)object).queue, true);
                    } else {
                        this.errorAllConsumers(((ImageDecoder)object).queue, false);
                    }
                }
                catch (Throwable throwable) {
                    Object var4_8 = null;
                    this.removeDecoder((ImageDecoder)object);
                    if (Thread.currentThread().isInterrupted() || !Thread.currentThread().isAlive()) {
                        this.errorAllConsumers(((ImageDecoder)object).queue, true);
                    } else {
                        this.errorAllConsumers(((ImageDecoder)object).queue, false);
                    }
                    throw throwable;
                }
            }
        }
    }

    synchronized void flush() {
        this.pixelstore = null;
        this.decoder = null;
    }

    private synchronized void startProduction() {
        if (!this.awaitingFetch) {
            ImageFetcher.add(this);
            this.awaitingFetch = true;
        }
    }

    private synchronized void stopProduction() {
        if (this.awaitingFetch) {
            ImageFetcher.remove(this);
            this.awaitingFetch = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean updateFromStore() {
        ImageConsumerQueue imageConsumerQueue;
        PixelStore pixelStore;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            pixelStore = this.pixelstore;
            if (pixelStore == null) {
                return false;
            }
            imageConsumerQueue = this.consumers;
        }
        while (imageConsumerQueue != null) {
            boolean bl2;
            InputStreamImageSource inputStreamImageSource2 = this;
            synchronized (inputStreamImageSource2) {
                if (!imageConsumerQueue.interested) {
                    imageConsumerQueue = imageConsumerQueue.next;
                    continue;
                }
                bl2 = this.checkSecurity(imageConsumerQueue.securityContext, true);
            }
            if (bl2) {
                if (!pixelStore.replay(this, imageConsumerQueue.consumer)) {
                    return false;
                }
            } else {
                this.errorConsumer(imageConsumerQueue, false);
            }
            inputStreamImageSource2 = this;
            synchronized (inputStreamImageSource2) {
                imageConsumerQueue = imageConsumerQueue.next;
            }
        }
        return true;
    }

    public void addConsumer(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, false);
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            imageDecoder.removeConsumer(imageConsumer);
            imageDecoder = imageDecoder.next;
        }
        this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumer, false);
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                imageDecoder.replayConsumer(imageConsumer);
            }
            imageDecoder = imageDecoder.next;
        }
    }

    public void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer, true);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            if (imageDecoder.isConsumer(imageConsumer)) {
                return true;
            }
            imageDecoder = imageDecoder.next;
        }
        return ImageConsumerQueue.isConsumer(this.consumers, imageConsumer);
    }

    synchronized void addConsumer(ImageConsumer imageConsumer, boolean bl2) {
        this.checkSecurity(null, false);
        Object object = this.decoders;
        while (object != null) {
            if (((ImageDecoder)object).isConsumer(imageConsumer)) {
                return;
            }
            object = ((ImageDecoder)object).next;
        }
        object = this.consumers;
        while (object != null && ((ImageConsumerQueue)object).consumer != imageConsumer) {
            object = ((ImageConsumerQueue)object).next;
        }
        if (object == null) {
            object = new ImageConsumerQueue(this, imageConsumer);
            ((ImageConsumerQueue)object).next = this.consumers;
            this.consumers = object;
        } else {
            if (!((ImageConsumerQueue)object).secure) {
                Object object2 = null;
                SecurityManager securityManager = System.getSecurityManager();
                if (securityManager != null) {
                    object2 = securityManager.getSecurityContext();
                }
                if (((ImageConsumerQueue)object).securityContext == null) {
                    ((ImageConsumerQueue)object).securityContext = object2;
                } else if (!((ImageConsumerQueue)object).securityContext.equals(object2)) {
                    this.errorConsumer((ImageConsumerQueue)object, false);
                    throw new SecurityException("Applets are trading image data!");
                }
            }
            ((ImageConsumerQueue)object).interested = true;
        }
        if (bl2 && this.decoder == null) {
            this.startProduction();
        }
    }

    abstract boolean checkSecurity(Object var1, boolean var2);

    synchronized void printQueues(String string) {
        System.out.println(string + "[ -----------");
        this.printQueue(this.consumers, "  ");
        ImageDecoder imageDecoder = this.decoders;
        while (imageDecoder != null) {
            System.out.println("    " + imageDecoder);
            this.printQueue(imageDecoder.queue, "      ");
            imageDecoder = imageDecoder.next;
        }
        System.out.println("----------- ]" + string);
    }

    int countConsumers(ImageConsumerQueue imageConsumerQueue) {
        int n2 = 0;
        while (imageConsumerQueue != null) {
            ++n2;
            imageConsumerQueue = imageConsumerQueue.next;
        }
        return n2;
    }

    private void errorAllConsumers(ImageConsumerQueue imageConsumerQueue, boolean bl2) {
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested) {
                this.errorConsumer(imageConsumerQueue, bl2);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    private void errorConsumer(ImageConsumerQueue imageConsumerQueue, boolean bl2) {
        imageConsumerQueue.consumer.imageComplete(1);
        if (bl2 && imageConsumerQueue.consumer instanceof ImageRepresentation) {
            ((ImageRepresentation)imageConsumerQueue.consumer).image.flush();
        }
        this.removeConsumer(imageConsumerQueue.consumer);
    }

    protected abstract ImageDecoder getDecoder();

    synchronized void doneDecoding(ImageDecoder imageDecoder) {
        if (this.decoder == imageDecoder) {
            this.decoder = null;
            if (this.consumers != null) {
                this.startProduction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void latchConsumers(ImageDecoder imageDecoder) {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            if (imageDecoder != this.decoder) {
                return;
            }
            imageConsumerQueue = this.consumers;
        }
        while (imageConsumerQueue != null) {
            inputStreamImageSource = this;
            synchronized (inputStreamImageSource) {
                if (!imageConsumerQueue.interested) {
                    imageConsumerQueue = imageConsumerQueue.next;
                    continue;
                }
            }
            if (!imageDecoder.catchupConsumer(this, imageConsumerQueue.consumer)) {
                inputStreamImageSource = this;
                synchronized (inputStreamImageSource) {
                    this.doneDecoding(imageDecoder);
                    return;
                }
            }
            inputStreamImageSource = this;
            synchronized (inputStreamImageSource) {
                ImageConsumerQueue imageConsumerQueue2 = imageConsumerQueue.next;
                if (imageConsumerQueue.interested) {
                    this.consumers = ImageConsumerQueue.removeConsumer(this.consumers, imageConsumerQueue.consumer, true);
                    imageConsumerQueue.next = imageDecoder.queue;
                    imageDecoder.queue = imageConsumerQueue;
                }
                imageConsumerQueue = imageConsumerQueue2;
            }
        }
    }

    private synchronized void removeDecoder(ImageDecoder imageDecoder) {
        this.doneDecoding(imageDecoder);
        ImageDecoder imageDecoder2 = null;
        ImageDecoder imageDecoder3 = this.decoders;
        while (imageDecoder3 != null) {
            if (imageDecoder3 == imageDecoder) {
                if (imageDecoder2 == null) {
                    this.decoders = imageDecoder3.next;
                    break;
                }
                imageDecoder2.next = imageDecoder3.next;
                break;
            }
            imageDecoder2 = imageDecoder3;
            imageDecoder3 = imageDecoder3.next;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setDecoder(ImageDecoder imageDecoder) {
        ImageConsumerQueue imageConsumerQueue;
        InputStreamImageSource inputStreamImageSource = this;
        synchronized (inputStreamImageSource) {
            imageDecoder.next = this.decoders;
            this.decoders = imageDecoder;
            this.decoder = imageDecoder;
            imageDecoder.queue = imageConsumerQueue = this.consumers;
            this.consumers = null;
            this.awaitingFetch = false;
        }
        while (imageConsumerQueue != null) {
            if (imageConsumerQueue.interested && !this.checkSecurity(imageConsumerQueue.securityContext, true)) {
                this.errorConsumer(imageConsumerQueue, false);
            }
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    synchronized void printQueue(ImageConsumerQueue imageConsumerQueue, String string) {
        while (imageConsumerQueue != null) {
            System.out.println(string + imageConsumerQueue);
            imageConsumerQueue = imageConsumerQueue.next;
        }
    }

    protected ImageDecoder getDecoder(InputStream inputStream) {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        try {
            inputStream.mark(8);
            int n2 = inputStream.read();
            int n3 = inputStream.read();
            int n4 = inputStream.read();
            int n5 = inputStream.read();
            int n6 = inputStream.read();
            int n7 = inputStream.read();
            int n8 = inputStream.read();
            int n9 = inputStream.read();
            inputStream.reset();
            inputStream.mark(-1);
            if (n2 == 71 && n3 == 73 && n4 == 70 && n5 == 56) {
                return new GifImageDecoder(this, inputStream);
            }
            if (n2 == 255 && n3 == 216 && n4 == 255) {
                return new JPEGImageDecoder(this, inputStream);
            }
            if (n2 == 35 && n3 == 100 && n4 == 101 && n5 == 102) {
                return new XbmImageDecoder(this, inputStream);
            }
            if (n2 == 137 && n3 == 80 && n4 == 78 && n5 == 71 && n6 == 13 && n7 == 10 && n8 == 26 && n9 == 10) {
                return new PNGImageDecoder(this, inputStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    synchronized void setPixelStore(ImageDecoder imageDecoder, PixelStore pixelStore) {
        if (imageDecoder == this.decoder) {
            this.pixelstore = pixelStore;
        }
    }

    protected ImageDecoder decoderForType(InputStream inputStream, String string) {
        return null;
    }
}

