/*
 * Decompiled with CFR 0.152.
 */
package sun.java2d.loops;

import java.util.Arrays;
import java.util.Comparator;
import sun.java2d.loops.CompositeType;
import sun.java2d.loops.CustomComponent;
import sun.java2d.loops.GeneralRenderer;
import sun.java2d.loops.GraphicsPrimitive;
import sun.java2d.loops.GraphicsPrimitiveProxy;
import sun.java2d.loops.SurfaceType;

public final class GraphicsPrimitiveMgr {
    private static final boolean debugTrace = false;
    private static GraphicsPrimitive[] primitives;
    private static GraphicsPrimitive[] generalPrimitives;
    private static boolean needssort;
    private static Comparator primSorter;
    private static Comparator primFinder;
    static Class class$sun$java2d$loops$GraphicsPrimitive;
    static Class class$sun$java2d$loops$SurfaceType;
    static Class class$sun$java2d$loops$CompositeType;
    static Class class$sun$java2d$SunGraphics2D;
    static Class class$java$awt$Color;
    static Class class$sun$java2d$loops$XORComposite;
    static Class class$java$awt$AlphaComposite;

    static {
        needssort = true;
        GraphicsPrimitiveMgr.initIDs(class$sun$java2d$loops$GraphicsPrimitive == null ? (class$sun$java2d$loops$GraphicsPrimitive = GraphicsPrimitiveMgr.class$("sun.java2d.loops.GraphicsPrimitive")) : class$sun$java2d$loops$GraphicsPrimitive, class$sun$java2d$loops$SurfaceType == null ? (class$sun$java2d$loops$SurfaceType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.SurfaceType")) : class$sun$java2d$loops$SurfaceType, class$sun$java2d$loops$CompositeType == null ? (class$sun$java2d$loops$CompositeType = GraphicsPrimitiveMgr.class$("sun.java2d.loops.CompositeType")) : class$sun$java2d$loops$CompositeType, class$sun$java2d$SunGraphics2D == null ? (class$sun$java2d$SunGraphics2D = GraphicsPrimitiveMgr.class$("sun.java2d.SunGraphics2D")) : class$sun$java2d$SunGraphics2D, class$java$awt$Color == null ? (class$java$awt$Color = GraphicsPrimitiveMgr.class$("java.awt.Color")) : class$java$awt$Color, class$sun$java2d$loops$XORComposite == null ? (class$sun$java2d$loops$XORComposite = GraphicsPrimitiveMgr.class$("sun.java2d.loops.XORComposite")) : class$sun$java2d$loops$XORComposite, class$java$awt$AlphaComposite == null ? (class$java$awt$AlphaComposite = GraphicsPrimitiveMgr.class$("java.awt.AlphaComposite")) : class$java$awt$AlphaComposite);
        CustomComponent.register();
        GeneralRenderer.register();
        GraphicsPrimitiveMgr.registerNativeLoops();
        primSorter = new Comparator(){

            public int compare(Object object, Object object2) {
                int n2;
                int n3 = ((GraphicsPrimitive)object).getUniqueID();
                return n3 == (n2 = ((GraphicsPrimitive)object2).getUniqueID()) ? 0 : (n3 < n2 ? -1 : 1);
            }
        };
        primFinder = new Comparator(){

            public int compare(Object object, Object object2) {
                int n2;
                int n3 = ((GraphicsPrimitive)object).getUniqueID();
                return n3 == (n2 = ((PrimitiveSpec)object2).uniqueID) ? 0 : (n3 < n2 ? -1 : 1);
            }
        };
    }

    private GraphicsPrimitiveMgr() {
    }

    private static native void registerNativeLoops();

    public static void testPrimitiveInstantiation() {
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(false);
    }

    public static void testPrimitiveInstantiation(boolean bl2) {
        int n2 = 0;
        int n3 = 0;
        GraphicsPrimitive[] graphicsPrimitiveArray = primitives;
        for (int i2 = 0; i2 < graphicsPrimitiveArray.length; ++i2) {
            GraphicsPrimitive graphicsPrimitive = graphicsPrimitiveArray[i2];
            if (graphicsPrimitive instanceof GraphicsPrimitiveProxy) {
                GraphicsPrimitive graphicsPrimitive2 = ((GraphicsPrimitiveProxy)graphicsPrimitive).instantiate();
                if (!graphicsPrimitive2.getSignature().equals(graphicsPrimitive.getSignature()) || graphicsPrimitive2.getUniqueID() != graphicsPrimitive.getUniqueID()) {
                    System.out.println("r.getSignature == " + graphicsPrimitive2.getSignature());
                    System.out.println("r.getUniqueID == " + graphicsPrimitive2.getUniqueID());
                    System.out.println("p.getSignature == " + graphicsPrimitive.getSignature());
                    System.out.println("p.getUniqueID == " + graphicsPrimitive.getUniqueID());
                    throw new RuntimeException("Primitive " + graphicsPrimitive + " returns wrong signature for " + graphicsPrimitive2.getClass());
                }
                ++n3;
                graphicsPrimitive = graphicsPrimitive2;
                if (!bl2) continue;
                System.out.println(graphicsPrimitive);
                continue;
            }
            if (bl2) {
                System.out.println(graphicsPrimitive + " (not proxied).");
            }
            ++n2;
        }
        System.out.println(n2 + " graphics primitives were not proxied.");
        System.out.println(n3 + " proxied graphics primitives resolved correctly.");
        System.out.println(n2 + n3 + " total graphics primitives");
    }

    private static void writeLog(String string) {
    }

    public static void main(String[] stringArray) {
        if (needssort) {
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        GraphicsPrimitiveMgr.testPrimitiveInstantiation(stringArray.length > 0);
    }

    private static GraphicsPrimitive locateGeneral(int n2) {
        if (generalPrimitives == null) {
            return null;
        }
        for (int i2 = 0; i2 < generalPrimitives.length; ++i2) {
            GraphicsPrimitive graphicsPrimitive = generalPrimitives[i2];
            if (graphicsPrimitive.getPrimTypeID() != n2) continue;
            return graphicsPrimitive;
        }
        return null;
    }

    public static synchronized void registerGeneral(GraphicsPrimitive graphicsPrimitive) {
        if (generalPrimitives == null) {
            generalPrimitives = new GraphicsPrimitive[]{graphicsPrimitive};
            return;
        }
        int n2 = generalPrimitives.length;
        GraphicsPrimitive[] graphicsPrimitiveArray = new GraphicsPrimitive[n2 + 1];
        System.arraycopy(generalPrimitives, 0, graphicsPrimitiveArray, 0, n2);
        graphicsPrimitiveArray[n2] = graphicsPrimitive;
        generalPrimitives = graphicsPrimitiveArray;
    }

    public static synchronized void register(GraphicsPrimitive[] graphicsPrimitiveArray) {
        GraphicsPrimitive[] graphicsPrimitiveArray2 = primitives;
        int n2 = 0;
        int n3 = graphicsPrimitiveArray.length;
        if (graphicsPrimitiveArray2 != null) {
            n2 = graphicsPrimitiveArray2.length;
        }
        GraphicsPrimitive[] graphicsPrimitiveArray3 = new GraphicsPrimitive[n2 + n3];
        if (graphicsPrimitiveArray2 != null) {
            System.arraycopy(graphicsPrimitiveArray2, 0, graphicsPrimitiveArray3, 0, n2);
        }
        System.arraycopy(graphicsPrimitiveArray, 0, graphicsPrimitiveArray3, n2, n3);
        needssort = true;
        primitives = graphicsPrimitiveArray3;
    }

    static Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private static GraphicsPrimitive locate(PrimitiveSpec primitiveSpec) {
        Object[] objectArray;
        if (needssort) {
            if (GraphicsPrimitive.traceflags != 0) {
                for (int i2 = 0; i2 < primitives.length; ++i2) {
                    GraphicsPrimitiveMgr.primitives[i2] = primitives[i2].traceWrap();
                }
            }
            Arrays.sort(primitives, primSorter);
            needssort = false;
        }
        if ((objectArray = primitives) == null) {
            return null;
        }
        int n2 = Arrays.binarySearch(objectArray, primitiveSpec, primFinder);
        if (n2 >= 0) {
            Object object = objectArray[n2];
            if (object instanceof GraphicsPrimitiveProxy) {
                objectArray[n2] = object = ((GraphicsPrimitiveProxy)object).instantiate();
            }
            return object;
        }
        return null;
    }

    public static synchronized GraphicsPrimitive locate(int n2, SurfaceType surfaceType) {
        return GraphicsPrimitiveMgr.locate(n2, SurfaceType.OpaqueColor, CompositeType.Src, surfaceType);
    }

    public static synchronized GraphicsPrimitive locate(int n2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locatePrim(n2, surfaceType, compositeType, surfaceType2);
        if (graphicsPrimitive == null && (graphicsPrimitive = GraphicsPrimitiveMgr.locateGeneral(n2)) != null && (graphicsPrimitive = graphicsPrimitive.makePrimitive(surfaceType, compositeType, surfaceType2)) != null && GraphicsPrimitive.traceflags != 0) {
            graphicsPrimitive = graphicsPrimitive.traceWrap();
        }
        return graphicsPrimitive;
    }

    public static synchronized GraphicsPrimitive locatePrim(int n2, SurfaceType surfaceType, CompositeType compositeType, SurfaceType surfaceType2) {
        PrimitiveSpec primitiveSpec = new PrimitiveSpec(null);
        for (SurfaceType surfaceType3 = surfaceType2; surfaceType3 != null; surfaceType3 = surfaceType3.getSuperType()) {
            for (SurfaceType surfaceType4 = surfaceType; surfaceType4 != null; surfaceType4 = surfaceType4.getSuperType()) {
                for (CompositeType compositeType2 = compositeType; compositeType2 != null; compositeType2 = compositeType2.getSuperType()) {
                    primitiveSpec.uniqueID = GraphicsPrimitive.makeUniqueID(n2, surfaceType4, compositeType2, surfaceType3);
                    GraphicsPrimitive graphicsPrimitive = GraphicsPrimitiveMgr.locate(primitiveSpec);
                    if (graphicsPrimitive == null) continue;
                    return graphicsPrimitive;
                }
            }
        }
        return null;
    }

    private static native void initIDs(Class var0, Class var1, Class var2, Class var3, Class var4, Class var5, Class var6);

    private static class PrimitiveSpec {
        public int uniqueID;

        private PrimitiveSpec() {
        }

        PrimitiveSpec(1 var1_1) {
            this();
        }
    }
}

