/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.DNSName;
import sun.security.x509.GeneralNameInterface;
import sun.security.x509.IPAddressName;

public class URIName
implements GeneralNameInterface {
    private String name;
    private String scheme;
    private String host;
    private String remainder;
    private IPAddressName hostIP;
    private DNSName hostDNS;

    public int getType() {
        return 6;
    }

    public int hashCode() {
        return this.name.toUpperCase().hashCode();
    }

    public int subtreeDepth() throws UnsupportedOperationException {
        DNSName dNSName = null;
        try {
            dNSName = new DNSName(this.host);
        }
        catch (IOException iOException) {
            throw new UnsupportedOperationException(iOException.getMessage());
        }
        int n2 = dNSName.subtreeDepth();
        return n2;
    }

    private void parseName() throws IOException {
        int n2;
        int n3;
        int n4 = this.name.indexOf(58);
        if (n4 < 0) {
            throw new IOException("Name " + this.name + " does not include a <scheme>");
        }
        int n5 = this.name.indexOf("//", n4);
        if (n5 != n4 + 1) {
            throw new IOException("name does not include scheme-specific portion starting with host");
        }
        int n6 = n5 + 2;
        if (n6 == this.name.length()) {
            throw new IOException("Name " + this.name + " doesn't include a <host>");
        }
        int n7 = this.name.indexOf(93, n6);
        if (n7 >= 0) {
            n6 = n7;
        }
        if ((n3 = this.name.indexOf(47, n6)) < 0) {
            n3 = this.name.length();
        }
        if ((n2 = this.name.indexOf(64, n5 + 2) + 1) <= 0 || n2 >= n3) {
            n2 = n5 + 2;
        }
        int n8 = -1;
        if (this.name.charAt(n2) == '[') {
            n8 = this.name.indexOf(93, n2);
            if (n8 < 0) {
                throw new IOException("Invalid IPv6 address as host: missing ]");
            }
            if (n8 < this.name.length() - 1) {
                char c2 = this.name.charAt(n8 + 1);
                if (c2 != ':' && c2 != '/') {
                    throw new IOException("Invalid host[:port][/] boundary");
                }
                ++n8;
            } else {
                n8 = n3;
            }
        } else {
            n8 = this.name.indexOf(58, n2);
            if (n8 < 0 || n8 >= n3) {
                n8 = n3;
            }
        }
        this.scheme = this.name.substring(0, n4);
        this.host = this.name.substring(n2, n8);
        if (this.host.length() > 0) {
            if (this.host.charAt(0) == '[') {
                String string = this.host.substring(1, this.host.length() - 1);
                try {
                    this.hostIP = new IPAddressName(string);
                }
                catch (IOException iOException) {
                    throw new IOException("Host portion is not a valid IPv6 address: " + iOException.getMessage());
                }
            }
            try {
                this.hostDNS = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
            }
            catch (IOException iOException) {
                try {
                    this.hostIP = new IPAddressName(this.host);
                }
                catch (Exception exception) {
                    throw new IOException("Host portion is not a valid DNS name, IPv4 address, or IPv6 address");
                }
            }
        }
        this.remainder = this.name.substring(n4, n2);
        if (n8 < this.name.length()) {
            this.remainder = this.remainder + this.name.substring(n8);
        }
    }

    public Object getHostObject() {
        if (this.hostIP != null) {
            return this.hostIP;
        }
        return this.hostDNS;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof URIName)) {
            return false;
        }
        URIName uRIName = (URIName)object;
        if (this.name.equalsIgnoreCase(uRIName.getName())) {
            String string;
            if (this.remainder == null ^ (string = uRIName.getRemainder()) == null) {
                return false;
            }
            if (this.remainder != null && string != null) {
                return this.remainder.equals(string);
            }
            return true;
        }
        return false;
    }

    public String getHost() {
        return this.host;
    }

    public String getName() {
        return this.name;
    }

    public String getRemainder() {
        return this.remainder;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String toString() {
        return "URIName: " + this.name;
    }

    public URIName(String string) throws IOException {
        if (string == null || string.length() == 0) {
            throw new IOException("URI name must not be null");
        }
        this.name = string;
        this.parseName();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        derOutputStream.putIA5String(this.name);
    }

    public URIName(DerValue derValue) throws IOException {
        this.name = derValue.getIA5String();
        this.parseName();
    }

    public int constrains(GeneralNameInterface generalNameInterface) throws UnsupportedOperationException {
        int n2;
        if (generalNameInterface == null) {
            n2 = -1;
        } else if (generalNameInterface.getType() != 6) {
            n2 = -1;
        } else {
            String string = ((URIName)generalNameInterface).getScheme();
            String string2 = ((URIName)generalNameInterface).getHost();
            if (!this.scheme.equalsIgnoreCase(string)) {
                n2 = 3;
            } else if (string2.equals(this.host)) {
                n2 = 0;
            } else {
                if (((URIName)generalNameInterface).getHostObject() instanceof IPAddressName && this.hostIP != null) {
                    return this.hostIP.constrains((IPAddressName)((URIName)generalNameInterface).getHostObject());
                }
                if (string2.charAt(0) == '.' || this.host.charAt(0) == '.') {
                    try {
                        DNSName dNSName = this.host.charAt(0) == '.' ? new DNSName(this.host.substring(1)) : new DNSName(this.host);
                        DNSName dNSName2 = string2.charAt(0) == '.' ? new DNSName(string2.substring(1)) : new DNSName(string2);
                        n2 = dNSName.constrains(dNSName2);
                    }
                    catch (IOException iOException) {
                        n2 = 3;
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        n2 = 3;
                    }
                } else {
                    n2 = 3;
                }
            }
        }
        return n2;
    }
}

