/*
 * Decompiled with CFR 0.152.
 */
package sun.text;

public final class CompactShortArray
implements Cloneable {
    public static final int UNICODECOUNT = 65536;
    static final int BLOCKSHIFT = 7;
    static final int BLOCKCOUNT = 128;
    static final int INDEXSHIFT = 9;
    static final int INDEXCOUNT = 512;
    static final int BLOCKMASK = 127;
    private short[] values;
    private short[] indices;
    private int[] hashes;
    private boolean isCompact;
    short defaultValue;

    public int hashCode() {
        int n2 = 0;
        int n3 = Math.min(3, this.values.length / 16);
        for (int i2 = 0; i2 < this.values.length; i2 += n3) {
            n2 = n2 * 37 + this.values[i2];
        }
        return n2;
    }

    public CompactShortArray() {
        this(0);
    }

    public void compact() {
        if (!this.isCompact) {
            int n2 = 0;
            int n3 = 0;
            int n4 = -1;
            int n5 = 0;
            while (n5 < this.indices.length) {
                this.indices[n5] = -1;
                boolean bl2 = this.blockTouched(n5);
                if (!bl2 && n4 != -1) {
                    this.indices[n5] = n4;
                } else {
                    int n6 = 0;
                    int n7 = 0;
                    n7 = 0;
                    while (n7 < n2) {
                        if (this.hashes[n5] == this.hashes[n7] && CompactShortArray.arrayRegionMatches(this.values, n3, this.values, n6, 128)) {
                            this.indices[n5] = (short)n6;
                        }
                        ++n7;
                        n6 += 128;
                    }
                    if (this.indices[n5] == -1) {
                        System.arraycopy(this.values, n3, this.values, n6, 128);
                        this.indices[n5] = (short)n6;
                        this.hashes[n7] = this.hashes[n5];
                        ++n2;
                        if (!bl2) {
                            n4 = (short)n6;
                        }
                    }
                }
                ++n5;
                n3 += 128;
            }
            n5 = n2 * 128;
            short[] sArray = new short[n5];
            System.arraycopy(this.values, 0, sArray, 0, n5);
            this.values = sArray;
            this.isCompact = true;
            this.hashes = null;
        }
    }

    private void expand() {
        if (this.isCompact) {
            int n2;
            short[] sArray = new short[65536];
            for (n2 = 0; n2 < 65536; ++n2) {
                sArray[n2] = this.elementAt((char)n2);
            }
            for (n2 = 0; n2 < 512; ++n2) {
                this.indices[n2] = (short)(n2 << 7);
            }
            this.values = null;
            this.values = sArray;
            this.isCompact = false;
        }
    }

    public short[] getIndexArray() {
        return this.indices;
    }

    public short[] getStringArray() {
        return this.values;
    }

    public short elementAt(char c2) {
        return this.values[(this.indices[c2 >> 7] & 0xFFFF) + (c2 & 0x7F)];
    }

    public void setElementAt(char n2, char c2, short s2) {
        if (this.isCompact) {
            this.expand();
        }
        for (int i2 = n2; i2 <= c2; ++i2) {
            this.values[i2] = s2;
            this.touchBlock(i2 >> 7, s2);
        }
    }

    public void setElementAt(char c2, short s2) {
        if (this.isCompact) {
            this.expand();
        }
        this.values[c2] = s2;
        this.touchBlock(c2 >> 7, s2);
    }

    private final boolean blockTouched(int n2) {
        return this.hashes[n2] != 0;
    }

    private final void touchBlock(int n2, int n3) {
        this.hashes[n2] = this.hashes[n2] + (n3 << 1) | 1;
    }

    public CompactShortArray(short s2) {
        int n2;
        this.values = new short[65536];
        this.indices = new short[512];
        this.hashes = new int[512];
        for (n2 = 0; n2 < 65536; ++n2) {
            this.values[n2] = s2;
        }
        for (n2 = 0; n2 < 512; ++n2) {
            this.indices[n2] = (short)(n2 << 7);
            this.hashes[n2] = 0;
        }
        this.isCompact = false;
        this.defaultValue = s2;
    }

    public static final boolean arrayRegionMatches(short[] sArray, int n2, short[] sArray2, int n3, int n4) {
        int n5 = n2 + n4;
        int n6 = n3 - n2;
        for (int i2 = n2; i2 < n5; ++i2) {
            if (sArray[i2] == sArray2[i2 + n6]) continue;
            return false;
        }
        return true;
    }

    public CompactShortArray(short[] sArray, short[] sArray2, short s2) {
        if (sArray.length != 512) {
            throw new IllegalArgumentException("Index out of bounds.");
        }
        for (int i2 = 0; i2 < 512; ++i2) {
            short s3 = sArray[i2];
            if (s3 >= 0 && s3 < sArray2.length + 128) continue;
            throw new IllegalArgumentException("Index out of bounds.");
        }
        this.indices = sArray;
        this.values = sArray2;
        this.isCompact = true;
        this.defaultValue = s2;
    }

    public Object clone() {
        try {
            CompactShortArray compactShortArray = (CompactShortArray)super.clone();
            compactShortArray.values = (short[])this.values.clone();
            compactShortArray.indices = (short[])this.indices.clone();
            return compactShortArray;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CompactShortArray compactShortArray = (CompactShortArray)object;
        for (int i2 = 0; i2 < 65536; ++i2) {
            if (this.elementAt((char)i2) == compactShortArray.elementAt((char)i2)) continue;
            return false;
        }
        return true;
    }

    static short[] access$000(CompactShortArray compactShortArray) {
        return compactShortArray.indices;
    }

    public Iterator getIterator() {
        return new Iterator(this);
    }

    public class Iterator {
        int nextIndex;
        int index;
        short nextValue;
        short value;
        short iUntouched;
        boolean touched;
        short defValue;
        private final CompactShortArray this$0;

        public char next() {
            if (this.index == this.nextIndex && !this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            this.index = this.nextIndex;
            this.value = this.nextValue;
            return (char)this.index;
        }

        public short shortValue() {
            return this.value;
        }

        public boolean hasNext() {
            this.nextIndex = this.index;
            boolean bl2 = true;
            if (this.index != this.nextIndex) {
                return true;
            }
            while (++this.nextIndex < 65535) {
                if ((this.nextIndex & 0x7F) == 0) {
                    int n2 = this.nextIndex >> 7;
                    if (CompactShortArray.access$000(this.this$0)[n2] == this.iUntouched) {
                        this.nextIndex += 127;
                        continue;
                    }
                    if (this.iUntouched == -1 && !this.touched) {
                        this.iUntouched = CompactShortArray.access$000(this.this$0)[n2 - 1];
                    } else {
                        this.touched = false;
                    }
                }
                this.nextValue = this.this$0.elementAt((char)this.nextIndex);
                if (this.nextValue == this.defValue) continue;
                this.touched = true;
                break;
            }
            return this.nextIndex < 65535;
        }

        Iterator(CompactShortArray compactShortArray) {
            this.this$0 = compactShortArray;
            this.nextIndex = -1;
            this.index = -1;
            this.iUntouched = (short)-1;
            this.touched = true;
            this.defValue = this.this$0.defaultValue;
            compactShortArray.compact();
        }
    }
}

