/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.archive.ResourceReader;
import com.installshield.archive.ResourceWriter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

public class ArchiveWriterRecord {
    private Hashtable writerDates = new Hashtable();
    private Hashtable readerDates = new Hashtable();
    private Hashtable writeMap = new Hashtable();

    public ArchiveWriterRecord() {
    }

    public ArchiveWriterRecord(InputStream inputStream) throws IOException {
        this.read(inputStream);
    }

    private String format(String string) {
        char[] cArray = new char[string.length() * 2];
        int n = 0;
        int n2 = 0;
        while (n2 < string.length()) {
            cArray[n] = string.charAt(n2);
            if (cArray[n++] == '\\') {
                cArray[n++] = 92;
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public Date getDate(ResourceReader resourceReader) {
        String string = resourceReader.getId();
        return string != null ? (Date)this.readerDates.get(string) : null;
    }

    public Date getDate(ResourceWriter resourceWriter) {
        String string = resourceWriter.getId();
        return string != null ? (Date)this.writerDates.get(string) : null;
    }

    private void parseLine(String string) {
        try {
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.format(string)));
            if (streamTokenizer.nextToken() != -1) {
                String string2 = streamTokenizer.sval;
                if (streamTokenizer.nextToken() != -1) {
                    String string3 = streamTokenizer.sval;
                    if (streamTokenizer.nextToken() != -1) {
                        if (string2.equals("read") && streamTokenizer.ttype == -2) {
                            this.readerDates.put(string3, new Date((long)streamTokenizer.nval));
                        } else if (string2.equals("write") && streamTokenizer.ttype == -2) {
                            this.writerDates.put(string3, new Date((long)streamTokenizer.nval));
                        } else if (string2.equals("map") && streamTokenizer.sval != null) {
                            this.writeMap.put(string3, streamTokenizer.sval);
                        }
                    }
                }
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void read(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string = bufferedReader.readLine();
        boolean bl = false;
        while (string != null && !string.equals("end record")) {
            if (bl || !string.equals("begin record")) {
                this.parseLine(string);
            }
            string = bufferedReader.readLine();
        }
    }

    public boolean readerWrittenBy(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        String string = resourceReader.getId();
        Object object = string != null ? (Object)this.writeMap.get(string) : null;
        return object != null ? object.equals(resourceWriter.getId()) : false;
    }

    public void record(ResourceReader resourceReader, ResourceWriter resourceWriter) {
        String string = resourceReader.getId();
        Date date = resourceReader.getDate();
        String string2 = resourceWriter.getId();
        Date date2 = resourceWriter.getDate();
        if (string != null && date != null && string2 != null && date2 != null) {
            this.readerDates.put(string, date);
            this.writerDates.put(string2, date2);
            this.writeMap.put(string, string2);
        }
    }

    public void write(OutputStream outputStream) throws IOException {
        Object object;
        Object object2;
        Object object3;
        PrintWriter printWriter = new PrintWriter(outputStream);
        printWriter.println("begin record");
        Enumeration enumeration = this.readerDates.keys();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = (Date)this.readerDates.get(object3);
            printWriter.println("read \"" + (String)object3 + "\" " + ((Date)object2).getTime());
        }
        object3 = this.writerDates.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = (Date)this.writerDates.get(object2);
            printWriter.println("write \"" + (String)object2 + "\" " + ((Date)object).getTime());
        }
        object2 = this.writeMap.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            printWriter.println("map \"" + (String)object + "\" \"" + (String)this.writeMap.get(object) + "\"");
        }
        printWriter.println("end record");
        printWriter.flush();
    }
}

