/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive;

import com.installshield.util.MetaInf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Dictionary;

public class MediaInf
extends MetaInf {
    public static final String RESOURCE_NAME = "media.inf";
    private static final String MEDIA_ID = "MEDIA_ID";
    private static final int DEFAULT_MEDIA_ID = 1;
    private int mediaId;

    public MediaInf() {
        this.initializeDefaults();
    }

    public MediaInf(int n) {
        this.mediaId = n;
    }

    public MediaInf(InputStream inputStream) throws IOException {
        super(inputStream);
    }

    public MediaInf(URL uRL) throws IOException {
        super(uRL);
    }

    public String getFileName() {
        return "MEDIA.INF";
    }

    public int getMediaId() {
        return this.mediaId;
    }

    private void initializeDefaults() {
        this.mediaId = 1;
    }

    public void read(Dictionary dictionary) {
        this.initializeDefaults();
        if (dictionary.get(MEDIA_ID) != null) {
            this.mediaId = Integer.parseInt((String)dictionary.get(MEDIA_ID));
        }
    }

    public void setMediaId(int n) {
        this.mediaId = n;
    }

    public void write(OutputStream outputStream) throws IOException {
        PrintWriter printWriter = new PrintWriter(outputStream, true);
        printWriter.println("MEDIA_ID: " + this.mediaId);
    }
}

