/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.archive.index;

public class ResourceIndexRange
implements Comparable {
    private int offset;
    private int length;

    public ResourceIndexRange(int n) {
        this(n, 1);
    }

    public ResourceIndexRange(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset: " + n);
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("length: " + n2);
        }
        this.offset = n;
        this.length = n2;
    }

    public ResourceIndexRange(ResourceIndexRange resourceIndexRange) {
        this(resourceIndexRange.offset, resourceIndexRange.length);
    }

    public int compareTo(Object object) {
        ResourceIndexRange resourceIndexRange = (ResourceIndexRange)object;
        if (this.offset == resourceIndexRange.offset) {
            return resourceIndexRange.length - this.length;
        }
        return this.offset - resourceIndexRange.offset;
    }

    public int getRangeLength() {
        return this.length;
    }

    public int getRangeOffset() {
        return this.offset;
    }

    public boolean merge(ResourceIndexRange resourceIndexRange) {
        if (this.offset == resourceIndexRange.offset) {
            this.length = Math.max(this.length, resourceIndexRange.length);
            return true;
        }
        if (this.offset < resourceIndexRange.offset) {
            if (this.offset + this.length < resourceIndexRange.offset) {
                return false;
            }
            this.length = Math.max(this.length, resourceIndexRange.offset + resourceIndexRange.length - this.offset);
            return true;
        }
        return false;
    }
}

