/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.isje.AliasListener;
import com.installshield.isje.AliasesDialog;
import com.installshield.isje.EditAliasDialog;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.util.AliasRepository;
import com.installshield.util.AliasUtil;
import com.installshield.util.FileUtils;
import com.installshield.util.StringUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileSystemView;

public class AliasFileChooser
extends JFileChooser {
    private AliasRepository aliasRepository = null;
    private AliasComponent aliasComponent = null;

    public AliasFileChooser() {
    }

    public AliasFileChooser(AliasRepository aliasRepository) {
        if (aliasRepository != null) {
            this.aliasRepository = aliasRepository;
            this.aliasComponent = new AliasComponent(this, this.aliasRepository);
            this.setAccessory(this.aliasComponent);
        }
    }

    public AliasFileChooser(File file) {
        this(file, null);
    }

    public AliasFileChooser(File file, FileSystemView fileSystemView) {
        super(file, fileSystemView);
    }

    public AliasFileChooser(FileSystemView fileSystemView) {
        super(fileSystemView);
    }

    protected JComponent getAliasAccessory() {
        return this.aliasComponent;
    }

    public String getSelectedFileAsString() {
        String string;
        String string2 = string = this.getSelectedFile() != null ? this.getSelectedFile().getAbsolutePath() : null;
        if (string != null) {
            string = StringUtils.replace(string, "$", "$$");
        }
        if (this.aliasComponent != null && string != null) {
            string = this.aliasComponent.getAliasString(string);
        }
        return string;
    }

    public String[] getSelectedFilesAsString() {
        File[] fileArray = this.getSelectedFiles();
        String[] stringArray = null;
        if (fileArray != null) {
            stringArray = new String[fileArray.length];
            int n = 0;
            while (n < fileArray.length) {
                String string = StringUtils.replace(fileArray[n].getAbsolutePath(), "$", "$$");
                stringArray[n] = this.aliasComponent == null ? string : this.aliasComponent.getAliasString(string);
                ++n;
            }
        }
        return stringArray;
    }

    public void setCurrentDirectory(String string) {
        if (this.aliasComponent != null && !this.aliasComponent.setCurrentAlias(string)) {
            this.setCurrentDirectory(new File(string));
        }
    }

    public void setSelectedFile(String string) {
        if (this.aliasComponent != null) {
            this.aliasComponent.setCurrentAlias(string);
        }
        this.setSelectedFile(new File(this.aliasRepository.getServices().resolveString(string)));
    }

    public void setSelectedFiles(String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            if (this.aliasComponent != null) {
                this.aliasComponent.setCurrentAlias(this.aliasRepository.getServices().resolveString(stringArray[0]));
            }
            File[] fileArray = new File[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                fileArray[n] = new File(this.aliasRepository.getServices().resolveString(stringArray[n]));
                ++n;
            }
            this.setSelectedFiles(fileArray);
        }
    }

    private class AliasComponent
    extends JPanel
    implements ItemListener,
    ActionListener,
    AliasListener,
    PropertyChangeListener {
        private JComboBox comboBox;
        private JButton createNewBtn;
        private AliasFileChooser fileChooser;
        private AliasesDialog dialog = null;
        private String currentAlias = null;
        private AliasRepository aliasRepository = null;
        private String currentDir = null;
        private final String NO_ALIAS = "<NONE>";

        public AliasComponent(AliasFileChooser aliasFileChooser2, AliasRepository aliasRepository) {
            this.fileChooser = aliasFileChooser2;
            this.aliasRepository = aliasRepository;
            this.fileChooser.addPropertyChangeListener(this);
            this.setLayout((LayoutManager)new ColumnLayout(0));
            JPanel jPanel = new JPanel(new BorderLayout());
            JPanel jPanel2 = new JPanel(new BorderLayout());
            jPanel.add((Component)new JLabel("Alias:"), "West");
            this.comboBox = new JComboBox();
            this.comboBox.addItemListener(this);
            this.fillCombo();
            jPanel2.add((Component)this.comboBox, "Center");
            this.createNewBtn = new JButton("...");
            this.createNewBtn.setPreferredSize(new Dimension(20, 15));
            this.createNewBtn.setRequestFocusEnabled(false);
            this.createNewBtn.setMnemonic('.');
            this.createNewBtn.addActionListener(this);
            jPanel2.add((Component)this.createNewBtn, "East");
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
            this.add((Component)jPanel, new ColumnConstraints(1, 2));
            this.add((Component)jPanel2, new ColumnConstraints(1, 2));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.dialog == null) {
                this.dialog = new AliasesDialog((Component)this, this.aliasRepository);
            } else {
                this.dialog.reset();
            }
            this.dialog.addAliasListener((AliasListener)this);
            this.dialog.setVisible(true);
            this.dialog.removeAliasListener((AliasListener)this);
        }

        public void aliasAdded(String string) {
            this.comboBox.addItem(string);
            this.comboBox.setSelectedItem(string);
        }

        public void aliasDeleted(String string) {
            this.comboBox.removeItem(string);
        }

        public void aliasPathChanged(String string) {
            String string2 = (String)this.comboBox.getSelectedItem();
            if (string2.equals(string)) {
                int n = this.comboBox.getSelectedIndex();
                this.comboBox.setSelectedIndex(-1);
                this.comboBox.setSelectedIndex(n);
            }
        }

        public void aliasRenamed(String string, String string2) {
            this.comboBox.removeItem(string);
            this.comboBox.addItem(string2);
            this.comboBox.setSelectedItem(string2);
        }

        private void fillCombo() {
            Enumeration enumeration = this.aliasRepository.getAliasNames();
            this.comboBox.addItem("<NONE>");
            while (enumeration.hasMoreElements()) {
                this.comboBox.addItem(enumeration.nextElement());
            }
            this.comboBox.setSelectedIndex(0);
        }

        public String getAliasString(String string) {
            String string2 = string = FileUtils.normalizeFileName(string, '/');
            String string3 = (String)this.comboBox.getSelectedItem();
            if (string3.equals("<NONE>")) {
                return string;
            }
            String string4 = FileUtils.normalizeFileName(this.aliasRepository.getAlias(string3), '/');
            if (this.isAliasable(string, string4)) {
                string2 = "$A(" + string3 + ")" + (string4.endsWith("/") ? "/" : "") + string.substring(string4.length());
            }
            return string2;
        }

        private boolean isAliasable(String string, String string2) {
            string = FileUtils.normalizeFileName(string, '/');
            string2 = FileUtils.normalizeFileName(string2, '/');
            if (!FileUtils.isFileSystemCaseSensitive()) {
                string2 = string2.toLowerCase();
                string = string.toLowerCase();
            }
            if (string2.endsWith(File.separator)) {
                int n = string2.lastIndexOf(File.separator);
                string2 = string2.substring(0, n);
            } else if (string2.endsWith("/")) {
                int n = string2.lastIndexOf("/");
                string2 = string2.substring(0, n);
            }
            return string.startsWith(string2);
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            if (itemEvent.getSource() == this.comboBox && itemEvent.getStateChange() == 1) {
                String string = (String)((JComboBox)itemEvent.getSource()).getSelectedItem();
                if (string.equals("<NONE>")) {
                    return;
                }
                String string2 = this.aliasRepository.getAlias(string);
                if (new File(string2).isDirectory()) {
                    if (this.currentDir != null && new File(this.currentDir).exists()) {
                        this.currentDir = FileUtils.normalizeFileName(this.currentDir, '/');
                        this.fileChooser.setCurrentDirectory(new File(this.currentDir));
                    } else {
                        this.fileChooser.setCurrentDirectory(new File(string2));
                    }
                } else {
                    int n = JOptionPane.showConfirmDialog(null, String.valueOf(string2) + " denoted by alias " + string + " does not exist. Do you want to modify it?", "Alias", 0, 0);
                    if (n == 0) {
                        File file;
                        EditAliasDialog editAliasDialog = new EditAliasDialog((Component)this.fileChooser, "Edit Alias", this.aliasRepository, 2);
                        editAliasDialog.setAliasName(string);
                        editAliasDialog.setAliasPath(string2);
                        editAliasDialog.setVisible(true);
                        if (editAliasDialog.getModalResult() == "ok" && (file = new File(this.aliasRepository.getAlias(string))).isDirectory()) {
                            this.fileChooser.setCurrentDirectory(file);
                            return;
                        }
                    }
                    this.comboBox.setSelectedItem("<NONE>");
                }
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string;
            if (propertyChangeEvent.getPropertyName().equals("directoryChanged") && this.comboBox != null && this.aliasRepository != null && !(string = (String)this.comboBox.getSelectedItem()).equals("<NONE>")) {
                String string2 = this.aliasRepository.getAlias(string);
                String string3 = this.fileChooser.getCurrentDirectory().getAbsolutePath();
                if (!this.isAliasable(string3, string2)) {
                    this.comboBox.setSelectedItem("<NONE>");
                }
            }
        }

        public boolean setCurrentAlias(String string) {
            boolean bl = true;
            String string2 = AliasUtil.getAliasNameFromPath(string);
            if (string2 == null) {
                return bl ^ true;
            }
            if (this.aliasRepository.aliasExists(string2)) {
                this.currentDir = this.aliasRepository.getServices().resolveString(string);
                this.comboBox.setSelectedItem(string2);
                this.currentDir = null;
            } else {
                int n = JOptionPane.showConfirmDialog(this.fileChooser, "Alias " + string2 + " does not exist. Do you want to create it ?", "Alias", 0, 0);
                if (n == 0) {
                    EditAliasDialog editAliasDialog = new EditAliasDialog((Component)this.fileChooser, "Add Alias", this.aliasRepository, 1);
                    editAliasDialog.setAliasName(string2);
                    editAliasDialog.setVisible(true);
                    if (editAliasDialog.getModalResult() == "ok") {
                        if (this.aliasRepository.aliasExists(string2)) {
                            this.aliasAdded(string2);
                        } else {
                            bl = false;
                        }
                    } else {
                        bl = false;
                    }
                }
                if (!bl) {
                    this.comboBox.setSelectedItem("<NONE>");
                }
            }
            return bl;
        }
    }
}

