/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.archive.ArchiveTypeInfo;
import com.installshield.beans.editors.AbstractEditor;
import com.installshield.beans.editors.ArchiveTypeInfoEditorUI;
import com.installshield.beans.editors.EditorUI;

public class ArchiveTypeInfoEditor
extends AbstractEditor {
    private static final String UNKNOWN_ARCHIVE_NAME = "Unknown Archive Type";
    static final String ZIP_ARCHIVE_NAME = "Single Jar Archive";
    static final String DIR_ARCHIVE_NAME = "Directory Archive";
    static final String CUSTOM_ARCHIVE_NAME = "Custom Size Archive";
    static final String CDROM_ARCHIVE_NAME = "CDROM Archive";
    private ArchiveTypeInfo archiveType = new ArchiveTypeInfo();

    private boolean acceptValue(ArchiveTypeInfo archiveTypeInfo) {
        boolean bl = false;
        if (archiveTypeInfo.getArchiveType() == 1 || archiveTypeInfo.getArchiveType() == 2) {
            bl = true;
        } else if (archiveTypeInfo.getArchiveType() == 3 || archiveTypeInfo.getArchiveType() == 4) {
            bl = true;
        }
        return bl;
    }

    protected EditorUI createUI() {
        return new ArchiveTypeInfoEditorUI();
    }

    public String getAsText() {
        String string = UNKNOWN_ARCHIVE_NAME;
        switch (this.archiveType.getArchiveType()) {
            case 1: {
                string = ZIP_ARCHIVE_NAME;
                break;
            }
            case 2: {
                string = DIR_ARCHIVE_NAME;
                break;
            }
            case 3: {
                string = CUSTOM_ARCHIVE_NAME;
                break;
            }
            case 4: {
                string = CDROM_ARCHIVE_NAME;
                break;
            }
        }
        return string;
    }

    public Object getValue() {
        return this.archiveType;
    }

    public void setAsText(String string) {
    }

    public void setValue(Object object) {
        if (!(object instanceof ArchiveTypeInfo)) {
            throw new IllegalArgumentException("value must be ArchiveTypeInfo");
        }
        ArchiveTypeInfo archiveTypeInfo = (ArchiveTypeInfo)object;
        if (!this.acceptValue(archiveTypeInfo)) {
            throw new IllegalArgumentException("Archive type is invalid: " + archiveTypeInfo.getArchiveType());
        }
        this.archiveType = (ArchiveTypeInfo)object;
    }
}

