/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.archive.ArchiveTypeInfo;
import com.installshield.beans.editors.EditorUI;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ArchiveTypeInfoEditorUI
extends JPanel
implements EditorUI,
ActionListener {
    private static long SIZE_NOT_APPLICABLE = -1L;
    private static String SIZE_NOT_APPLICABLE_STRING = "n\\a";
    private static String UNKNOWN_TYPE_STRING = "Unknown archive type";
    private JComboBox archiveTypeCB = null;
    private JTextField mediaSizeField;
    private JTextField blockSizeField;
    private JButton generateButton;

    public ArchiveTypeInfoEditorUI() {
        this.setLayout((LayoutManager)new ColumnLayout());
        JPanel jPanel = new JPanel((LayoutManager)new ColumnLayout(6));
        this.add((Component)jPanel, new ColumnConstraints(2, 2));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Archive Type", 1, 2), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        this.archiveTypeCB = new JComboBox(this.createArchiveTypeVector());
        jPanel.add((Component)this.archiveTypeCB, new ColumnConstraints(2, 2));
        JPanel jPanel2 = new JPanel((LayoutManager)new ColumnLayout(4));
        this.add((Component)jPanel2, new ColumnConstraints(2, 2));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Archive Size Information", 1, 2), BorderFactory.createEmptyBorder(6, 6, 6, 6)));
        JPanel jPanel3 = new JPanel(new BorderLayout(5, 5));
        jPanel3.add((Component)new JLabel("Media Size:"), "West");
        this.mediaSizeField = new JTextField(12);
        jPanel3.add((Component)this.mediaSizeField, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(6, 6));
        jPanel4.add((Component)new JLabel("Block Size:"), "West");
        this.blockSizeField = new JTextField(12);
        jPanel4.add((Component)this.blockSizeField, "Center");
        jPanel2.add((Component)jPanel3, ColumnConstraints.createHorizontalFill());
        jPanel2.add((Component)jPanel4, ColumnConstraints.createHorizontalFill());
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n = 1;
        long l = -1L;
        long l2 = -1L;
        String string = (String)this.archiveTypeCB.getSelectedItem();
        if (string.equals("Directory Archive")) {
            n = 2;
            l = -1L;
            l2 = -1L;
        } else if (string.equals("Single Jar Archive")) {
            n = 1;
            l = -1L;
            l2 = -1L;
        } else if (string.equals("Custom Size Archive")) {
            n = 3;
            l = this.mediaSizeField.getText().equals(SIZE_NOT_APPLICABLE_STRING) ? 681984000L : Long.parseLong(this.mediaSizeField.getText());
            l2 = this.blockSizeField.getText().equals(SIZE_NOT_APPLICABLE_STRING) ? 2048L : Long.parseLong(this.blockSizeField.getText());
        } else if (string.equals("CDROM Archive")) {
            n = 4;
            l = 681984000L;
            l2 = 2048L;
        }
        this.configureSizeFields(n, l, l2);
    }

    private void configureSizeFields(int n, long l, long l2) {
        if (l == SIZE_NOT_APPLICABLE) {
            this.mediaSizeField.setText(SIZE_NOT_APPLICABLE_STRING);
        } else {
            this.mediaSizeField.setText(Long.toString(l));
        }
        if (l2 == SIZE_NOT_APPLICABLE) {
            this.blockSizeField.setText(SIZE_NOT_APPLICABLE_STRING);
        } else {
            this.blockSizeField.setText(Long.toString(l2));
        }
        boolean bl = false;
        if (n == 3) {
            bl = true;
        }
        this.mediaSizeField.setEditable(bl);
        this.blockSizeField.setEditable(bl);
    }

    private Vector createArchiveTypeVector() {
        Vector<String> vector = new Vector<String>();
        vector.addElement("Directory Archive");
        vector.addElement("Single Jar Archive");
        vector.addElement("Custom Size Archive");
        vector.addElement("CDROM Archive");
        return vector;
    }

    private void disableListeners() {
        this.archiveTypeCB.removeActionListener(this);
    }

    private void enableListeners() {
        this.archiveTypeCB.addActionListener(this);
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "Archive Type Info";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        ArchiveTypeInfo archiveTypeInfo = (ArchiveTypeInfo)propertyEditor.getValue();
        switch (archiveTypeInfo.getArchiveType()) {
            case 2: {
                this.archiveTypeCB.setSelectedItem("Directory Archive");
                break;
            }
            case 1: {
                this.archiveTypeCB.setSelectedItem("Single Jar Archive");
                break;
            }
            case 3: {
                this.archiveTypeCB.setSelectedItem("Custom Size Archive");
                break;
            }
            case 4: {
                this.archiveTypeCB.setSelectedItem("CDROM Archive");
                break;
            }
            default: {
                throw new IllegalArgumentException("Archive type is invalid: " + archiveTypeInfo.getArchiveType());
            }
        }
        this.configureSizeFields(archiveTypeInfo.getArchiveType(), archiveTypeInfo.getMediaSize(), archiveTypeInfo.getBlockSize());
        this.enableListeners();
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        ArchiveTypeInfo archiveTypeInfo = new ArchiveTypeInfo();
        String string = (String)this.archiveTypeCB.getSelectedItem();
        if (string.equals("Directory Archive")) {
            archiveTypeInfo = new ArchiveTypeInfo(2);
        } else if (string.equals("Single Jar Archive")) {
            archiveTypeInfo = new ArchiveTypeInfo(1);
        } else if (string.equals("Custom Size Archive")) {
            archiveTypeInfo = new ArchiveTypeInfo(3);
            long l = 681984000L;
            boolean bl = false;
            try {
                l = Long.parseLong(this.mediaSizeField.getText());
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl || l <= 0L) {
                l = 681984000L;
            }
            archiveTypeInfo.setMediaSize(l);
            long l2 = 2048L;
            bl = false;
            try {
                l2 = Long.parseLong(this.blockSizeField.getText());
            }
            catch (Exception exception) {
                bl = true;
            }
            if (bl || l2 <= 0L) {
                l2 = 2048L;
            }
            archiveTypeInfo.setBlockSize(l2);
        } else if (string.equals("CDROM Archive")) {
            archiveTypeInfo = new ArchiveTypeInfo(4);
        }
        propertyEditor.setValue(archiveTypeInfo);
        this.disableListeners();
    }
}

