/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AliasFileChooser;
import com.installshield.beans.editors.FileNameEditorUI;
import com.installshield.isje.actions.LaunchURL;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.util.AliasRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;

public class BundledJVMEditorUI
extends FileNameEditorUI {
    public BundledJVMEditorUI() {
        this.setAliasSupport(true);
        this.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".exe") || file.getName().endsWith(".bin");
            }

            public String getDescription() {
                return " Bundled JVMs(*.exe, *.bin)";
            }
        });
    }

    protected AliasFileChooser createAliasFileChooser(AliasRepository aliasRepository) {
        return new BundledJVMFileChooser(aliasRepository);
    }

    public String getTitle() {
        return "Choose a Bundled JVM";
    }

    private class BundledJVMFileChooser
    extends AliasFileChooser
    implements ActionListener {
        JButton download;

        public BundledJVMFileChooser(AliasRepository aliasRepository) {
            super(aliasRepository);
            JComponent jComponent = this.getAliasAccessory();
            this.download = new JButton("Download...");
            this.download.addActionListener(this);
            this.download.setMnemonic('d');
            JPanel jPanel = new JPanel(new BorderLayout());
            jPanel.add((Component)this.download, "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            JPanel jPanel2 = new JPanel((LayoutManager)new ColumnLayout(0));
            if (jComponent == null) {
                jPanel2.add((Component)jPanel, ColumnConstraints.createLeftAlign());
            } else {
                jPanel2.add((Component)jComponent, ColumnConstraints.createLeftAlign());
                jPanel2.add((Component)jPanel, ColumnConstraints.createLeftAlign());
            }
            this.setAccessory(jPanel2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new LaunchURL("", 6).actionPerformed(new ActionEvent(this, 1, ""));
        }

        public void approveSelection() {
            String string = this.getSelectedFileAsString();
            if (!string.toLowerCase().endsWith(".jvm")) {
                super.approveSelection();
            } else {
                JOptionPane.showMessageDialog(this, "Files with a \".jvm\" extension are not bundled JVMs. Bundled JVMs are self-extracting archives containing the JVM and usually have a \".bin\" or a \".exe\" extension.", "Bundled JVM", 1);
            }
        }
    }
}

