/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.ColorStringEditor;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.TagSelectionUI;
import com.installshield.beans.tableview.JTableInlineEditor;
import com.installshield.util.PropertyUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.beans.PropertyEditor;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;

public class ColorStringEditorUI
extends TagSelectionUI
implements EditorUI,
JTableInlineEditor {
    private static final String COLOR_BLACK = "Color.black";
    private static final String COLOR_BLUE = "Color.blue";
    private static final String COLOR_CYAN = "Color.cyan";
    private static final String COLOR_DARK_GRAY = "Color.darkGray";
    private static final String COLOR_GRAY = "Color.gray";
    private static final String COLOR_GREEN = "Color.green";
    private static final String COLOR_LIGHT_GRAY = "Color.lightGray";
    private static final String COLOR_MAGENTA = "Color.magenta";
    private static final String COLOR_ORANGE = "Color.orange";
    private static final String COLOR_PINK = "Color.pink";
    private static final String COLOR_RED = "Color.red";
    private static final String COLOR_WHITE = "Color.white";
    private static final String COLOR_YELLOW = "Color.yellow";
    private static final String SYSCOLOR_ACTIVE_CAPTION = "SystemColor.activeCaption";
    private static final String SYSCOLOR_CAPTION_BORDER = "SystemColor.activeCaptionBorder";
    private static final String SYSCOLOR_ACTIVE_CAPTION_TEXT = "SystemColor.activeCaptionText";
    private static final String SYSCOLOR_CONTROL = "SystemColor.control";
    private static final String SYSCOLOR_CONTROL_DK_SHADOW = "SystemColor.controlDkShadow";
    private static final String SYSCOLOR_CONTROL_HIGHLIGHT = "SystemColor.controlHighlight";
    private static final String SYSCOLOR_CONTROL_LT_HIGHTLIGHT = "SystemColor.controlLtHighlight";
    private static final String SYSCOLOR_CONTROL_SHADOW = "SystemColor.controlShadow";
    private static final String SYSCOLOR_CONTROL_TEXT = "SystemColor.controlText";
    private static final String SYSCOLOR_DESKTOP = "SystemColor.desktop";
    private static final String SYSCOLOR_INACTIVE_CAPTION = "SystemColor.inactiveCaption";
    private static final String SYSCOLOR_INACTIVE_CAPTION_BORDER = "SystemColor.inactiveCaptionBorder";
    private static final String SYSCOLOR_INACTIVE_CAPTION_TEXT = "SystemColor.inactiveCaptionText";
    private static final String SYSCOLOR_INFO = "SystemColor.info";
    private static final String SYSCOLOR_INFO_TEXT = "SystemColor.infoText";
    private static final String SYSCOLOR_MENU = "SystemColor.menu";
    private static final String SYSCOLOR_MENU_TEXT = "SystemColor.menuText";
    private static final String SYSCOLOR_SCROLLBAR = "SystemColor.scrollbar";
    private static final String SYSCOLOR_TEXT = "SystemColor.text";
    private static final String SYSCOLOR_TEXT_HIGHLIGHT = "SystemColor.textHighlight";
    private static final String SYSCOLOR_TEXT_HIGHLIGHT_TEXT = "SystemColor.textHighlightText";
    private static final String SYSCOLOR_TEXT_INACTIVE_TEXT = "SystemColor.textInactiveText";
    private static final String SYSCOLOR_TEXT_TEXT = "SystemColor.textText";
    private static final String SYSCOLOR_WINDOW = "SystemColor.window";
    private static final String SYSCOLOR_WINDOW_BORDER = "SystemColor.windowBorder";
    private static final String SYSCOLOR_WINDOW_TEXT = "SystemColor.windowText";
    private static JColorChooser colorChooser = null;
    private final ListItem NONE = new ListItem("__none__");
    private final ListItem MORE_COLORS = new ListItem("__more__");
    private boolean focusLost = false;
    private boolean colorChooserVisible = false;
    private boolean settingItem = false;
    private String curColorStr = "";

    public ColorStringEditorUI() {
        this.setRenderer(new ColorCellRenderer());
        this.addItem(this.NONE);
        this.addItem(this.MORE_COLORS);
        this.addItem(new ListItem(COLOR_BLACK));
        this.addItem(new ListItem(COLOR_BLUE));
        this.addItem(new ListItem(COLOR_CYAN));
        this.addItem(new ListItem(COLOR_DARK_GRAY));
        this.addItem(new ListItem(COLOR_GRAY));
        this.addItem(new ListItem(COLOR_GREEN));
        this.addItem(new ListItem(COLOR_LIGHT_GRAY));
        this.addItem(new ListItem(COLOR_MAGENTA));
        this.addItem(new ListItem(COLOR_ORANGE));
        this.addItem(new ListItem(COLOR_PINK));
        this.addItem(new ListItem(COLOR_RED));
        this.addItem(new ListItem(COLOR_WHITE));
        this.addItem(new ListItem(COLOR_YELLOW));
        this.addItem(new ListItem(SYSCOLOR_ACTIVE_CAPTION));
        this.addItem(new ListItem(SYSCOLOR_CAPTION_BORDER));
        this.addItem(new ListItem(SYSCOLOR_ACTIVE_CAPTION_TEXT));
        this.addItem(new ListItem(SYSCOLOR_CONTROL));
        this.addItem(new ListItem(SYSCOLOR_CONTROL_DK_SHADOW));
        this.addItem(new ListItem(SYSCOLOR_CONTROL_HIGHLIGHT));
        this.addItem(new ListItem(SYSCOLOR_CONTROL_LT_HIGHTLIGHT));
        this.addItem(new ListItem(SYSCOLOR_CONTROL_SHADOW));
        this.addItem(new ListItem(SYSCOLOR_CONTROL_TEXT));
        this.addItem(new ListItem(SYSCOLOR_DESKTOP));
        this.addItem(new ListItem(SYSCOLOR_INACTIVE_CAPTION));
        this.addItem(new ListItem(SYSCOLOR_INACTIVE_CAPTION_BORDER));
        this.addItem(new ListItem(SYSCOLOR_INACTIVE_CAPTION_TEXT));
        this.addItem(new ListItem(SYSCOLOR_INFO));
        this.addItem(new ListItem(SYSCOLOR_INFO_TEXT));
        this.addItem(new ListItem(SYSCOLOR_MENU));
        this.addItem(new ListItem(SYSCOLOR_MENU_TEXT));
        this.addItem(new ListItem(SYSCOLOR_SCROLLBAR));
        this.addItem(new ListItem(SYSCOLOR_TEXT));
        this.addItem(new ListItem(SYSCOLOR_TEXT_HIGHLIGHT));
        this.addItem(new ListItem(SYSCOLOR_TEXT_HIGHLIGHT_TEXT));
        this.addItem(new ListItem(SYSCOLOR_TEXT_INACTIVE_TEXT));
        this.addItem(new ListItem(SYSCOLOR_TEXT_TEXT));
        this.addItem(new ListItem(SYSCOLOR_WINDOW));
        this.addItem(new ListItem(SYSCOLOR_WINDOW_BORDER));
        this.addItem(new ListItem(SYSCOLOR_WINDOW_TEXT));
    }

    static /* synthetic */ String access$1(ColorStringEditorUI colorStringEditorUI) {
        return colorStringEditorUI.curColorStr;
    }

    protected void fireTagSelected() {
        if (this.colorChooserVisible) {
            return;
        }
        if (this.getSelectedItem().equals(this.NONE)) {
            this.curColorStr = "";
        } else if (this.getSelectedItem().equals(this.MORE_COLORS)) {
            if (!this.focusLost) {
                if (colorChooser == null) {
                    colorChooser = new JColorChooser();
                }
                ActionListener actionListener = new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        Color color = colorChooser.getColor();
                        ColorStringEditorUI.this.curColorStr = String.valueOf(color.getRed()) + "," + color.getGreen() + "," + color.getBlue();
                    }
                };
                colorChooser.setColor(PropertyUtils.createColor(this.curColorStr, Color.white));
                JDialog jDialog = JColorChooser.createDialog(this.getDialogParent(), "Color", true, colorChooser, actionListener, null);
                this.colorChooserVisible = true;
                ((Component)jDialog).setVisible(true);
                this.colorChooserVisible = false;
            }
        } else {
            this.curColorStr = ((ListItem)this.getSelectedItem()).colorStr;
        }
        super.fireTagSelected();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (!this.isPopupVisible()) {
            this.focusLost = true;
            this.fireTagSelected();
        }
    }

    public Component getComponent() {
        return this;
    }

    private Component getDialogParent() {
        Container container = this;
        while (container.getParent() != null) {
            container = container.getParent();
        }
        return container;
    }

    public String getTitle() {
        return "Color";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        this.curColorStr = propertyEditor.getValue() != null ? propertyEditor.getValue().toString() : "";
        this.focusLost = false;
        if (this.curColorStr.length() == 0) {
            this.setSelectedItem(this.NONE);
        } else {
            ListItem listItem = new ListItem(this.curColorStr);
            int n = -1;
            int n2 = 0;
            while (n == -1 && n2 < this.getItemCount()) {
                if (this.getItemAt(n2).equals(listItem)) {
                    n = n2;
                }
                ++n2;
            }
            if (n != -1) {
                this.setSelectedIndex(n);
            } else {
                this.insertItemAt(listItem, 2);
                this.setSelectedItem(listItem);
            }
        }
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        propertyEditor.setValue(this.curColorStr);
    }

    private class ListItem {
        private String colorStr;
        private ColorStringEditor editor = new ColorStringEditor();

        ListItem(String string) {
            this.colorStr = string;
        }

        public boolean equals(Object object) {
            return object instanceof ListItem && ((ListItem)object).colorStr.equals(this.colorStr);
        }

        public int hashCode() {
            return this.colorStr.hashCode();
        }

        public String toString() {
            if (this.equals(ColorStringEditorUI.this.NONE)) {
                return "Default";
            }
            if (this.equals(ColorStringEditorUI.this.MORE_COLORS)) {
                return "More Colors...";
            }
            this.editor.setValue(this.colorStr);
            return this.editor.getAsText();
        }
    }

    protected class ColorCellRenderer
    extends TagSelectionUI.TagRenderer {
        protected ColorCellRenderer() {
            super(ColorStringEditorUI.this);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent(jList, object, n, bl, bl2);
            jLabel.setIcon(new ColorIcon((ListItem)object));
            jLabel.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 0));
            return jLabel;
        }
    }

    private class ColorIcon
    implements Icon {
        Color c;

        ColorIcon(ListItem listItem) {
            this.c = PropertyUtils.createColor(listItem.colorStr, null);
        }

        public int getIconHeight() {
            return 10;
        }

        public int getIconWidth() {
            return 10;
        }

        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (this.c != null) {
                graphics.setColor(this.c);
                graphics.fillRect(n, n2, this.getIconWidth(), this.getIconHeight());
                graphics.setColor(Color.black);
                graphics.drawRect(n, n2, this.getIconWidth(), this.getIconHeight());
            }
        }
    }
}

