/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.BeanEditor;
import com.installshield.beans.BeanEditorException;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.PropertyDialog;
import com.installshield.beans.tableview.JTableInlineEditor;
import com.installshield.swing.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class EllipsesEditorUI
extends JPanel
implements EditorUI,
JTableInlineEditor,
ActionListener,
FocusListener {
    private Frame frame = null;
    private JTextField text = null;
    private JButton button = null;
    private PropertyEditor editor = null;
    private PropertyDescriptor pd = null;
    private Object bean = null;
    private TableCellEditor cellEditor = null;
    private PropertyDialog propertyDialog = null;
    private Vector actionListeners = new Vector();
    private boolean dialogVisible = false;

    public EllipsesEditorUI() {
        this.setLayout(new BorderLayout());
        this.button = new JButton("...");
        this.button.setPreferredSize(new Dimension(20, 15));
        this.button.setRequestFocusEnabled(false);
        this.add((Component)this.button, "East");
        this.text = new JTextField();
        this.text.setEditable(false);
        this.text.addFocusListener(this);
        this.text.setBackground(SystemColor.window);
        this.add((Component)this.text, "Center");
        this.button.addActionListener(this);
        this.setBackground(SystemColor.window);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block10: {
            Container container = this;
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            if (container == null) break block10;
            this.frame = (Frame)container;
            if (this.editor != null) {
                try {
                    this.editor.setValue(BeanEditor.getPropertyValue(this.bean, this.pd));
                    Component component = this.editor.getCustomEditor();
                    if (this.propertyDialog != null && ((Component)((Object)this.propertyDialog)).isVisible()) {
                        return;
                    }
                    if (this.propertyDialog == null) {
                        this.propertyDialog = new PropertyDialog(this.frame);
                    }
                    this.propertyDialog.setComponent(component);
                    if (component instanceof EditorUI) {
                        ((Dialog)((Object)this.propertyDialog)).setTitle(((EditorUI)((Object)component)).getTitle());
                        this.propertyDialog.setCancelable(((EditorUI)((Object)component)).supportsCancel());
                    } else {
                        ((Dialog)((Object)this.propertyDialog)).setTitle("");
                        this.propertyDialog.setCancelable(true);
                    }
                    ModalDialog.center((JDialog)((Object)this.propertyDialog), (Rectangle)this.frame.getBounds());
                    this.dialogVisible = true;
                    this.propertyDialog.setVisible(true);
                    this.dialogVisible = false;
                    if (this.propertyDialog.getModalResult() == "ok") {
                        if (component instanceof EditorUI) {
                            ((EditorUI)((Object)component)).writeToEditor(this.editor);
                        }
                        this.text.setText(this.editor.getAsText());
                        this.text.requestFocus();
                        this.fireActionPerformed();
                    }
                    this.cellEditor.cancelCellEditing();
                }
                catch (BeanEditorException beanEditorException) {
                    beanEditorException.printStackTrace();
                }
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    protected void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.text.getText());
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.text && !this.dialogVisible) {
            this.fireActionPerformed();
        }
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "Edit Property";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        this.text.setText(propertyEditor.getAsText());
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    public void setup(Object object, PropertyDescriptor propertyDescriptor, PropertyEditor propertyEditor, TableCellEditor tableCellEditor) {
        this.bean = object;
        this.pd = propertyDescriptor;
        this.editor = propertyEditor;
        this.cellEditor = tableCellEditor;
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        propertyEditor.setValue(propertyEditor.getValue());
    }
}

