/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.ExtendedPropertyEditor;
import java.lang.reflect.Field;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class EnumerationPropertyEditor
extends ExtendedPropertyEditor {
    private String[] _tags = null;
    private String _attributeName = "enumerationValues";
    private Hashtable _valuesTable = new Hashtable();
    private Object _currentValue = null;
    private String _currentName = null;

    private String[] convertVectorToArray(Vector vector) {
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof String) {
                stringArray[n] = (String)e;
            }
            ++n;
        }
        return stringArray;
    }

    protected Object createDefaultValue(String string) {
        try {
            return new Integer(string);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String getAsText() {
        return this._currentName;
    }

    public String[] getExtendedAttributeNames() {
        return new String[]{this._attributeName};
    }

    private Object getReflectionValue(String string) {
        int n = string.lastIndexOf(".");
        if (n == -1) {
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string2);
            Field field = clazz.getDeclaredField(string3);
            return field.get(null);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getTags() {
        return this._tags;
    }

    public Object getValue() {
        return this._currentValue;
    }

    private void parseEnumerationValues(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        Vector<String> vector = new Vector<String>();
        String string = null;
        Object object = null;
        int n = 0;
        while (n < objectArray.length) {
            Object object2 = objectArray[n];
            if (n % 3 == 0) {
                string = object2.toString();
                vector.addElement(string);
            } else if (n % 3 == 1) {
                object = object2;
            } else {
                String string2 = object2.toString();
                Object object3 = this.getReflectionValue(string2);
                if (object3 != null) {
                    object = object3;
                }
                this._valuesTable.put(string, object);
            }
            ++n;
        }
        if (vector.size() > 0) {
            this._tags = this.convertVectorToArray(vector);
        }
    }

    public void setAsText(String string) {
        Object v = this._valuesTable.get(string);
        if (v != null) {
            this._currentName = string;
            this._currentValue = v;
            this.firePropertyChange();
        } else {
            this._currentValue = this.createDefaultValue(string);
            this._currentName = string;
            this.firePropertyChange();
        }
    }

    public void setExtendedAttributeValue(String string, Object object) {
        if (!this._attributeName.equals(string) || !(object instanceof Object[])) {
            return;
        }
        Object[] objectArray = (Object[])object;
        this.parseEnumerationValues(objectArray);
    }

    public void setValue(Object object) {
        Enumeration enumeration = this._valuesTable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this._valuesTable.get(k);
            if (!v.equals(object)) continue;
            this._currentName = (String)k;
            this._currentValue = v;
            this.firePropertyChange();
            return;
        }
        this._currentName = "[Name Not Availble]";
        this._currentValue = object;
        this.firePropertyChange();
    }
}

