/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AliasFileChooser;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.tableview.JTableInlineEditor;
import com.installshield.isje.ISJE;
import com.installshield.util.AliasRepository;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class FileNameEditorUI
extends JPanel
implements ActionListener,
EditorUI,
JTableInlineEditor,
FocusListener {
    private JTextField text = new JTextField();
    private JButton browseButton = new JButton("...");
    private FileFilter fileFilter = null;
    private boolean dialogVisible = false;
    private Vector actionListeners = new Vector();
    protected String startLocation = null;
    private boolean secondClick = false;
    private boolean supportAlias = false;

    public FileNameEditorUI() {
        this.setLayout(new BorderLayout());
        this.addFocusListener(this);
        this.text.setBackground(SystemColor.window);
        this.text.addFocusListener(this);
        this.browseButton.setPreferredSize(new Dimension(20, 15));
        this.browseButton.addActionListener(this);
        this.browseButton.setRequestFocusEnabled(false);
        this.browseButton.setMnemonic(' ');
        this.add((Component)this.browseButton, "East");
        this.add((Component)this.text, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.browseButton == actionEvent.getSource() && !this.secondClick) {
            this.secondClick = true;
            this.launchBrowseDialog();
            this.secondClick = false;
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.text.addActionListener(actionListener);
        this.actionListeners.addElement(actionListener);
    }

    protected AliasFileChooser createAliasFileChooser(AliasRepository aliasRepository) {
        return new AliasFileChooser(aliasRepository);
    }

    protected void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, this.text.getText());
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this) {
            this.text.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.text && !this.dialogVisible) {
            this.fireActionPerformed();
        }
    }

    public String getAsText() {
        return this.text.getText();
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "File Name";
    }

    public Object getValue() {
        return this.getAsText();
    }

    protected void initializeFileChooser(AliasFileChooser aliasFileChooser) {
        aliasFileChooser.setDialogTitle("Select File");
        aliasFileChooser.setMultiSelectionEnabled(false);
        aliasFileChooser.setFileSelectionMode(0);
        this.dialogVisible = true;
        if (this.startLocation == null) {
            aliasFileChooser.setCurrentDirectory(this.text.getText());
        } else {
            aliasFileChooser.setCurrentDirectory(new File(this.startLocation));
        }
        this.dialogVisible = false;
        this.startLocation = null;
    }

    protected void launchBrowseDialog() {
        AliasFileChooser aliasFileChooser = null;
        AliasRepository aliasRepository = null;
        if (this.supportAlias) {
            aliasRepository = ISJE.getISJE().getAliasRepository();
        }
        aliasFileChooser = this.createAliasFileChooser(aliasRepository);
        this.initializeFileChooser(aliasFileChooser);
        aliasFileChooser.rescanCurrentDirectory();
        if (this.fileFilter != null) {
            aliasFileChooser.addChoosableFileFilter(this.fileFilter);
        }
        this.dialogVisible = true;
        int n = aliasFileChooser.showOpenDialog(this);
        this.text.requestFocus();
        this.dialogVisible = false;
        if (n == 0) {
            String string = aliasFileChooser.getSelectedFileAsString();
            if (string != null) {
                this.setAsText(string);
            }
            this.fireActionPerformed();
        }
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        this.text.setText(propertyEditor.getAsText());
    }

    public void removeActionListener(ActionListener actionListener) {
        this.text.removeActionListener(actionListener);
        this.actionListeners.removeElement(actionListener);
    }

    public void setAliasSupport(boolean bl) {
        this.supportAlias = bl;
    }

    public void setAsText(String string) {
        if (string == null) {
            this.text.setText("");
        } else {
            this.text.setText(string);
        }
    }

    protected void setFileFilter(FileFilter fileFilter) {
        this.fileFilter = fileFilter;
    }

    protected void setStartLocation(String string) {
        this.startLocation = string;
    }

    public void setValue(Object object) {
        if (object == null) {
            this.setAsText(null);
        } else if (object instanceof String) {
            this.setAsText((String)object);
        } else {
            throw new IllegalArgumentException("Value set must be of type String.");
        }
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        propertyEditor.setValue(this.text.getText());
    }
}

