/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.FontDefEditor;
import com.installshield.beans.editors.ValidatingEditorUI;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.swing.FieldLayout;
import com.installshield.util.FontDef;
import java.awt.Component;
import java.awt.LayoutManager;
import java.beans.PropertyEditor;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FontDefEditorUI
extends JPanel
implements ValidatingEditorUI {
    private JComboBox name;
    private JCheckBox bold;
    private JCheckBox italic;
    private JComboBox size;

    public FontDefEditorUI() {
        this.setLayout((LayoutManager)new FieldLayout());
        this.add(new JLabel("Font name:"));
        this.name = new JComboBox();
        this.add(this.name);
        this.name.setEditable(true);
        this.name.addItem("Dialog");
        this.name.addItem("SansSerif");
        this.name.addItem("Serif");
        this.add(new JLabel("Size:"));
        this.size = new JComboBox();
        this.add(this.size);
        this.size.setEditable(true);
        this.size.setMaximumRowCount(6);
        this.size.addItem("8");
        this.size.addItem("10");
        this.size.addItem("11");
        this.size.addItem("12");
        this.size.addItem("14");
        this.size.addItem("16");
        this.size.addItem("18");
        this.size.addItem("20");
        this.size.addItem("22");
        this.size.addItem("24");
        this.size.addItem("26");
        this.size.addItem("28");
        this.size.addItem("36");
        this.size.addItem("48");
        this.size.addItem("72");
        this.add(new JLabel("Font style:"));
        JPanel jPanel = new JPanel((LayoutManager)new ColumnLayout());
        this.add(jPanel);
        this.bold = new JCheckBox("Bold");
        jPanel.add((Component)this.bold, ColumnConstraints.createLeftAlign());
        this.italic = new JCheckBox("Italic");
        jPanel.add((Component)this.italic, ColumnConstraints.createLeftAlign());
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "Font";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        if (!(propertyEditor instanceof FontDefEditor)) {
            throw new IllegalArgumentException("expected editor type FontDefEditor");
        }
        FontDef fontDef = (FontDef)propertyEditor.getValue();
        if (fontDef == null) {
            fontDef = new FontDef();
        }
        this.name.setSelectedItem(fontDef.getName());
        this.bold.setSelected((fontDef.getStyle() & 1) != 0);
        this.italic.setSelected((fontDef.getStyle() & 2) != 0);
        this.size.setSelectedItem(String.valueOf(fontDef.getSize()));
    }

    public boolean supportsCancel() {
        return true;
    }

    public boolean validateData() {
        try {
            int n = Integer.parseInt(this.size.getSelectedItem().toString());
            if (n < 1 || n > 409) {
                throw new IllegalArgumentException();
            }
            return true;
        }
        catch (Throwable throwable) {
            JOptionPane.showMessageDialog(this, "Font size must be between 1 and 409 points.", "Font", 2);
            this.size.requestFocus();
            return false;
        }
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        int n;
        if (!(propertyEditor instanceof FontDefEditor)) {
            throw new IllegalArgumentException("expected editor type FontDefEditor");
        }
        String string = this.name.getSelectedItem().toString();
        int n2 = 0;
        if (this.bold.isSelected()) {
            n2 |= 1;
        }
        if (this.italic.isSelected()) {
            n2 |= 2;
        }
        try {
            n = Integer.parseInt(this.size.getSelectedItem().toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new Error();
        }
        propertyEditor.setValue(new FontDef(string, n2, n));
    }
}

