/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AliasFileChooser;
import com.installshield.isje.ISJE;
import com.installshield.util.AliasRepository;
import com.installshield.util.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditorSupport;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class ImageEditor
extends PropertyEditorSupport
implements ActionListener,
FocusListener,
DocumentListener {
    private String currentString = null;
    private JTextField stringField = new JTextField("");
    private JPanel fileSelectorPanel = new JPanel();
    private JPanel buttonPanel = new JPanel(new FlowLayout(0));
    private JButton browseButton = new JButton("Browse...");
    private AliasFileChooser fileChooser = null;
    private JButton closeImageButton = new JButton("OK");
    private JPanel imagePanel = new JPanel(new FlowLayout(1));
    private String imageName = "";
    private boolean supportAlias = false;

    public ImageEditor() {
        this(false);
    }

    public ImageEditor(Object object) {
        this(false);
    }

    public ImageEditor(Object object, boolean bl) {
        super(object);
        if (object instanceof String) {
            this.currentString = (String)object;
        }
        this.supportAlias = bl;
        this.initFileSelectorPanel();
        this.initFileChooserDialog();
    }

    public ImageEditor(boolean bl) {
        this.supportAlias = bl;
        this.initFileSelectorPanel();
        this.initFileChooserDialog();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (this.stringField.equals(object)) {
            String string = this.stringField.getText();
            if ("".equals(string) && this.currentString == null) {
                return;
            }
            this.setAsText(string);
        } else if (this.browseButton.equals(object)) {
            this.launchBrowseDialog();
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        Document document = documentEvent.getDocument();
        int n = document.getLength();
        try {
            String string = document.getText(0, n);
            this.imageName = this.getFileName(string);
            if ("".equals(string) && this.currentString == null) {
                this.firePropertyChange();
            } else {
                this.currentString = string;
                this.firePropertyChange();
            }
        }
        catch (BadLocationException badLocationException) {}
    }

    public void focusGained(FocusEvent focusEvent) {
        this.browseButton.requestFocus();
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    public String getAsText() {
        if (this.currentString == null) {
            return "";
        }
        return this.currentString;
    }

    public Component getCustomEditor() {
        return this.fileSelectorPanel;
    }

    public String getFileName(String string) {
        File file = new File(string);
        String string2 = file.getName();
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public Frame getParentFrame(Component component) {
        if (component == null) {
            String string = "Cannot get the parent frame of a null component.";
            throw new IllegalArgumentException(string);
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        if (container instanceof Frame) {
            return (Frame)container;
        }
        return this.getParentFrame(container);
    }

    public Object getValue() {
        return this.currentString;
    }

    private void initFileChooserDialog() {
        AliasRepository aliasRepository = null;
        if (this.supportAlias) {
            aliasRepository = ISJE.getISJE().getAliasRepository();
        }
        this.fileChooser = new AliasFileChooser(aliasRepository);
        this.fileChooser.setDialogTitle("Select Image");
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                boolean bl = false;
                String string = FileUtils.getName(file.getAbsolutePath());
                string = string.toLowerCase();
                if (file.isDirectory() || string.endsWith(".gif") || string.endsWith(".jpg")) {
                    bl = true;
                }
                return bl;
            }

            public String getDescription() {
                return " Images(*.jpg, *.gif)";
            }
        });
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
    }

    private void initFileSelectorPanel() {
        this.fileSelectorPanel.setLayout(new BorderLayout());
        this.stringField.addActionListener(this);
        this.stringField.setBackground(SystemColor.window);
        this.stringField.getDocument().addDocumentListener(this);
        this.browseButton.addActionListener(this);
        this.browseButton.setMnemonic('B');
        this.fileSelectorPanel.add((Component)this.stringField, "Center");
        this.buttonPanel.add(this.browseButton);
        this.fileSelectorPanel.add((Component)this.buttonPanel, "South");
        this.fileSelectorPanel.addFocusListener(this);
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    private void launchBrowseDialog() {
        this.fileChooser.rescanCurrentDirectory();
        int n = this.fileChooser.showOpenDialog(this.fileSelectorPanel);
        if (n != 0) {
            return;
        }
        String string = this.fileChooser.getSelectedFileAsString();
        if (string != null) {
            this.setAsText(string);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    public void requestFocus() {
        this.browseButton.requestFocus();
    }

    public void setAsText(String string) {
        this.currentString = string;
        if (string == null) {
            string = "";
        }
        this.stringField.setText(string);
        this.firePropertyChange();
        this.imageName = this.getFileName(string);
        this.setBackgrounds();
    }

    private void setBackgrounds() {
        Container container = this.fileSelectorPanel.getParent();
        if (container != null) {
            Color color = container.getBackground();
            this.fileSelectorPanel.setBackground(color);
            this.buttonPanel.setBackground(color);
        } else {
            this.fileSelectorPanel.setBackground(SystemColor.window);
            this.buttonPanel.setBackground(SystemColor.window);
        }
    }

    public void setValue(Object object) {
        if (object instanceof String) {
            this.setAsText((String)object);
        } else if (object == null) {
            this.setAsText(null);
        } else {
            String string = "Value set must be of type String.";
            throw new IllegalArgumentException(string);
        }
    }

    public boolean supportsCustomEditor() {
        return true;
    }
}

