/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AliasFileChooser;
import com.installshield.beans.editors.EditorUI;
import com.installshield.isje.ISJE;
import com.installshield.isje.actions.ActionUtils;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.swing.IndentedBorder;
import com.installshield.swing.Spacing;
import com.installshield.swing.SplitPane;
import com.installshield.util.FileUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyEditor;
import java.io.File;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;

public class ImageSourceEditorUI
extends JPanel
implements EditorUI {
    private JComboBox comboBox = null;
    private ImagePanel imagePane = null;
    private JTextField locTextField = null;
    private JList list = null;
    private String imagesDir = ISJE.getISJE().getProperty("images.dir");
    private String aliasedImagesDir = null;
    private AliasFileChooser fileChooser = null;
    private boolean canUpdateTextField = true;
    private boolean propogateDocChange = true;
    private boolean secondClick = false;
    private int otherDirIndex = -1;

    public ImageSourceEditorUI() {
        super(new BorderLayout(0, 7));
        this.createUI();
        this.initialize();
    }

    private void createUI() {
        JPanel jPanel = new JPanel(new BorderLayout(7, 0));
        this.comboBox = new JComboBox();
        this.comboBox.addItemListener(new ComboListener());
        this.comboBox.setMaximumRowCount(4);
        jPanel.add((Component)new JLabel("Look in:"), "West");
        jPanel.add((Component)this.comboBox, "Center");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        SplitPane splitPane = new SplitPane(SplitPane.HORIZONTAL_SPLIT);
        jPanel2.add((Component)splitPane);
        this.list = new JList();
        this.list.addListSelectionListener(new ListListener());
        this.list.setCellRenderer(new IconListCellRenderer());
        this.imagePane = new ImagePanel();
        this.imagePane.setBackground(Color.white);
        this.imagePane.setSize(200, 200);
        splitPane.setRightComponent((Component)this.imagePane);
        this.imagePane.setBorder(BorderFactory.createLineBorder(Color.black));
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.list);
        splitPane.setLeftComponent((Component)jScrollPane);
        jScrollPane.setBorder((Border)new IndentedBorder());
        JPanel jPanel3 = new JPanel(new BorderLayout(7, 0));
        this.locTextField = new JTextField(40);
        this.locTextField.getDocument().addDocumentListener(new TFDocumentListener());
        JButton jButton = new JButton("Browse");
        jButton.addActionListener(new ButtonActionListener());
        jPanel3.add((Component)new JLabel("File:"), "West");
        JPanel jPanel4 = new JPanel((LayoutManager)new ColumnLayout());
        jPanel4.add(Spacing.createVerticalSpacing((int)0), ColumnConstraints.createVerticalFill());
        jPanel4.add((Component)this.locTextField, ColumnConstraints.createHorizontalFill());
        jPanel4.add(Spacing.createVerticalSpacing((int)0), ColumnConstraints.createVerticalFill());
        jPanel3.add((Component)jPanel4, "Center");
        jPanel3.add((Component)jButton, "East");
        this.add((Component)jPanel, "North");
        this.add((Component)jPanel2, "Center");
        this.add((Component)jPanel3, "South");
        splitPane.setDividerLocation(150);
        this.setPreferredSize(new Dimension(450, 300));
    }

    private void displayImage(String string) {
        if (this.isImage(new File(string))) {
            this.imagePane.setImage(new ImageIcon(string));
        } else {
            this.imagePane.setImage(null);
        }
    }

    public Component getComponent() {
        return this;
    }

    private Vector getDirList(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                File file2 = new File(string, stringArray[n]);
                if (file2.isDirectory()) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    private String getImageDir(String string) {
        if (string != null && new File(string).isDirectory()) {
            return string;
        }
        String string2 = FileUtils.getParent(string);
        if (string2 != null && new File(string2).isDirectory()) {
            return string2;
        }
        return null;
    }

    private Vector getImagesList(String string) {
        Vector<String> vector = new Vector<String>();
        File file = new File(string);
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (stringArray != null && n < stringArray.length) {
                File file2 = new File(string, stringArray[n]);
                if (file2.isFile() && this.isImage(file2)) {
                    vector.addElement(stringArray[n]);
                }
                ++n;
            }
        }
        return vector;
    }

    public String getTitle() {
        return "Select Image";
    }

    private void initFileChooserDialog() {
        this.fileChooser = new AliasFileChooser(ISJE.getISJE().getAliasRepository());
        this.fileChooser.setDialogTitle("Select Image");
        this.fileChooser.setMultiSelectionEnabled(false);
        this.fileChooser.addChoosableFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || file.getName().endsWith(".gif") || file.getName().endsWith(".GIF") || file.getName().endsWith(".jpg") || file.getName().endsWith(".JPG");
            }

            public String getDescription() {
                return " Images(*.jpg, *.gif)";
            }
        });
        this.fileChooser.removeChoosableFileFilter(this.fileChooser.getAcceptAllFileFilter());
    }

    private void initialize() {
        this.aliasedImagesDir = this.imagesDir;
        File file = new File(this.imagesDir);
        if (!file.isAbsolute()) {
            this.aliasedImagesDir = "$A(IS_HOME)" + File.separatorChar + this.imagesDir;
            ISJE.getISJE();
            this.imagesDir = FileUtils.canonizePath(FileUtils.createFileName(ISJE.getHome(), this.imagesDir));
            this.imagesDir = FileUtils.normalizeFileName(this.imagesDir);
        }
        Vector vector = this.getDirList(this.imagesDir);
        int n = 0;
        while (n < vector.size()) {
            this.comboBox.addItem(vector.elementAt(n));
            ++n;
        }
        if (vector.size() > 0) {
            this.comboBox.setSelectedIndex(0);
        }
        this.initFileChooserDialog();
        this.locTextField.requestDefaultFocus();
    }

    private boolean isImage(File file) {
        return file.isFile() ? file.getName().endsWith(".gif") || file.getName().endsWith(".jpeg") || file.getName().endsWith(".jpg") || file.getName().endsWith(".GIF") || file.getName().endsWith(".JPG") : false;
    }

    private void launchBrowseDialog() {
        if (this.locTextField.getText().trim().length() > 0) {
            this.fileChooser.setCurrentDirectory(this.locTextField.getText());
        } else {
            this.fileChooser.setCurrentDirectory(new File(this.imagesDir));
        }
        this.fileChooser.rescanCurrentDirectory();
        int n = this.fileChooser.showOpenDialog(this);
        if (n != 0) {
            return;
        }
        String string = this.fileChooser.getSelectedFileAsString();
        if (string != null) {
            this.updateCombo(FileUtils.normalizeFileName(this.resolveString(string)));
            this.locTextField.setText(FileUtils.normalizeFileName(string));
        }
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        if (propertyEditor.getAsText() != null && !propertyEditor.getAsText().equals("")) {
            this.updateCombo(FileUtils.normalizeFileName(this.resolveString(propertyEditor.getAsText())));
            this.locTextField.setText(propertyEditor.getAsText());
        }
    }

    private String resolveString(String string) {
        return ISJE.getISJE().getServices().resolveString(string);
    }

    public boolean supportsCancel() {
        return true;
    }

    private void updateCombo(String string) {
        if (this.imagesDir != null) {
            int n;
            String string2 = string;
            boolean bl = false;
            while (string2 != null && !bl) {
                bl = FileUtils.comparePaths(this.imagesDir, string2);
                if (bl) continue;
                string2 = FileUtils.getParent(string2);
            }
            String string3 = string.substring(string.lastIndexOf(File.separatorChar) + 1);
            if (!bl) {
                String string4 = this.getImageDir(string);
                if (string4 != null) {
                    if (this.otherDirIndex != -1) {
                        this.comboBox.removeItemAt(this.otherDirIndex);
                    }
                    this.comboBox.insertItemAt(string4, 0);
                    n = this.otherDirIndex = 0;
                } else {
                    n = -1;
                }
            } else {
                int n2 = -1;
                int n3 = 0;
                while (n2 == -1 && n3 < this.comboBox.getItemCount()) {
                    File file = new File(String.valueOf(this.imagesDir) + File.separatorChar + this.comboBox.getItemAt(n3) + File.separatorChar + string3);
                    if (FileUtils.comparePaths(file.getAbsolutePath(), new File(string).getAbsolutePath())) {
                        n2 = n3;
                    }
                    ++n3;
                }
                n = n2;
            }
            this.comboBox.setSelectedIndex(n);
            if (n != -1) {
                this.list.clearSelection();
                this.list.setSelectedValue(string3, true);
            }
        }
    }

    private void updateListBox(String string) {
        if (string != null) {
            Vector vector = this.comboBox.getSelectedIndex() == this.otherDirIndex ? this.getImagesList(string) : this.getImagesList(FileUtils.createFileName(this.imagesDir, string));
            this.list.setListData(vector);
            this.list.setSelectedValue(FileUtils.getName(this.locTextField.getText()), true);
        } else {
            this.list.setListData(new Vector());
        }
    }

    private void updateLocationField(String string) {
        if (this.canUpdateTextField) {
            String string2 = "";
            if (string != null) {
                string2 = this.comboBox.getSelectedIndex() == this.otherDirIndex ? FileUtils.createFileName((String)this.comboBox.getSelectedItem(), string) : FileUtils.createFileName(FileUtils.createFileName(this.aliasedImagesDir, (String)this.comboBox.getSelectedItem()), string);
            }
            if (!string2.equals(this.locTextField.getText())) {
                this.locTextField.setText(string2);
            }
        }
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        propertyEditor.setAsText(this.locTextField.getText());
    }

    class ComboListener
    implements ItemListener {
        ComboListener() {
        }

        public void itemStateChanged(ItemEvent itemEvent) {
            ImageSourceEditorUI.this.updateListBox((String)((JComboBox)itemEvent.getSource()).getSelectedItem());
        }
    }

    class ListListener
    implements ListSelectionListener {
        ListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (ImageSourceEditorUI.this.canUpdateTextField) {
                ImageSourceEditorUI.this.propogateDocChange = false;
                ImageSourceEditorUI.this.updateLocationField((String)((JList)listSelectionEvent.getSource()).getSelectedValue());
                String string = FileUtils.normalizeFileName(ImageSourceEditorUI.this.resolveString(ImageSourceEditorUI.this.locTextField.getText()));
                ImageSourceEditorUI.this.displayImage(string);
                ImageSourceEditorUI.this.propogateDocChange = true;
            }
        }
    }

    class ButtonActionListener
    implements ActionListener {
        ButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!ImageSourceEditorUI.this.secondClick) {
                ImageSourceEditorUI.this.secondClick = true;
                ImageSourceEditorUI.this.launchBrowseDialog();
                ImageSourceEditorUI.this.secondClick = false;
            }
        }
    }

    class TFDocumentListener
    implements DocumentListener {
        TFDocumentListener() {
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void doChanged() {
            if (ImageSourceEditorUI.this.propogateDocChange) {
                ImageSourceEditorUI.this.canUpdateTextField = false;
                String string = FileUtils.normalizeFileName(ImageSourceEditorUI.this.resolveString(ImageSourceEditorUI.this.locTextField.getText()));
                ImageSourceEditorUI.this.updateCombo(string);
                ImageSourceEditorUI.this.displayImage(string);
                ImageSourceEditorUI.this.canUpdateTextField = true;
            }
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            this.doChanged();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            this.doChanged();
        }
    }

    class ImagePanel
    extends JPanel {
        Image image = null;

        ImagePanel() {
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void paintComponent(Graphics graphics) {
            String string = "Cannot display image";
            super.paintComponent(graphics);
            if (this.image != null) {
                boolean bl = this.getWidth() > this.image.getWidth(this);
                boolean bl2 = this.getHeight() > this.image.getHeight(this);
                this.setBackground(Color.white);
                if (bl && bl2) {
                    graphics.drawImage(this.image, 10, 10, bl ? this.image.getWidth(this) : this.getWidth(), bl2 ? this.image.getHeight(this) : this.getHeight(), this);
                } else {
                    int n = this.getWidth();
                    int n2 = this.getHeight();
                    int n3 = this.image.getWidth(this);
                    int n4 = this.image.getHeight(this);
                    int n5 = 0;
                    int n6 = 0;
                    if ((float)n / (float)n2 > (float)n3 / (float)n4) {
                        n5 = (int)((float)n2 * (float)n3 / (float)n4);
                        n6 = n2;
                    } else {
                        n6 = (int)((float)n * (float)n4 / (float)n3);
                        n5 = n;
                    }
                    graphics.drawImage(this.image, 0, 0, n5, n6, this);
                }
            } else {
                int n = graphics.getFontMetrics().stringWidth(string);
                graphics.drawString(string, (this.getWidth() - n) / 2, this.getHeight() / 2);
            }
        }

        void setImage(ImageIcon imageIcon) {
            this.image = imageIcon != null ? imageIcon.getImage() : null;
            this.repaint();
        }
    }

    class IconListCellRenderer
    extends DefaultListCellRenderer {
        IconListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            jLabel.setIcon(ActionUtils.loadIcon((String)"/com/installshield/images/img16.gif", (int)16));
            return jLabel;
        }
    }
}

