/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyEditor;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class InsetsEditorUI
extends JPanel
implements EditorUI {
    private JTextField top = null;
    private JTextField left = null;
    private JTextField bottom = null;
    private JTextField right = null;

    public InsetsEditorUI() {
        super(new BorderLayout(4, 4));
        this.createUI();
        this.initialize();
    }

    private Insets convertInsetsFromString(String string) {
        Insets insets;
        block6: {
            insets = new Insets(0, 0, 0, 0);
            if (string == null || string.length() <= 0) break block6;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
            try {
                if (stringTokenizer.hasMoreElements()) {
                    insets.top = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.left = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.bottom = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
                if (stringTokenizer.hasMoreElements()) {
                    insets.right = Integer.parseInt(stringTokenizer.nextToken().trim());
                }
            }
            catch (Throwable throwable) {}
        }
        return insets;
    }

    private String convertInsetsToString(Insets insets) {
        String string = insets.top + ", " + insets.left + ", " + insets.bottom + ", " + insets.right;
        return string;
    }

    private void createUI() {
        this.setLayout(new BorderLayout(4, 4));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel("Top:"), gridBagConstraints);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.top = new JTextField();
        jPanel.add((Component)this.top, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Left:"), gridBagConstraints);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.left = new JTextField();
        jPanel.add((Component)this.left, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Bottom:"), gridBagConstraints);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.bottom = new JTextField();
        jPanel.add((Component)this.bottom, gridBagConstraints);
        gridBagConstraints.insets.right = 0;
        gridBagConstraints.fill = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)new JLabel("Right:"), gridBagConstraints);
        gridBagConstraints.insets.right = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.right = new JTextField();
        jPanel.add((Component)this.right, gridBagConstraints);
        this.add(jPanel);
        this.setPreferredSize(new Dimension(200, 100));
    }

    public Component getComponent() {
        return this;
    }

    private Insets getCurrentInsets() {
        Insets insets = new Insets(0, 0, 0, 0);
        try {
            insets.top = Integer.parseInt(this.top.getText());
        }
        catch (Throwable throwable) {}
        try {
            insets.left = Integer.parseInt(this.left.getText());
        }
        catch (Throwable throwable) {}
        try {
            insets.bottom = Integer.parseInt(this.bottom.getText());
        }
        catch (Throwable throwable) {}
        try {
            insets.right = Integer.parseInt(this.right.getText());
        }
        catch (Throwable throwable) {}
        return insets;
    }

    public String getTitle() {
        return "Specify Insets";
    }

    private void initialize() {
        this.top.requestDefaultFocus();
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        block8: {
            if (propertyEditor.getAsText() == null || propertyEditor.getAsText().equals("")) break block8;
            Insets insets = this.convertInsetsFromString(propertyEditor.getAsText());
            try {
                this.top.setText(Integer.toString(insets.top));
            }
            catch (Throwable throwable) {}
            try {
                this.left.setText(Integer.toString(insets.left));
            }
            catch (Throwable throwable) {}
            try {
                this.bottom.setText(Integer.toString(insets.bottom));
            }
            catch (Throwable throwable) {}
            try {
                this.right.setText(Integer.toString(insets.right));
            }
            catch (Throwable throwable) {}
        }
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        propertyEditor.setAsText(this.convertInsetsToString(this.getCurrentInsets()));
    }
}

