/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AbstractEditor;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.LocaleEditorUI;
import com.installshield.util.LocaleUtils;
import java.util.Locale;
import java.util.StringTokenizer;

public class LocaleEditor
extends AbstractEditor {
    private String value = null;

    public static Locale createLocale(String string) {
        if (string == null) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        if (stringTokenizer.countTokens() >= 3) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 2) {
            return new Locale(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (stringTokenizer.countTokens() == 1) {
            return new Locale(stringTokenizer.nextToken(), "");
        }
        return null;
    }

    protected EditorUI createUI() {
        return new LocaleEditorUI();
    }

    public String getAsText() {
        Locale locale = LocaleEditor.createLocale(this.value);
        return locale != null ? LocaleUtils.getLocaleDisplayName(locale) : "";
    }

    public Object getValue() {
        return this.value;
    }

    public void setAsText(String string) {
        this.value = string == null || string.trim().length() == 0 ? null : string;
    }

    public void setValue(Object object) {
        if (object != null && !(object instanceof String)) {
            throw new IllegalArgumentException("value must be String");
        }
        this.value = (String)object;
    }
}

