/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.LocaleEditor;
import com.installshield.isje.ISJE;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.util.LocaleItem;
import com.installshield.util.sort.LocaleCompare;
import com.installshield.util.sort.SortUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyEditor;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class LocaleEditorUI
extends JPanel
implements EditorUI,
ListSelectionListener,
ChangeListener,
DocumentListener {
    private JTabbedPane tab;
    private PredefinedView predefined;
    private CustomView custom;
    private Vector changeListeners = new Vector();

    public LocaleEditorUI() {
        this.setLayout(new BorderLayout());
        this.tab = new JTabbedPane();
        this.add((Component)this.tab, "West");
        this.tab.addChangeListener(this);
        this.predefined = new PredefinedView(this);
        this.custom = new CustomView(this);
        this.tab.addTab("Predefined", this.predefined);
        this.tab.addTab("Custom", this.custom);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    private GridBagConstraints constrain(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        return gridBagConstraints;
    }

    public Component getComponent() {
        return this;
    }

    public static Locale[] getISMPLocales() {
        Object[] objectArray = null;
        String string = ISJE.getISJE().getProperty("locales");
        if (string != null) {
            Vector<Locale> vector = new Vector<Locale>();
            if (string.length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    vector.addElement(LocaleEditor.createLocale(stringTokenizer.nextToken().trim()));
                }
            }
            objectArray = new Locale[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    public String getTitle() {
        return "Locale Selection";
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    private void notifyChangeListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        int n = 0;
        while (n < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.elementAt(n)).stateChanged(changeEvent);
            ++n;
        }
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        Locale locale = LocaleEditor.createLocale((String)propertyEditor.getValue());
        this.predefined.setEditorLocale(locale);
        this.custom.setEditorLocale(locale);
        if (this.predefined.getEditorLocale() != null) {
            this.tab.setSelectedComponent(this.predefined);
        } else {
            this.tab.setSelectedComponent(this.custom);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.removeElement(changeListener);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tab) {
            if (this.tab.getSelectedComponent() == this.predefined) {
                this.predefined.setEditorLocale(this.custom.getEditorLocale());
            } else if (this.tab.getSelectedComponent() == this.custom && this.predefined.getEditorLocale() != null) {
                this.custom.setEditorLocale(this.predefined.getEditorLocale());
            }
        }
    }

    public boolean supportsCancel() {
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.notifyChangeListeners();
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        if (this.tab.getSelectedComponent() == this.predefined) {
            Locale locale = this.predefined.getEditorLocale();
            if (locale != null) {
                propertyEditor.setValue(locale.toString());
            } else {
                propertyEditor.setValue(this.custom.getEditorLocale().toString());
            }
        } else if (this.tab.getSelectedComponent() == this.custom) {
            propertyEditor.setValue(this.custom.getEditorLocale().toString());
        } else {
            throw new IllegalStateException();
        }
    }

    class PredefinedView
    extends JPanel {
        private JList locales;
        private Vector localeList = new Vector();
        private JPanel pane0;

        PredefinedView(ListSelectionListener listSelectionListener) {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(10, 20, 10, 20));
            this.pane0 = new JPanel((LayoutManager)new ColumnLayout());
            this.add((Component)this.pane0, "Center");
            JLabel jLabel = new JLabel("Locales:");
            jLabel.setBorder(new EmptyBorder(0, 0, 4, 0));
            this.pane0.add((Component)jLabel, new ColumnConstraints(1, 2));
            this.locales = new JList();
            JScrollPane jScrollPane = new JScrollPane(this.locales);
            this.pane0.add((Component)jScrollPane, new ColumnConstraints(2, 2));
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.locales.setSelectionMode(0);
            this.locales.addListSelectionListener(listSelectionListener);
            Object[] objectArray = this.getPredefinedLocales();
            SortUtils.qsort(objectArray, new LocaleCompare());
            this.localeList.addElement(new LocaleItem(new Locale("", "", "")));
            int n = 0;
            while (n < objectArray.length) {
                this.localeList.addElement(new LocaleItem((Locale)objectArray[n]));
                ++n;
            }
            this.locales.setListData(this.localeList);
        }

        public Locale getEditorLocale() {
            LocaleItem localeItem = (LocaleItem)this.locales.getSelectedValue();
            return localeItem != null ? localeItem.getLocale() : null;
        }

        public Locale[] getPredefinedLocales() {
            Locale[] localeArray = LocaleEditorUI.getISMPLocales();
            if (localeArray == null || localeArray.length == 0) {
                localeArray = new Locale[]{new Locale("zh", ""), new Locale("zh", "TW"), new Locale("da", ""), new Locale("nl", ""), new Locale("en", "US"), new Locale("fr", ""), new Locale("de", ""), new Locale("el", ""), new Locale("it", ""), new Locale("ja", ""), new Locale("ko", ""), new Locale("pt", ""), new Locale("es", ""), new Locale("sv", ""), new Locale("tr", "")};
            }
            Locale locale = Locale.getDefault();
            boolean bl = false;
            int n = 0;
            while (n < localeArray.length) {
                if (locale.getLanguage().equals(localeArray[n].getLanguage()) && (localeArray[n].getCountry().length() <= 0 || locale.getCountry().equals(localeArray[n].getCountry()))) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (!bl) {
                Locale[] localeArray2 = new Locale[localeArray.length + 1];
                System.arraycopy(localeArray, 0, localeArray2, 0, localeArray.length);
                localeArray2[localeArray2.length - 1] = locale;
                return localeArray2;
            }
            return localeArray;
        }

        public void setEditorLocale(Locale locale) {
            int n = 0;
            while (locale != null && this.localeList != null && n < this.localeList.size()) {
                if (((LocaleItem)this.localeList.elementAt(n)).equals(new LocaleItem(locale))) {
                    this.locales.setSelectedIndex(n);
                    return;
                }
                ++n;
            }
            if (this.locales != null) {
                if (locale == null) {
                    this.locales.setSelectedIndex(0);
                } else {
                    this.locales.setSelectedIndex(-1);
                }
            }
        }
    }

    class CustomView
    extends JPanel {
        private JTextField language;
        private JTextField country;
        private JTextField variant;
        private JPanel pane0;

        CustomView(DocumentListener documentListener) {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(10, 20, 10, 20));
            this.pane0 = new JPanel(new GridBagLayout());
            this.add((Component)this.pane0, "North");
            this.pane0.add((Component)new JLabel("Language:"), LocaleEditorUI.this.constrain(1, 1));
            this.language = new JTextField(7);
            this.pane0.add((Component)this.language, LocaleEditorUI.this.constrain(1, 2));
            this.language.getDocument().addDocumentListener(documentListener);
            this.pane0.add((Component)new JLabel("Country:"), LocaleEditorUI.this.constrain(2, 1));
            this.country = new JTextField(7);
            this.pane0.add((Component)this.country, LocaleEditorUI.this.constrain(2, 2));
            this.country.getDocument().addDocumentListener(documentListener);
            this.pane0.add((Component)new JLabel("Variant:"), LocaleEditorUI.this.constrain(3, 1));
            this.variant = new JTextField(7);
            this.pane0.add((Component)this.variant, LocaleEditorUI.this.constrain(3, 2));
            this.variant.getDocument().addDocumentListener(documentListener);
        }

        public Locale getEditorLocale() {
            return new Locale(this.language.getText(), this.country.getText(), this.variant.getText());
        }

        public void setEditorLocale(Locale locale) {
            if (this.language != null && this.country != null && this.variant != null) {
                this.language.setText(locale != null ? locale.getLanguage() : "");
                this.country.setText(locale != null ? locale.getCountry() : "");
                this.variant.setText(locale != null ? locale.getVariant() : "");
            }
        }
    }
}

