/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.PlatformEditor;
import com.installshield.beans.editors.PlatformItem;
import com.installshield.swing.ColumnConstraints;
import com.installshield.swing.ColumnLayout;
import com.installshield.util.Platform;
import com.installshield.util.PlatformFactory;
import com.installshield.util.sort.PlatformCompare;
import com.installshield.util.sort.SortUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PlatformEditorUI
extends JPanel
implements EditorUI,
ListSelectionListener,
ChangeListener,
DocumentListener {
    private boolean initialized = false;
    private JTable available = null;
    private JTabbedPane tab;
    private PredefinedView predefined;
    private CustomView custom;
    private Vector changeListeners = new Vector();

    public PlatformEditorUI() {
        this.setLayout(new BorderLayout());
        this.tab = new JTabbedPane();
        this.add((Component)this.tab, "West");
        this.tab.addChangeListener(this);
        this.predefined = new PredefinedView(this);
        this.custom = new CustomView(this);
        this.tab.addTab("Predefined", this.predefined);
        this.tab.addTab("Custom", this.custom);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeListeners.addElement(changeListener);
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    private GridBagConstraints constrain(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n2;
        gridBagConstraints.gridy = n;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        return gridBagConstraints;
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "Platform";
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    private void notifyChangeListeners() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        int n = 0;
        while (n < this.changeListeners.size()) {
            ((ChangeListener)this.changeListeners.elementAt(n)).stateChanged(changeEvent);
            ++n;
        }
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        if (!(propertyEditor instanceof PlatformEditor)) {
            throw new IllegalArgumentException("editor must be PlatformEditor");
        }
        Platform platform = (Platform)propertyEditor.getValue();
        this.predefined.setPlatform(platform);
        this.custom.setPlatform(platform);
        if (this.predefined.getPlatform() != null) {
            this.tab.setSelectedComponent(this.predefined);
        } else if (!(this.custom.getPlatform() == null || this.custom.getPlatform().getName().equals(".") && this.custom.getPlatform().getVersion().equals(".") && this.custom.getPlatform().getArch().equals(".") && this.custom.getPlatform().getDisplayName().equals(""))) {
            this.tab.setSelectedComponent(this.custom);
        } else {
            this.tab.setSelectedComponent(this.predefined);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeListeners.removeElement(changeListener);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.notifyChangeListeners();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.tab) {
            if (this.tab.getSelectedComponent() == this.predefined) {
                this.predefined.setPlatform(this.custom.getPlatform());
            } else if (this.tab.getSelectedComponent() == this.custom && this.predefined.getPlatform() != null) {
                this.custom.setPlatform(this.predefined.getPlatform());
            }
        }
    }

    public boolean supportsCancel() {
        return true;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.notifyChangeListeners();
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        if (!(propertyEditor instanceof PlatformEditor)) {
            throw new IllegalArgumentException("editor must be PlatformEditor");
        }
        if (this.tab.getSelectedComponent() == this.predefined) {
            if (this.predefined.getPlatform() != null) {
                propertyEditor.setValue(this.predefined.getPlatform());
            } else {
                propertyEditor.setValue(this.custom.getPlatform());
            }
        } else if (this.tab.getSelectedComponent() == this.custom) {
            propertyEditor.setValue(this.custom.getPlatform());
        } else {
            throw new IllegalStateException();
        }
    }

    class PredefinedView
    extends JPanel {
        private JList platforms;
        private Vector platformList = new Vector();
        private JPanel pane0;
        private Platform[] predef = null;

        PredefinedView(ListSelectionListener listSelectionListener) {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(10, 20, 10, 20));
            this.pane0 = new JPanel((LayoutManager)new ColumnLayout());
            this.add((Component)this.pane0, "Center");
            JLabel jLabel = new JLabel("Platforms:");
            jLabel.setBorder(new EmptyBorder(0, 0, 4, 0));
            this.pane0.add((Component)jLabel, new ColumnConstraints(1, 2));
            this.platforms = new JList();
            JScrollPane jScrollPane = new JScrollPane(this.platforms);
            this.pane0.add((Component)jScrollPane, new ColumnConstraints(2, 2));
            jScrollPane.setBorder(BorderFactory.createLineBorder(Color.black, 1));
            this.platforms.setSelectionMode(0);
            this.platforms.addListSelectionListener(listSelectionListener);
            this.populatePredefinedPlatforms();
            int n = 0;
            while (n < this.predef.length) {
                this.platformList.addElement(new PlatformItem(this.predef[n]));
                ++n;
            }
            this.platforms.setListData(this.platformList);
        }

        public Platform getPlatform() {
            PlatformItem platformItem = (PlatformItem)this.platforms.getSelectedValue();
            return platformItem != null ? platformItem.platform : null;
        }

        void populatePredefinedPlatforms() {
            if (this.predef == null) {
                PlatformFactory platformFactory = Platform.getPlatformFactory();
                if (platformFactory != null) {
                    this.predef = platformFactory.createPredefinedPlatforms();
                    SortUtils.qsort(this.predef, new PlatformCompare());
                } else {
                    this.predef = new Platform[0];
                }
            }
        }

        public void setPlatform(Platform platform) {
            int n = 0;
            while (platform != null && n < this.platformList.size()) {
                if (((PlatformItem)this.platformList.elementAt(n)).equals(new PlatformItem(platform))) {
                    this.platforms.setSelectedIndex(n);
                    return;
                }
                ++n;
            }
            this.platforms.setSelectedIndex(-1);
        }
    }

    class CustomView
    extends JPanel {
        private JTextField displayName;
        private JTextField name;
        private JTextField version;
        private JTextField arch;
        private JPanel pane0;

        CustomView(DocumentListener documentListener) {
            this.setLayout(new BorderLayout());
            this.setBorder(new EmptyBorder(10, 20, 10, 20));
            this.pane0 = new JPanel(new GridBagLayout());
            this.add((Component)this.pane0, "North");
            this.pane0.add((Component)new JLabel("Display name:"), PlatformEditorUI.this.constrain(1, 1));
            this.displayName = new JTextField(30);
            this.pane0.add((Component)this.displayName, PlatformEditorUI.this.constrain(1, 2));
            this.displayName.getDocument().addDocumentListener(documentListener);
            this.pane0.add((Component)new JLabel("Name:"), PlatformEditorUI.this.constrain(2, 1));
            this.name = new JTextField(30);
            this.pane0.add((Component)this.name, PlatformEditorUI.this.constrain(2, 2));
            this.name.getDocument().addDocumentListener(documentListener);
            this.pane0.add((Component)new JLabel("Version:"), PlatformEditorUI.this.constrain(3, 1));
            this.version = new JTextField(30);
            this.pane0.add((Component)this.version, PlatformEditorUI.this.constrain(3, 2));
            this.version.getDocument().addDocumentListener(documentListener);
            this.pane0.add((Component)new JLabel("Architecture:"), PlatformEditorUI.this.constrain(4, 1));
            this.arch = new JTextField(30);
            this.pane0.add((Component)this.arch, PlatformEditorUI.this.constrain(4, 2));
            this.arch.getDocument().addDocumentListener(documentListener);
        }

        public Platform getPlatform() {
            return new Platform(this.name.getText(), this.version.getText(), this.arch.getText(), this.displayName.getText());
        }

        public void setPlatform(Platform platform) {
            this.displayName.setText(platform != null ? platform.getDisplayName() : "");
            this.name.setText(platform != null ? platform.getName() : "");
            this.version.setText(platform != null ? platform.getVersion() : "");
            this.arch.setText(platform != null ? platform.getArch() : "");
        }
    }
}

