/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.AbstractEditor;
import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.editors.StringArrayEditorUI;
import java.util.Vector;

public class StringArrayEditor
extends AbstractEditor {
    private String[] value = new String[0];

    protected EditorUI createUI() {
        return new StringArrayEditorUI();
    }

    public String getAsText() {
        if (this.value == null || this.value.length <= 0) {
            return "Empty List";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 30;
        int n2 = 0;
        while (n > 0 && n2 < this.value.length) {
            String string;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            if ((string = this.value[n2]).length() > n) {
                stringBuffer.append(String.valueOf(string.substring(0, n)) + "...");
            } else {
                stringBuffer.append(string);
            }
            n -= string.length();
            ++n2;
        }
        return stringBuffer.toString();
    }

    public Object getValue() {
        if (this.value == null) {
            this.value = new String[0];
        }
        return this.value;
    }

    public void setAsText(String string) {
        if (string != null) {
            Vector<String> vector = new Vector<String>();
            int n = string.indexOf(13);
            int n2 = 0;
            int n3 = string.length();
            while (n >= 0 && n2 < n3) {
                vector.addElement(string.substring(n2, n));
                n2 = n + 1;
            }
            this.value = new String[vector.size()];
            vector.copyInto(this.value);
            this.firePropertyChange();
        }
    }

    public void setValue(Object object) {
        this.value = object.getClass().equals(new String[0].getClass()) ? (String[])object : new String[0];
    }
}

