/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import com.installshield.isje.actions.ActionUtils;
import com.installshield.swing.PopupMenuHandler;
import com.installshield.wizard.swing.JFlowLabel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class StringArrayEditorUI
extends JPanel
implements EditorUI,
ActionListener,
ListSelectionListener {
    private SimpleModel tableData;
    private JTable table;
    private Action addAction;
    private Action deleteAction;
    private Action moveUpAction;
    private Action moveDownAction;
    private PopupHandler popupHandler;
    private SATableCellEditor cellEditor = null;
    public static int ADD = 1;
    public static int DELETE = 2;
    public static int MOVEUP = 3;
    public static int MOVEDOWN = 4;

    public StringArrayEditorUI() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        this.addAction = new ArrayAction("Add", ActionUtils.loadIcon((String)"/com/installshield/images/add16.gif", (int)16), ADD);
        this.deleteAction = new ArrayAction("Delete", ActionUtils.loadIcon((String)"/com/installshield/images/delete16m.gif", (int)16), DELETE);
        this.moveUpAction = new ArrayAction("Move Up", ActionUtils.loadIcon((String)"/com/installshield/images/up16.gif", (int)16), MOVEUP);
        this.moveDownAction = new ArrayAction("Move Down", ActionUtils.loadIcon((String)"/com/installshield/images/down16.gif", (int)16), MOVEDOWN);
        this.setToolbarButtonProperties(jToolBar.add(this.addAction), "Add");
        this.setToolbarButtonProperties(jToolBar.add(this.deleteAction), "");
        this.setToolbarButtonProperties(jToolBar.add(this.moveUpAction), "");
        this.setToolbarButtonProperties(jToolBar.add(this.moveDownAction), "");
        JFlowLabel jFlowLabel = new JFlowLabel("Click 'Add' to add a new value. Double-click an existing value to edit it.");
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jToolBar, "South");
        jPanel2.add((Component)jFlowLabel, "North");
        jPanel.add((Component)jPanel2, "North");
        this.setLayout(new BorderLayout());
        this.tableData = new SimpleModel();
        this.table = new JTable(this.tableData);
        this.cellEditor = new SATableCellEditor();
        this.table.getColumnModel().getColumn(0).setCellEditor(this.cellEditor);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.table.setSelectionMode(1);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(300);
        this.table.addMouseListener((MouseListener)((Object)new PopupHandler()));
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)jScrollPane, "Center");
        this.refreshButtonStates(null);
        this.add((Component)jPanel, "Center");
        this.table.clearSelection();
    }

    public void actionPerformed(ActionEvent actionEvent) {
    }

    protected void addLineToTable() {
        int n = -1;
        n = this.table.getSelectedRow() < 0 ? this.tableData.addText("") : this.tableData.addTextAfter(this.table.getSelectedRow(), "");
        this.table.scrollRectToVisible(this.table.getCellRect(n, 0, true));
        this.table.setRowSelectionInterval(n, n);
        this.cellEditor.editCellAt(this.table, n);
    }

    private void commitPendingChanges() {
        if (this.table.isEditing()) {
            this.cellEditor.stopEditing();
        }
    }

    public Component getComponent() {
        return this;
    }

    public Dimension getPreferredSize() {
        return new Dimension(350, 300);
    }

    public String getTitle() {
        return "List of Values";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        this.tableData.clear();
        Object object = propertyEditor.getValue();
        if (object.getClass().isArray()) {
            Object[] objectArray = (Object[])object;
            int n = 0;
            while (n < objectArray.length) {
                this.tableData.addText(objectArray[n].toString());
                this.table.tableChanged(new TableModelEvent(this.tableData));
                ++n;
            }
        } else {
            System.out.println("Expected a string array.");
        }
    }

    private void refreshButtonStates(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            this.deleteAction.setEnabled(false);
            this.moveUpAction.setEnabled(false);
            this.moveDownAction.setEnabled(false);
        } else {
            this.moveUpAction.setEnabled(nArray[0] > 0);
            this.moveDownAction.setEnabled(nArray[nArray.length - 1] < this.table.getRowCount() - 1);
            if (nArray[0] == -1) {
                this.deleteAction.setEnabled(false);
            } else {
                this.deleteAction.setEnabled(true);
            }
        }
    }

    private void setToolbarButtonProperties(JButton jButton, String string) {
        jButton.setText(string);
        jButton.setHorizontalTextPosition(4);
    }

    public boolean supportsCancel() {
        return true;
    }

    private void swap(int n, int n2) {
        Object object = this.tableData.getValueAt(n, 0);
        this.tableData.setValueAt(this.tableData.getValueAt(n2, 0), n, 0);
        this.tableData.setValueAt(object, n2, 0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.refreshButtonStates(this.table.getSelectedRows());
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        this.commitPendingChanges();
        String[] stringArray = new String[this.tableData.getRowCount()];
        int n = 0;
        while (n < this.tableData.getRowCount()) {
            stringArray[n] = (String)this.tableData.getValueAt(n, 0);
            ++n;
        }
        propertyEditor.setValue(stringArray);
    }

    class SimpleModel
    extends AbstractTableModel {
        protected Vector textData = new Vector();

        SimpleModel() {
        }

        public int addText(String string) {
            this.textData.addElement(string);
            this.fireTableRowsInserted(this.textData.size(), this.textData.size());
            return this.textData.size() - 1;
        }

        public int addTextAfter(int n, String string) {
            int n2 = -1;
            if (n >= 0 && n < this.textData.size() - 1) {
                n2 = n + 1;
                this.textData.insertElementAt(string, n2);
                this.fireTableRowsInserted(n2, n2);
            } else {
                n2 = this.addText(string);
            }
            return n2;
        }

        public void clear() {
            this.textData.removeAllElements();
            this.fireTableDataChanged();
        }

        public int getColumnCount() {
            return 1;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return "Value";
            }
            return "";
        }

        public int getRowCount() {
            return this.textData.size();
        }

        public Object getValueAt(int n, int n2) {
            return this.textData.elementAt(n);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }

        public void removeValueAt(int n) {
            if (n >= 0 && n < this.getRowCount()) {
                this.textData.removeElementAt(n);
                this.fireTableRowsDeleted(n, n);
            }
        }

        public void removeValues(int[] nArray) {
            if (nArray != null && nArray.length > 0 && nArray[nArray.length - 1] < this.getRowCount()) {
                int n = 0;
                while (n < nArray.length) {
                    this.textData.removeElementAt(nArray[0]);
                    ++n;
                }
                this.fireTableRowsDeleted(nArray[0], nArray[nArray.length - 1]);
            }
        }

        public void setValueAt(Object object, int n, int n2) {
            if (n2 == 0) {
                this.textData.setElementAt((String)object, n);
                this.fireTableCellUpdated(n, n2);
            }
        }
    }

    class ArrayAction
    extends AbstractAction {
        private int type = -1;

        public ArrayAction(String string, Icon icon, int n) {
            super(string, icon);
            this.type = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.type == MOVEUP) {
                StringArrayEditorUI.this.commitPendingChanges();
                int[] nArray = StringArrayEditorUI.this.table.getSelectedRows();
                if (nArray.length > 0) {
                    int n = 0;
                    while (n < nArray.length) {
                        StringArrayEditorUI.this.swap(nArray[n] - 1, nArray[n]);
                        ++n;
                    }
                    StringArrayEditorUI.this.table.setRowSelectionInterval(nArray[0] - 1, nArray[nArray.length - 1] - 1);
                    Rectangle rectangle = StringArrayEditorUI.this.table.getCellRect(nArray[0] - 1, 0, true);
                    StringArrayEditorUI.this.table.scrollRectToVisible(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height * nArray.length));
                }
            } else if (this.type == MOVEDOWN) {
                StringArrayEditorUI.this.commitPendingChanges();
                int[] nArray = StringArrayEditorUI.this.table.getSelectedRows();
                if (nArray[nArray.length - 1] < StringArrayEditorUI.this.table.getRowCount() - 1) {
                    int n = nArray.length - 1;
                    while (n >= 0) {
                        StringArrayEditorUI.this.swap(nArray[n] + 1, nArray[n]);
                        --n;
                    }
                    StringArrayEditorUI.this.table.setRowSelectionInterval(nArray[0] + 1, nArray[nArray.length - 1] + 1);
                    Rectangle rectangle = StringArrayEditorUI.this.table.getCellRect(nArray[0] + 1, 0, true);
                    StringArrayEditorUI.this.table.scrollRectToVisible(new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height * nArray.length));
                }
            } else if (this.type == ADD) {
                StringArrayEditorUI.this.commitPendingChanges();
                StringArrayEditorUI.this.addLineToTable();
            } else if (this.type == DELETE) {
                StringArrayEditorUI.this.commitPendingChanges();
                int[] nArray = StringArrayEditorUI.this.table.getSelectedRows();
                StringArrayEditorUI.this.tableData.removeValues(nArray);
                int n = nArray[0];
                while (n >= StringArrayEditorUI.this.tableData.getRowCount()) {
                    --n;
                }
                if (n >= 0) {
                    StringArrayEditorUI.this.table.scrollRectToVisible(StringArrayEditorUI.this.table.getCellRect(n, 0, true));
                    StringArrayEditorUI.this.table.setRowSelectionInterval(n, n);
                } else {
                    StringArrayEditorUI.this.table.clearSelection();
                }
                StringArrayEditorUI.this.refreshButtonStates(new int[]{n});
            }
        }
    }

    class PopupHandler
    extends PopupMenuHandler {
        PopupHandler() {
        }

        public JPopupMenu getPopupMenu(MouseEvent mouseEvent) {
            JPopupMenu jPopupMenu = new JPopupMenu("Actions");
            jPopupMenu.add(StringArrayEditorUI.this.addAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(StringArrayEditorUI.this.moveUpAction);
            jPopupMenu.add(StringArrayEditorUI.this.moveDownAction);
            jPopupMenu.addSeparator();
            jPopupMenu.add(StringArrayEditorUI.this.deleteAction);
            jPopupMenu.pack();
            return jPopupMenu;
        }
    }

    class SATableCellEditor
    extends DefaultCellEditor {
        private SATextField textField = null;

        public SATableCellEditor() {
            super(new SATextField());
            this.setClickCountToStart(2);
        }

        public void editCellAt(JTable jTable, int n) {
            jTable.editCellAt(n, 0);
            this.textField.setCaretPosition(this.textField.getText().length());
            this.textField.requestFocus();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.textField = (SATextField)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
            return this.textField;
        }

        public void stopEditing() {
            boolean bl;
            block3: {
                bl = false;
                try {
                    bl = this.stopCellEditing();
                }
                catch (Throwable throwable) {
                    if (System.getProperty("is.debug") == null) break block3;
                    throwable.printStackTrace();
                }
            }
            if (!bl) {
                Toolkit.getDefaultToolkit().beep();
                this.cancelCellEditing();
            }
        }
    }

    class SATextField
    extends JTextField {
        public SATextField() {
            this.enableEvents(4L);
        }

        protected void processFocusEvent(FocusEvent focusEvent) {
            super.processFocusEvent(focusEvent);
            if (focusEvent.getID() == 1005) {
                super.fireActionPerformed();
            }
        }
    }
}

