/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import com.installshield.beans.tableview.JTableInlineEditor;
import com.installshield.swing.ModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyEditor;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class StringMultiLineEditorUI
extends JPanel
implements EditorUI,
JTableInlineEditor,
ActionListener,
FocusListener {
    private MultiLineEditor mlEditor = null;
    private JTextField text = new JTextField();
    private JButton browseButton = new JButton("...");
    private Vector actionListeners = new Vector();
    private boolean dialogVisible = false;

    public StringMultiLineEditorUI() {
        this.setLayout(new BorderLayout());
        this.addFocusListener(this);
        this.text.addFocusListener(this);
        this.add((Component)this.text, "Center");
        this.browseButton.setPreferredSize(new Dimension(20, 15));
        this.browseButton.addActionListener(this);
        this.browseButton.setRequestFocusEnabled(false);
        this.browseButton.setMnemonic(' ');
        this.add((Component)this.browseButton, "East");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.browseButton)) {
            if (this.mlEditor == null) {
                this.mlEditor = new MultiLineEditor(this);
            }
            this.mlEditor.resetUI();
            this.dialogVisible = true;
            this.mlEditor.setVisible(true);
            this.dialogVisible = false;
            this.text.requestFocus();
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.text.addActionListener(actionListener);
        this.actionListeners.addElement(actionListener);
    }

    protected void fireActionPerformed() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        int n = 0;
        while (n < this.actionListeners.size()) {
            ((ActionListener)this.actionListeners.elementAt(n)).actionPerformed(actionEvent);
            ++n;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this) {
            this.text.requestFocus();
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.getComponent() == this.text && !this.dialogVisible) {
            this.fireActionPerformed();
        }
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "MultiLine String";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        Object object = propertyEditor.getValue();
        if (object instanceof String) {
            String string = (String)object;
            this.text.setText(string);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.text.removeActionListener(actionListener);
        this.actionListeners.removeElement(actionListener);
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        String string = this.text.getText();
        propertyEditor.setValue(string);
    }

    class MultiLineEditor
    extends ModalDialog
    implements ActionListener {
        private JTextArea textArea = new JTextArea(4, 25);
        private JScrollPane scroller = null;
        private JButton okButton = null;
        private JButton cancelButton = null;

        public MultiLineEditor(Component component) {
            super(component);
            ((Dialog)((Object)this)).setTitle("Specify text");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource().equals(this.okButton)) {
                StringMultiLineEditorUI.this.text.setText(this.textArea.getText());
                StringMultiLineEditorUI.this.fireActionPerformed();
            }
            ((Window)((Object)this)).dispose();
        }

        public void createUI() {
            JPanel jPanel = new JPanel(new BorderLayout());
            ((JDialog)((Object)this)).getContentPane().add(jPanel);
            this.textArea.setLineWrap(true);
            this.textArea.setWrapStyleWord(true);
            this.textArea.setText(StringMultiLineEditorUI.this.text.getText());
            this.scroller = new JScrollPane(this.textArea);
            jPanel.add((Component)this.scroller, "Center");
            JPanel jPanel2 = new JPanel(new FlowLayout(1));
            ((JDialog)((Object)this)).getContentPane().add((Component)jPanel2, "South");
            this.okButton = new JButton("  OK  ");
            this.okButton.addActionListener(this);
            this.okButton.setDefaultCapable(true);
            ((JDialog)((Object)this)).getRootPane().setDefaultButton(this.okButton);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            jPanel2.add(this.okButton);
            jPanel2.add(this.cancelButton);
            ((Window)((Object)this)).pack();
            ((Dialog)((Object)this)).setResizable(true);
        }

        public Dimension getPreferredSize() {
            return new Dimension(400, 200);
        }

        public void resetUI() {
            this.textArea.setText(StringMultiLineEditorUI.this.text.getText());
        }
    }
}

