/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.beans.editors;

import com.installshield.beans.editors.EditorUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.beans.PropertyEditor;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TestFieldEditorUI
extends JPanel
implements EditorUI {
    private JTextField text1 = new JTextField();
    private JTextField text2 = new JTextField();

    public TestFieldEditorUI() {
        this.setLayout(new BorderLayout());
        this.text1.setPreferredSize(new Dimension(60, 20));
        this.text2.setPreferredSize(new Dimension(60, 20));
        this.add((Component)this.text1, "West");
        this.add((Component)this.text2, "East");
    }

    public void addActionListener(ActionListener actionListener) {
        this.text1.addActionListener(actionListener);
        this.text2.addActionListener(actionListener);
    }

    public Component getComponent() {
        return this;
    }

    public String getTitle() {
        return "Test Field";
    }

    public void readFromEditor(PropertyEditor propertyEditor) {
        String string = propertyEditor.getAsText();
        int n = string.indexOf(59);
        if (n >= 0) {
            this.text1.setText(string.substring(0, n));
            this.text2.setText(string.substring(n + 1));
        } else {
            this.text1.setText(string);
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.text1.removeActionListener(actionListener);
        this.text2.removeActionListener(actionListener);
    }

    public boolean supportsCancel() {
        return true;
    }

    public void writeToEditor(PropertyEditor propertyEditor) {
        String string = this.text1.getText();
        String string2 = this.text2.getText();
        if (string2.length() > 0) {
            string = String.valueOf(string) + ";";
            string = String.valueOf(string) + string2;
        }
        propertyEditor.setAsText(string);
    }
}

