/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product;

import com.installshield.product.ProductBean;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;

public class SoftwareObjectReference
extends ProductBean
implements Cloneable {
    public static final int ALWAYS_INSTALL = 1;
    public static final int USE_INSTALLED_INST = 2;
    private SoftwareObjectKey key = new SoftwareObjectKey();
    private int resolutionPreference = 2;
    private String name = "";
    private String[] sources = null;
    private static int nextId = 1;

    public SoftwareObjectReference() {
        this.setName(SoftwareObjectReference.nextReferenceName());
    }

    public SoftwareObjectReference(SoftwareObject softwareObject) {
        this.setKey(softwareObject.getKey());
        String string = String.valueOf((int)(Math.random() * 1000000.0));
        this.setDisplayName("ref_" + string);
        this.setBeanId("bean_" + string);
        this.setName("name_" + string);
    }

    public Object clone() {
        SoftwareObjectReference softwareObjectReference = new SoftwareObjectReference();
        softwareObjectReference.setKey((SoftwareObjectKey)this.key.clone());
        softwareObjectReference.setSources(this.sources);
        softwareObjectReference.setResolutionPreference(this.resolutionPreference);
        softwareObjectReference.setDisplayName(this.getDisplayName());
        softwareObjectReference.setName(this.getName());
        return softwareObjectReference;
    }

    public SoftwareObjectKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getResolutionPreference() {
        return this.resolutionPreference;
    }

    public String[] getSources() {
        return this.sources;
    }

    private static String nextReferenceName() {
        return "reference" + nextId++;
    }

    public SoftwareObject resolve() {
        if (this.getProductTree() != null) {
            return this.getProductTree().resolveKey(this.getKey());
        }
        return null;
    }

    public void setKey(SoftwareObjectKey softwareObjectKey) {
        this.key = softwareObjectKey;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setResolutionPreference(int n) {
        this.resolutionPreference = n;
    }

    public void setSources(String[] stringArray) {
        this.sources = stringArray;
    }
}

