/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.util.FileUtils;
import com.installshield.util.ProcessExec;
import com.installshield.util.URLUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class ExecAction
extends ProductAction
implements Runnable {
    public static final int INSTALLTIME = 0;
    public static final int UNINSTALLTIME = 1;
    public static final int INSTALLANDUNINSTALLTIME = 2;
    private String command = "";
    private String[] arguments = new String[0];
    private String stdoutDestination = "";
    private String stderrDestination = "";
    private boolean waitForCompletion = true;
    private int runtime = 0;
    private boolean bundleExecutable = false;
    private String[] createdDirsAndFiles = new String[0];
    private ProcessExec processExec = null;

    public void build(ProductBuilderSupport productBuilderSupport) {
        try {
            boolean bl = true;
            if (this.bundleExecutable) {
                this.command = this.resolveString(this.command, "command", productBuilderSupport);
                if (this.command == null) {
                    bl = false;
                }
                if (bl) {
                    if (!new File(this.command).exists()) {
                        productBuilderSupport.logEvent(this, "err", "Executable: " + this.command + " does not exist.  " + "Unable to build" + this.getClass().getName());
                        return;
                    }
                    String string = String.valueOf(this.getBeanId()) + File.separator + new File(FileUtils.normalizeFileName(this.command)).getName();
                    productBuilderSupport.putResource(this.command, string);
                    if (this.runtime == 0) {
                        productBuilderSupport.excludeUninstallerResource(string);
                    }
                }
            }
            productBuilderSupport.putClass(this.getClass().getName());
        }
        catch (Exception exception) {
            productBuilderSupport.logEvent(this, "err", "Unable to build " + this.getClass().getName());
        }
    }

    protected ProcessExec createProcessExec() {
        try {
            String string = null;
            string = this.bundleExecutable ? this.getProcessRuntimeLocation() : this.resolveString(this.command);
            int n = 0;
            while (n < this.arguments.length) {
                this.arguments[n] = this.resolveString(this.arguments[n]);
                ++n;
            }
            this.processExec = this.waitForCompletion ? new ProcessExec(string, this.arguments, this.resolveString(this.stdoutDestination), this.resolveString(this.stderrDestination)) : new ProcessExec(string, this.arguments);
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return this.processExec;
    }

    private void delete(String string, FileService fileService) {
        try {
            if (fileService.isDirectory(string)) {
                fileService.deleteDirectory(string);
            } else if (fileService.fileExists(string)) {
                fileService.deleteFile(string);
            }
        }
        catch (Exception exception) {}
    }

    private void executeProcess() throws ProductException {
        try {
            this.processExec = this.createProcessExec();
            this.processExec.executeProcess();
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getCommand() {
        return this.command;
    }

    public String[] getCreatedDirsAndFiles() {
        return this.createdDirsAndFiles;
    }

    private String getProcessRuntimeLocation() throws ServiceException {
        String string = null;
        String string2 = FileUtils.normalizeFileName(this.command);
        String string3 = new File(string2).getName();
        try {
            string = FileUtils.createTempFile(this.getResource(String.valueOf(this.getBeanId()) + File.separator + string3), FileUtils.getName(string3));
            FileService fileService = (FileService)this.getServices().getService("fileService");
            fileService.setFileExecutable(string);
        }
        catch (IOException iOException) {
            throw new ServiceException(315, "cannot extract executable " + string3 + ": " + iOException);
        }
        return string;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        try {
            if (this.bundleExecutable) {
                URL uRL = this.getResource(String.valueOf(this.getBeanId()) + File.separator + new File(FileUtils.normalizeFileName(this.command)).getName());
                if (uRL.getProtocol().equals("file")) {
                    requiredBytesTable.addBytes(this.getProductTree().getInstallLocation(this), new File(uRL.getFile()).length());
                } else if (uRL.getProtocol().equals("ismpfile")) {
                    requiredBytesTable.addBytes(this.getProductTree().getInstallLocation(this), new File(URLUtils.decode(uRL.getFile())).length());
                }
            }
        }
        catch (Exception exception) {
            this.logEvent(this, "err", exception);
        }
        return requiredBytesTable;
    }

    public int getReturnValue() {
        int n = this.processExec != null ? this.processExec.getExitCode() : 0;
        return n;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public int getStatus() {
        int n = this.processExec != null ? this.processExec.getStatus() : 0;
        return n;
    }

    public String getStderrDestination() {
        return this.stderrDestination;
    }

    public String getStdoutDestination() {
        return this.stdoutDestination;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        if (this.runtime == 1) {
            return;
        }
        if (!this.waitForCompletion) {
            Thread thread = new Thread(this);
            thread.setPriority(5);
            thread.start();
            boolean bl = false;
            while (!(bl = this.processExec != null ? this.processExec.getProcessStarted() : false)) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.executeProcess();
        }
        this.createdDirsAndFiles = this.processExec.getCreatedDirectories();
    }

    public boolean isBundleExecutable() {
        return this.bundleExecutable;
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void run() {
        try {
            this.executeProcess();
        }
        catch (ProductException productException) {
            this.logEvent(this, "err", productException);
        }
    }

    public void setArguments(String[] stringArray) {
        this.arguments = stringArray;
    }

    public void setBundleExecutable(boolean bl) {
        this.bundleExecutable = bl;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public void setCreatedDirsAndFiles(String[] stringArray) {
        if (stringArray != null) {
            this.createdDirsAndFiles = stringArray;
        }
    }

    public void setRuntime(int n) {
        this.runtime = n;
    }

    public void setStderrDestination(String string) {
        this.stderrDestination = string;
    }

    public void setStdoutDestination(String string) {
        this.stdoutDestination = string;
    }

    public void setWaitForCompletion(boolean bl) {
        this.waitForCompletion = bl;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        int n;
        Object object;
        if (this.runtime == 0 || this.runtime == 2) {
            try {
                object = (FileService)this.getService("fileService");
                n = this.createdDirsAndFiles.length;
                while (n > 0) {
                    this.delete(this.createdDirsAndFiles[n - 1], (FileService)object);
                    --n;
                }
            }
            catch (ServiceException serviceException) {
                throw new ProductException(serviceException);
            }
            if (this.runtime == 0) {
                return;
            }
        }
        if (!this.waitForCompletion) {
            object = new Thread(this);
            ((Thread)object).setPriority(1);
            ((Thread)object).start();
            n = 0;
            while ((n = (int)((this.processExec != null ? this.processExec.getProcessStarted() : 0) ? 1 : 0)) == 0) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {}
            }
        } else {
            this.executeProcess();
        }
    }
}

