/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.archive.BuildEvent;
import com.installshield.archive.BuildListener;
import com.installshield.archive.index.ArchiveIndexAccessor;
import com.installshield.archive.index.ArchiveIndexEntry;
import com.installshield.archive.index.ResourceIndexRange;
import com.installshield.product.Locatable;
import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionEvent;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.product.actions.FilesExtra;
import com.installshield.product.actions.SourceFile;
import com.installshield.util.FileAttributes;
import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringResolverUtil;
import com.installshield.util.URLUtils;
import com.installshield.util.ZipUtils;
import com.installshield.util.rex.RegExprSyntaxException;
import com.installshield.util.rex.Rex;
import com.installshield.wizard.service.MutableOperationState;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.WizardLog;
import com.installshield.wizard.service.WizardServices;
import com.installshield.wizard.service.file.FileService;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class Files
extends ProductAction
implements BuildListener,
Locatable {
    public static final int REPLACE_BY_DATE = 100;
    public static final int REPLACE_BY_VERSION = 101;
    public static final int REPLACE_BY_VERSION_THEN_DATE = 102;
    public static final String CREATE_FILE = "createFile";
    public static final String REPLACE_FILE = "replaceFile";
    public static final String DELETE_FILE = "deleteFile";
    public static final int ARCHIVE_RESOURCES = 0;
    public static final int EXTERNAL_RESOURCES = 1;
    protected static final String CANT_SET_ATTRIBUTES_FLAG = "cantSetAttributes";
    protected static final String CANT_SET_FILE_TIMES_FLAG = "cantSetFileTimes";
    protected static final String CANT_SET_OWNER_FLAG = "cantSetFileOwner";
    protected static final String CANT_SET_GROUP_FLAG = "cantSetFileGroup";
    protected static final String REPLACE_EXISTING = "replaceExistingResponse";
    protected static final String REPLACE_NEWER = "replaceNewerResponse";
    protected static final String REMOVE_EXISTING = "removeExistingResponse";
    protected static final String REMOVE_MODIFIED = "removeModifiedResponse";
    protected static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yesWithMn)";
    protected static final String YES_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, yesToAllWithMn)";
    protected static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, noWithMn)";
    protected static final String NO_TO_ALL = "$L(com.installshield.wizard.i18n.WizardResources, noToAllWithMn)";
    protected static final String CANCEL = "$L(com.installshield.wizard.i18n.WizardResources, cancelWithMn)";
    protected static final String YES_RESPONSE = "yes";
    protected static final String YES_TO_ALL_RESPONSE = "yesToAll";
    protected static final String NO_RESPONSE = "no";
    protected static final String NO_TO_ALL_RESPONSE = "noToAll";
    protected static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";
    protected static final String JAR_VERSION_ENCODING = "UTF8";
    private String owner = "";
    private String group = "";
    private String installLocation = null;
    private Vector files = new Vector();
    private int storedAs = 0;
    private String externalResourceLocation = "";
    private int externalResourceMediaId = 1;
    private int replaceType = 100;
    private boolean useJARVersion = false;
    protected long totalBytes = -1L;
    protected int archiveIndexOffset = -1;
    protected int archiveIndexLength = -1;
    private boolean building = false;
    protected InstalledFiles installed = null;
    private byte[] buf = new byte[10240];
    protected int timeToInstall = 0;
    private boolean nativeServicesAvailable = true;
    static /* synthetic */ Class class$com$installshield$product$actions$SourceFile;
    static /* synthetic */ Class class$com$installshield$product$actions$FilesBeanInfo;
    static /* synthetic */ Class class$com$installshield$product$actions$FilesExtra;
    static /* synthetic */ Class class$java$lang$String;

    public void addFile(SourceFile sourceFile) {
        this.files.addElement(sourceFile);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        this.buildImpl(null, productBuilderSupport, this.getServices());
    }

    private boolean buildCanceled(ProductBuilderSupport productBuilderSupport) {
        return productBuilderSupport != null && productBuilderSupport.isBuildCanceled();
    }

    protected final void buildFile(String string, SourceFile sourceFile, FileAttributes fileAttributes, ProductBuilderSupport productBuilderSupport, String string2, Vector vector, WizardServices wizardServices) {
        this.buildFile(string, sourceFile, true, fileAttributes, productBuilderSupport, string2, vector, wizardServices);
    }

    protected final void buildFile(String string, SourceFile sourceFile, boolean bl, FileAttributes fileAttributes, ProductBuilderSupport productBuilderSupport, String string2, Vector vector, WizardServices wizardServices) {
        String string3 = sourceFile.getFileName();
        if (bl) {
            string3 = StringResolverUtil.resolveString(sourceFile.getFileName(), "files", productBuilderSupport, this, wizardServices);
        }
        if (string3 == null) {
            return;
        }
        File file = new File(string3);
        String string4 = file.getAbsolutePath();
        if (file.isFile()) {
            try {
                String string5 = FileUtils.getName(string4);
                String string6 = string2 != null ? FileUtils.normalizeFileName(string4.substring(string2.length()), '/') : string5;
                String string7 = string5;
                boolean bl2 = true;
                if (string != null && string.trim().length() != 0) {
                    bl2 = this.matchPattern(string7, string, sourceFile.isUsingGNUPattern());
                }
                String string8 = sourceFile.getExcludePattern();
                if (bl2 && string8 != null && string8.trim().length() != 0) {
                    bl2 = this.matchPattern(string7, string8, sourceFile.isUsingGNUExcludePattern()) ^ true;
                }
                String string9 = "";
                if (this.usingJarVersion()) {
                    string9 = this.getJarVersion(string4);
                }
                if (vector == null) {
                    if (bl2) {
                        byte[] byArray = null;
                        byArray = string9 == null || string9.trim().length() == 0 ? new byte[]{} : string9.getBytes(JAR_VERSION_ENCODING);
                        FileAttributes fileAttributes2 = this.initializeSourceFileForBuild(string3, fileAttributes);
                        ArchiveIndexEntry archiveIndexEntry = null;
                        if (this.storedAs == 0) {
                            archiveIndexEntry = productBuilderSupport.putIndexedResource(new URL("ismpfile", "", -1, URLUtils.encode(FileUtils.normalizeFileName(file.getAbsolutePath()))), this.getArchiveIndexEntryType(sourceFile), string6, fileAttributes2, file.lastModified(), byArray);
                        } else if (this.storedAs == 1) {
                            archiveIndexEntry = productBuilderSupport.putExternalResource(new URL("ismpfile", "", -1, URLUtils.encode(FileUtils.normalizeFileName(file.getAbsolutePath()))), this.getArchiveIndexEntryType(sourceFile), string6, fileAttributes2, file.lastModified(), this.externalResourceLocation, byArray, this.externalResourceMediaId);
                        }
                        this.totalBytes += archiveIndexEntry.size;
                    }
                } else if (bl2) {
                    Properties properties = new Properties();
                    ((Hashtable)properties).put("sourceName", FileUtils.normalizeFileName(file.getAbsolutePath()));
                    ((Hashtable)properties).put("targetName", string7);
                    ((Hashtable)properties).put("size", new Long(file.length()));
                    ((Hashtable)properties).put("lastModified", new Long(file.lastModified()));
                    ((Hashtable)properties).put("fileType", new Integer(sourceFile.getFileType()));
                    ((Hashtable)properties).put("entryType", new Integer(sourceFile.getEntryType()));
                    ((Hashtable)properties).put("includeSubdirs", new Boolean(sourceFile.getIncludeSubdirs()));
                    ((Hashtable)properties).put("jarVersion", string9);
                    vector.addElement(properties);
                }
            }
            catch (RegExprSyntaxException regExprSyntaxException) {
                this.logEvent(productBuilderSupport, this, "wrn", "Invalid regular expression: " + regExprSyntaxException.getMessage());
            }
            catch (IOException iOException) {
                this.logEvent(productBuilderSupport, this, "err", iOException);
            }
        } else if (file.isDirectory()) {
            String[] stringArray = file.list();
            int n = 0;
            while (stringArray != null && n < stringArray.length && !this.buildCanceled(productBuilderSupport)) {
                File file2 = new File(file, stringArray[n]);
                SourceFile sourceFile2 = new SourceFile(file2.getAbsolutePath());
                sourceFile2.setPattern(string);
                sourceFile2.setUsingGNUPattern(sourceFile.isUsingGNUPattern());
                sourceFile2.setUsingGNUExcludePattern(sourceFile.isUsingGNUExcludePattern());
                sourceFile2.setExcludePattern(sourceFile.getExcludePattern());
                sourceFile2.setPathForFiltering(sourceFile.getPathForFiltering());
                sourceFile2.setEntryType(2);
                sourceFile2.setFileType(sourceFile.getFileType());
                sourceFile2.setIncludeSubdirs(sourceFile.getIncludeSubdirs());
                sourceFile2.setPathForFiltering(sourceFile.getPathForFiltering());
                boolean bl3 = true;
                if (file2.isFile()) {
                    sourceFile2.setEntryType(1);
                    sourceFile2.setFileType(sourceFile.getFileType());
                    sourceFile2.setIncludeSubdirs(false);
                    this.buildFile(string, sourceFile2, false, fileAttributes, productBuilderSupport, string2, vector, wizardServices);
                } else if (file.isDirectory() && sourceFile.isDirectoryTree()) {
                    block37: {
                        try {
                            Object object;
                            boolean bl4 = true;
                            String string10 = file2.getAbsolutePath();
                            String string11 = string2 != null ? FileUtils.normalizeFileName(string10.substring(string2.length()), '/') : file2.getName();
                            String string12 = file2.getName();
                            if (sourceFile.getPathForFiltering() == 1) {
                                object = sourceFile.getExcludePattern();
                                if (object != null && ((String)object).trim().length() != 0) {
                                    bl3 = bl4 = this.matchPattern(string12, (String)object, sourceFile.isUsingGNUExcludePattern()) ^ true;
                                }
                                if (bl4 && string != null && string.trim().length() != 0) {
                                    bl4 = this.matchPattern(string12, string, sourceFile.isUsingGNUPattern());
                                }
                            }
                            if (!bl4) break block37;
                            try {
                                if (vector == null) {
                                    object = null;
                                    object = this.initializeSourceFileForBuild(file2.getAbsolutePath(), fileAttributes);
                                    object = object == null ? new FileAttributes() : (FileAttributes)((FileAttributes)object).clone();
                                    ((FileAttributes)object).setAttributeState(4096, true);
                                    ArchiveIndexEntry archiveIndexEntry = null;
                                    if (this.storedAs == 0) {
                                        archiveIndexEntry = productBuilderSupport.putIndexedResource(new URL("ismpfile", "", -1, URLUtils.encode(file2.getAbsolutePath())), this.getArchiveIndexEntryType(sourceFile2), string11, (FileAttributes)object, file2.lastModified(), new byte[0]);
                                    } else if (this.storedAs == 1) {
                                        archiveIndexEntry = productBuilderSupport.putExternalResource(new URL("ismpfile", "", -1, URLUtils.encode(file2.getAbsolutePath())), this.getArchiveIndexEntryType(sourceFile2), string11, (FileAttributes)object, file2.lastModified(), this.externalResourceLocation, new byte[0], this.externalResourceMediaId);
                                    }
                                    this.totalBytes += archiveIndexEntry.size;
                                    break block37;
                                }
                                object = new Properties();
                                ((Hashtable)object).put("sourceName", FileUtils.normalizeFileName(file2.getAbsolutePath()));
                                ((Hashtable)object).put("targetName", string12);
                                ((Hashtable)object).put("size", new Long(0L));
                                ((Hashtable)object).put("lastModified", new Long(file2.lastModified()));
                                ((Hashtable)object).put("fileType", new Integer(sourceFile2.getFileType()));
                                ((Hashtable)object).put("entryType", new Integer(sourceFile2.getEntryType()));
                                ((Hashtable)object).put("includeSubdirs", new Boolean(sourceFile2.getIncludeSubdirs()));
                                ((Hashtable)object).put("jarVersion", "");
                                vector.addElement(object);
                            }
                            catch (IOException iOException) {
                                this.logEvent(productBuilderSupport, this, "err", iOException);
                            }
                        }
                        catch (RegExprSyntaxException regExprSyntaxException) {
                            this.logEvent(productBuilderSupport, this, "wrn", "Invalid regular expression: " + regExprSyntaxException.getMessage());
                        }
                    }
                    if (string2 == null) {
                        string2 = String.valueOf(string4) + (string4.endsWith(File.separator) ? "" : File.separator);
                    }
                    if (bl3 && !this.buildCanceled(productBuilderSupport)) {
                        this.buildFile(string, sourceFile2, false, fileAttributes, productBuilderSupport, string2, vector, wizardServices);
                    }
                }
                ++n;
            }
        } else {
            this.logEvent(productBuilderSupport, this, "err", "File does not exist: " + file.getAbsolutePath());
        }
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.building = false;
        this.totalBytes = -1L;
        buildEvent.getSupport().removeBuildListener(this);
    }

    private void buildImpl(Vector vector, ProductBuilderSupport productBuilderSupport, WizardServices wizardServices) {
        block8: {
            try {
                if (vector == null) {
                    this.building = true;
                    productBuilderSupport.addBuildListener(this);
                    this.nativeServicesAvailable = true;
                    productBuilderSupport.putClass((class$com$installshield$product$actions$SourceFile != null ? class$com$installshield$product$actions$SourceFile : (class$com$installshield$product$actions$SourceFile = Files.class$("com.installshield.product.actions.SourceFile"))).getName());
                    productBuilderSupport.putClass((class$com$installshield$product$actions$FilesBeanInfo != null ? class$com$installshield$product$actions$FilesBeanInfo : (class$com$installshield$product$actions$FilesBeanInfo = Files.class$("com.installshield.product.actions.FilesBeanInfo"))).getName());
                    productBuilderSupport.putClass((class$com$installshield$product$actions$FilesExtra != null ? class$com$installshield$product$actions$FilesExtra : (class$com$installshield$product$actions$FilesExtra = Files.class$("com.installshield.product.actions.FilesExtra"))).getName());
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$InstalledFile");
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$InstalledFiles");
                    productBuilderSupport.putClass("com.installshield.product.actions.Files$NativeAsciiInputStream");
                    productBuilderSupport.putRequiredService("fileService");
                    this.totalBytes = 0L;
                    this.archiveIndexOffset = productBuilderSupport.getCurrentArchiveIndexOffset();
                    Vector vector2 = this.files;
                    synchronized (vector2) {
                        int n = this.files.size();
                        int n2 = 0;
                        while (n2 < n && !this.buildCanceled(productBuilderSupport)) {
                            SourceFile sourceFile = (SourceFile)this.files.elementAt(n2);
                            this.buildFile(sourceFile.getPattern(), sourceFile, true, sourceFile.getAttributes(), productBuilderSupport, null, null, wizardServices);
                            ++n2;
                        }
                    }
                    this.archiveIndexLength = productBuilderSupport.getCurrentArchiveIndexOffset() - this.archiveIndexOffset;
                    break block8;
                }
                int n = this.files.size();
                int n3 = 0;
                while (n3 < n) {
                    SourceFile sourceFile = (SourceFile)this.files.elementAt(n3);
                    this.buildFile(sourceFile.getPattern(), sourceFile, true, sourceFile.getAttributes(), productBuilderSupport, null, vector, wizardServices);
                    ++n3;
                }
            }
            catch (IOException iOException) {
                this.logEvent(this, "err", iOException);
            }
        }
    }

    public Enumeration buildList(WizardServices wizardServices) {
        Vector vector = new Vector();
        this.buildImpl(vector, null, wizardServices);
        return vector.elements();
    }

    public void buildStarted(BuildEvent buildEvent) {
    }

    private int calculateTimeToInstall(int n, long l) {
        return Math.max(1, Math.round((float)n * 0.25f) + Math.round((float)l * 2.5E-7f));
    }

    protected boolean canCopyFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (!this.destinationExists(file)) {
            return true;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        return this.copyAllowed(this.compareDates(l, this.getLastModifiedDate(file)), n, file, productActionSupport);
    }

    protected boolean canCopyFile(File file, int n, ArchiveIndexAccessor archiveIndexAccessor, int n2, ProductActionSupport productActionSupport) throws ServiceException, IOException {
        String string;
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        block26: {
            if (!this.destinationExists(file)) {
                return true;
            }
            if (n == 1) {
                return true;
            }
            if (n == 2) {
                return false;
            }
            bl2 = false;
            bl = false;
            try {
                object2 = (FileService)this.getService("fileService");
                try {
                    object = this.getExtra(object2.getPlatformId());
                    if (object == null || !this.usingVersionChecker((FilesExtra)object)) break block26;
                    string = FileUtils.createTempFile();
                    InputStream inputStream = this.getResourceInputStream(n2);
                    FileOutputStream fileOutputStream = null;
                    try {
                        try {
                            fileOutputStream = new FileOutputStream(string);
                            FileUtils.copy(inputStream, fileOutputStream);
                            inputStream.close();
                            inputStream = null;
                            fileOutputStream.close();
                            fileOutputStream = null;
                            int n3 = ((FilesExtra)object).compareFileVersions(string, FileUtils.normalizeFileName(file.getAbsolutePath()), this.getServices());
                            bl2 = this.copyAllowed(n3, n, file, productActionSupport);
                            bl = true;
                        }
                        catch (IOException iOException) {
                            this.logEvent(this, "wrn", "Unable to compare platform versions for " + file.getAbsolutePath() + ". " + iOException);
                        }
                        Object var14_16 = null;
                    }
                    catch (Throwable throwable) {
                        Object var14_17 = null;
                        try {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        try {
                            if (fileOutputStream != null) {
                                fileOutputStream.close();
                            }
                        }
                        catch (IOException iOException) {}
                        FileUtils.deleteTempFile(string);
                        throw throwable;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    try {
                        if (fileOutputStream != null) {
                            fileOutputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                    FileUtils.deleteTempFile(string);
                }
                catch (ServiceException serviceException) {}
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "wrn", "File service not available to check platform version information. " + serviceException);
            }
        }
        if (!bl && this.destinationExists(file) && this.usingJarVersion()) {
            object2 = archiveIndexAccessor.getExtra(n2);
            object = this.getJarVersion(FileUtils.normalizeFileName(file.getAbsolutePath()));
            if (object != null && ((String)object).length() > 0 || object2 != null && ((Object)object2).length > 0) {
                string = new String((byte[])object2, JAR_VERSION_ENCODING);
                try {
                    bl2 = this.copyAllowed(this.compareJarVersions(string, (String)object), n, file, productActionSupport);
                    bl = true;
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
        if (!bl && this.usingLastModifiedDate()) {
            bl2 = this.canCopyFile(file, n, archiveIndexAccessor.getLastModified(n2), productActionSupport);
            bl = true;
        }
        return bl2;
    }

    protected boolean canRemoveFile(File file, int n, long l, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REMOVE_EXISTING) == null) {
            this.setValue(REMOVE_EXISTING, "unspecified");
        }
        if (this.getValue(REMOVE_MODIFIED) == null) {
            this.setValue(REMOVE_MODIFIED, "unspecified");
        }
        if (!this.destinationExists(file)) {
            return false;
        }
        if (n == 1) {
            return true;
        }
        if (n == 2) {
            return false;
        }
        if (n == 3) {
            return this.compareDates(l, this.getLastModifiedDate(file)) == 0;
        }
        if (n == 4) {
            long l2 = this.getLastModifiedDate(file);
            String string = this.formatPathForMessage(file.getAbsolutePath());
            this.logDebugEvent(String.valueOf(string) + "internal last modified = " + l);
            this.logDebugEvent(String.valueOf(string) + " last modified = " + l2);
            if (this.compareDates(l, l2) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string2 = (String)this.getValue(REMOVE_MODIFIED);
                return string2.equals(YES_RESPONSE) || string2.equals(YES_TO_ALL_RESPONSE);
            }
            return true;
        }
        if (n == 5) {
            if (this.compareDates(l, this.getLastModifiedDate(file)) != 0) {
                this.refreshRemoveModifiedResponse(file);
                String string = (String)this.getValue(REMOVE_MODIFIED);
                return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
            }
            this.refreshRemoveExistingResponse(file);
            String string = (String)this.getValue(REMOVE_EXISTING);
            return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalRemoveOption", new String[]{String.valueOf(n)}));
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected int compareDates(long l, long l2) {
        long l3 = l - l2;
        if (Math.abs(l - l2) <= 2000L) {
            return 0;
        }
        return l3 > 0L ? 1 : -1;
    }

    protected int compareJarVersions(String string, String string2) {
        String[] stringArray;
        int n = 0;
        String[] stringArray2 = this.parseImplementationVersion(string);
        n = this.compareNumeric(stringArray2[0], (stringArray = this.parseImplementationVersion(string2))[0]);
        if (n == 0) {
            n = this.compareNumeric(stringArray2[1], stringArray[1]);
        }
        if (n == 0) {
            n = this.compareNumeric(stringArray2[2], stringArray[2]);
        }
        if (n == 0) {
            n = stringArray2[3].compareTo(stringArray[3]);
        }
        return n;
    }

    private int compareNumeric(String string, String string2) {
        if (string.length() == 0) {
            if (string2.length() == 0) {
                return 0;
            }
            return -1;
        }
        if (string2.length() == 0) {
            return 1;
        }
        try {
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            if (n == n2) {
                return 0;
            }
            if (n > n2) {
                return 1;
            }
            return -1;
        }
        catch (NumberFormatException numberFormatException) {
            return string.compareTo(string2);
        }
    }

    protected int copy(InputStream inputStream, String string, MutableOperationState mutableOperationState) throws IOException {
        FileOutputStream fileOutputStream;
        int n;
        block5: {
            n = 0;
            fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                int n2 = 0;
                while (this.checkOperationState(mutableOperationState) && (n2 = inputStream.read(this.buf)) != -1) {
                    fileOutputStream.write(this.buf, 0, n2);
                    n += n2;
                    mutableOperationState.updatePercentComplete(this.timeToInstall, n2, this.totalBytes);
                }
                if (n2 != -1 || this.totalBytes != 0L) break block5;
                mutableOperationState.updatePercentComplete(this.timeToInstall, 1L, 1L);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                throw throwable;
            }
        }
        Object var7_7 = null;
        if (fileOutputStream != null) {
            fileOutputStream.close();
        }
        return n;
    }

    private boolean copyAllowed(int n, int n2, File file, ProductActionSupport productActionSupport) throws ServiceException {
        if (this.getValue(REPLACE_EXISTING) == null) {
            this.setValue(REPLACE_EXISTING, "unspecified");
        }
        if (this.getValue(REPLACE_NEWER) == null) {
            this.setValue(REPLACE_NEWER, "unspecified");
        }
        switch (n2) {
            case 5: {
                if (n < 0) {
                    this.refreshReplaceNewerResponse(file);
                    String string = (String)this.getValue(REPLACE_NEWER);
                    return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
                }
                this.refreshReplaceExistingResponse(file, n > 0);
                String string = (String)this.getValue(REPLACE_EXISTING);
                return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
            }
            case 4: {
                if (n < 0) {
                    this.refreshReplaceNewerResponse(file);
                    String string = (String)this.getValue(REPLACE_NEWER);
                    return string.equals(YES_RESPONSE) || string.equals(YES_TO_ALL_RESPONSE);
                }
                return true;
            }
            case 3: {
                return n > 0;
            }
        }
        productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.illegalReplaceOption", new String[]{String.valueOf(n2)}));
        return false;
    }

    protected final void copyFileWithFileService(InputStream inputStream, File file, MutableOperationState mutableOperationState, FileService fileService, ArchiveIndexAccessor archiveIndexAccessor, int n, ProductActionSupport productActionSupport) throws IOException, ServiceException {
        String string = new File(file.getParent(), FileUtils.createTempFileName()).getAbsolutePath();
        this.copy(inputStream, string, mutableOperationState);
        if (!mutableOperationState.isCanceled()) {
            this.setAttributes(string, archiveIndexAccessor, n, fileService, productActionSupport);
            this.setFileTimes(string, archiveIndexAccessor, n, fileService, productActionSupport);
        }
        this.moveFileWithFileService(string, file, mutableOperationState, fileService, archiveIndexAccessor, n, productActionSupport);
        FileUtils.clearTempFile(string);
    }

    protected String[] createDirs(File file) throws IOException {
        Object object;
        Stack<File> stack = new Stack<File>();
        File file2 = file;
        while (file2 != null && !file2.exists()) {
            stack.push(file2);
            object = file2.getParent();
            File file3 = file2 = object != null ? new File((String)object) : null;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            file2 = (File)stack.pop();
            if (file2.exists()) continue;
            if (!file2.mkdir()) {
                throw new IOException(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotCreateDir", new String[]{file2.getAbsolutePath()}));
            }
            ((Vector)object).addElement(file2.getAbsolutePath());
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    protected boolean deleteDirWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                bl = fileService.deleteDirectory(file.getAbsolutePath()) == 0;
            }
        }
        catch (ServiceException serviceException) {}
        return bl;
    }

    protected boolean deleteFileWithFileService(File file) {
        boolean bl = false;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService != null) {
                fileService.deleteFile(file.getAbsolutePath());
                bl = true;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", serviceException.getMessage());
        }
        return bl;
    }

    protected boolean deleteWithFile(File file) {
        return file.delete();
    }

    protected void deletedFileDuringUninstall(String string) {
    }

    protected void deletingFileDuringUninstall(String string) {
    }

    protected boolean destinationExists(File file) throws ServiceException {
        return file.exists();
    }

    protected final String formatCaption(String string) {
        return string;
    }

    protected String formatPathForCaption(String string) {
        return string;
    }

    protected String formatPathForMessage(String string) {
        return FileUtils.normalizeFileName(string);
    }

    public String getArchiveIndexEntry() {
        if (this.archiveIndexOffset >= 0 && this.archiveIndexLength >= 0) {
            return String.valueOf(this.archiveIndexOffset) + "/" + this.archiveIndexLength;
        }
        return null;
    }

    private int getArchiveIndexEntryType(SourceFile sourceFile) {
        if (sourceFile.getFileType() == 2) {
            return 2;
        }
        if (sourceFile.getFileType() == 1) {
            return 0;
        }
        return -1;
    }

    private boolean getAttributesSupported() {
        return this.getValue(CANT_SET_ATTRIBUTES_FLAG) == null;
    }

    public int getEstimatedTimeToInstall() {
        return this.calculateTimeToInstall(this.archiveIndexLength, this.totalBytes);
    }

    public int getEstimatedTimeToReplace() {
        return this.calculateTimeToInstall(this.archiveIndexLength, this.totalBytes);
    }

    public String getExternalResourceLocation() {
        return this.externalResourceLocation;
    }

    public int getExternalResourceMediaId() {
        return this.externalResourceMediaId;
    }

    private FilesExtra getExtra(String string) {
        FilesExtra filesExtra = null;
        Dictionary dictionary = this.getExtendedProperties();
        if (dictionary != null) {
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements() && filesExtra == null) {
                Object k = enumeration.nextElement();
                Object v = dictionary.get(k);
                if (v == null || !(v instanceof FilesExtra) || !string.equals(((FilesExtra)v).getPlatformId())) continue;
                filesExtra = (FilesExtra)v;
            }
        }
        return filesExtra;
    }

    public SourceFile getFile(int n) {
        return (SourceFile)this.files.elementAt(n);
    }

    public SourceFile[] getFiles() {
        if (this.building) {
            return null;
        }
        Object[] objectArray = new SourceFile[this.files.size()];
        this.files.copyInto(objectArray);
        return objectArray;
    }

    public int getFilesCount() {
        return this.files.size();
    }

    public String getGroup() {
        return this.group;
    }

    public String getInstallLocation() {
        return this.installLocation;
    }

    protected String getJarVersion(String string) {
        String string2 = "";
        if (ZipUtils.isZipEmpty(string)) {
            return string2;
        }
        try {
            Method method;
            Class.forName("java.util.jar.JarFile");
            Class<?> clazz = Class.forName("com.installshield.util.ManifestHelper");
            if (clazz != null && (method = clazz.getMethod("getMainImplementationVersion", class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = Files.class$("java.lang.String")))) != null) {
                string2 = (String)method.invoke(null, (Object[])new String[]{string});
            }
        }
        catch (Throwable throwable) {}
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    protected long getLastModifiedDate(File file) throws ServiceException {
        return file.lastModified();
    }

    private int getOptionalIndex(String string, int n) {
        int n2 = string.indexOf("-", n);
        int n3 = string.indexOf("_", n);
        if (n2 < 0) {
            return n3;
        }
        if (n3 < 0) {
            return n2;
        }
        return Math.min(n2, n3);
    }

    public String getOwner() {
        return this.owner;
    }

    public int getReplaceType() {
        return this.replaceType;
    }

    public RequiredBytesTable getRequiredBytes() throws ProductException {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        if (this.totalBytes != -1L) {
            String string = this.getProductTree().getInstallLocation(this);
            requiredBytesTable.addBytes(string, this.totalBytes);
        }
        return requiredBytesTable;
    }

    public RequiredBytesTable getRequiredBytesForReplace() throws ProductException {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        if (this.totalBytes != -1L) {
            String string = this.getProductTree().getInstallLocation(this);
            requiredBytesTable.addBytes(string, this.totalBytes);
        }
        return requiredBytesTable;
    }

    public ResourceIndexRange[] getResourceIndicesForInstall() {
        if (this.archiveIndexOffset != -1 && this.archiveIndexLength > 0) {
            return new ResourceIndexRange[]{new ResourceIndexRange(this.archiveIndexOffset, this.archiveIndexLength)};
        }
        return new ResourceIndexRange[0];
    }

    public ResourceIndexRange[] getResourceIndicesForReplace() {
        if (this.archiveIndexOffset != -1 && this.archiveIndexLength > 0) {
            return new ResourceIndexRange[]{new ResourceIndexRange(this.archiveIndexOffset, this.archiveIndexLength)};
        }
        return new ResourceIndexRange[0];
    }

    public InputStream getResourceInputStream(int n) throws IOException, ServiceException {
        if (this.getStoredAs() == 0) {
            return this.getIndexedResource(n).openStream();
        }
        if (this.getStoredAs() == 1) {
            return this.getExternalResource(n).openStream();
        }
        return null;
    }

    public int getStoredAs() {
        return this.storedAs;
    }

    private String getToken(String string, String string2, int n) {
        if (n <= 0) {
            return "";
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        int n2 = 0;
        String string3 = "";
        while (n2 < n && stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            ++n2;
        }
        return n2 == n ? string3 : "";
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public boolean getUseJARVersion() {
        return this.useJARVersion;
    }

    protected Object getValue(String string) {
        return this.getServices().getValue(string);
    }

    protected final FileAttributes initializeSourceFileForBuild(SourceFile sourceFile, FileAttributes fileAttributes, WizardServices wizardServices) throws IOException {
        return this.initializeSourceFileForBuild(wizardServices.resolveString(sourceFile.getFileName()), fileAttributes);
    }

    protected final FileAttributes initializeSourceFileForBuild(String string, FileAttributes fileAttributes) throws IOException {
        block4: {
            if (this.nativeServicesAvailable) {
                try {
                    if (fileAttributes == null) {
                        FileService fileService = (FileService)this.getService("fileService");
                        return fileService.getFileAttributes(string);
                    }
                }
                catch (ServiceException serviceException) {
                    this.nativeServicesAvailable = false;
                    if (serviceException.getErrorCode() == 305) break block4;
                    throw new IOException(serviceException.toString());
                }
            }
        }
        return fileAttributes;
    }

    /*
     * Unable to fully structure code
     */
    public void install(ProductActionSupport var1_1) throws ProductException {
        var2_2 = this.getProductTree().getInstallLocation(this);
        var3_3 = false;
        var4_4 = var1_1.getOperationState();
        this.timeToInstall = this.getEstimatedTimeToInstall();
        try {
            try {
                this.installed = new InstalledFiles();
                var7_5 = String.valueOf(this.getBeanId()) + "/installed";
                var1_1.putUninstallerResource(this.installed.getIndexFileName(), var7_5);
                var1_1.removeUninstallerResourceExclusion(var7_5);
                var8_8 = this.getProductTree().getReplaceOption(this);
                var9_9 = this.getArchiveIndexAccessor();
                var10_10 = (FileService)this.getService("fileService");
                var11_11 = this.resolveString(this.group);
                var12_12 = this.resolveString(this.owner);
                var13_13 = this.archiveIndexOffset + this.archiveIndexLength;
                var14_14 = new FileAttributes();
                var14_14.setAttributes(4607);
                var15_15 = this.archiveIndexOffset;
                while (!var4_4.isCanceled() && var15_15 < var13_13) {
                    var16_16 = var9_9.getAttributes(var15_15);
                    if (var16_16 != null && var16_16.getAttributeState(4096)) {
                        var17_18 = var9_9.getFileName(var15_15).replace('/', File.separatorChar);
                        var18_20 = new File(var2_2, (String)var17_18);
                        if (!this.destinationExists((File)var18_20)) {
                            var19_21 = this.createDirs((File)var18_20);
                            var20_22 = false;
                            while (var20_22 < ((String[])var19_21).length) {
                                this.installed.add(var19_21[var20_22], -1L);
                                var20_22 += 1;
                            }
                        }
                        this.setAttributes(var18_20.getAbsolutePath(), var14_14, var10_10, var1_1);
                        if (var11_11 != null && var11_11.length() > 0) {
                            this.setFileGroup(var18_20.getAbsolutePath(), var11_11, var10_10);
                        }
                        if (var12_12 != null && var12_12.length() > 0) {
                            this.setFileOwner(var18_20.getAbsolutePath(), var12_12, var10_10);
                        }
                        var4_4.updatePercentComplete(this.timeToInstall, var9_9.getSize(var15_15), this.totalBytes);
                    }
                    ++var15_15;
                }
                var16_17 = this.archiveIndexOffset;
                while (!var4_4.isCanceled() && var16_17 < var13_13) {
                    block34: {
                        block36: {
                            block35: {
                                var17_18 = var9_9.getAttributes(var16_17);
                                if (var17_18 != null && var17_18.getAttributeState(4096)) break block34;
                                var18_20 = var9_9.getFileName(var16_17).replace('/', File.separatorChar);
                                var19_21 = new File(var2_2, (String)var18_20);
                                if (!this.canCopyFile((File)var19_21, var8_8, var9_9, var16_17, var1_1)) break block35;
                                var20_22 = this.destinationExists((File)var19_21);
                                if (var20_22) {
                                    this.overwritingFileDuringInstall(var19_21.getAbsolutePath(), var8_8, var9_9, var16_17, var1_1);
                                }
                                var4_4.setStatusDetail(this.formatPathForCaption(var19_21.getAbsolutePath()));
                                var21_25 = new File(var19_21.getParent());
                                if (!this.destinationExists(var21_25)) {
                                    var22_26 = this.createDirs(var21_25);
                                    var23_29 = 0;
                                    while (var23_29 < var22_26.length) {
                                        this.installed.add(var22_26[var23_29], -1L);
                                        ++var23_29;
                                    }
                                }
                                try {
                                    block33: {
                                        try {
                                            var24_31 = this.getResourceInputStream(var16_17);
                                            var25_33 = var9_9.getType(var16_17);
                                            var26_34 = false;
                                            try {
                                                var27_35 = var19_21.getAbsolutePath();
                                                if (var25_33 != 2) {
                                                    var24_31 = new NativeAsciiInputStream(var24_31, var25_33);
                                                }
                                                this.copy(var24_31, var27_35, var4_4);
                                                var26_34 = true;
                                            }
                                            catch (IOException v0) {
                                                this.copyFileWithFileService(var24_31, (File)var19_21, var4_4, var10_10, var9_9, var16_17, var1_1);
                                            }
                                            var24_31.close();
                                            if (var26_34 && !var4_4.isCanceled()) {
                                                this.setAttributes(var19_21.getAbsolutePath(), var9_9, var16_17, var10_10, var1_1);
                                                this.setFileTimes(var19_21.getAbsolutePath(), var9_9, var16_17, var10_10, var1_1);
                                            }
                                            if (var11_11 != null && var11_11.length() > 0) {
                                                this.setFileGroup(var19_21.getAbsolutePath(), var11_11, var10_10);
                                            }
                                            if (var12_12 != null && var12_12.length() > 0) {
                                                this.setFileOwner(var19_21.getAbsolutePath(), var12_12, var10_10);
                                            }
                                            this.wroteFileDuringInstall(var19_21.getAbsolutePath(), var20_22);
                                            this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), "createFile", var19_21));
                                        }
                                        catch (ServiceException var24_32) {
                                            if (var24_32.getErrorCode() != 2) break block33;
                                            throw new ProductException(601, var24_32.getMessage());
                                        }
                                    }
                                    var23_28 = null;
                                }
                                catch (Throwable var22_27) {
                                    var23_30 = null;
                                    this.installed.add(var19_21.getAbsolutePath(), this.getLastModifiedDate((File)var19_21));
                                    throw var22_27;
                                }
                                this.installed.add(var19_21.getAbsolutePath(), this.getLastModifiedDate((File)var19_21));
                                break block36;
                            }
                            var4_4.updatePercentComplete(this.timeToInstall, var9_9.getSize(var16_17), this.totalBytes);
                        }
                        this.processedFileDuringInstall(var19_21.getAbsolutePath());
                    }
                    ++var16_17;
                }
                var17_19 = this.archiveIndexOffset;
                while (!var4_4.isCanceled() && var17_19 < var13_13) {
                    var18_20 = var9_9.getAttributes(var17_19);
                    if (var18_20 != null && var18_20.getAttributeState(4096) && this.destinationExists(var20_24 = new File(var2_2, (String)(var19_21 = var9_9.getFileName(var17_19).replace('/', File.separatorChar))))) {
                        this.setAttributes(var20_24.getAbsolutePath(), var9_9, var17_19, var10_10, var1_1);
                    }
                    ++var17_19;
                }
            }
            catch (IOException var7_6) {
                this.logEvent(this, "err", var7_6);
                var3_3 = true;
            }
            catch (ServiceException var7_7) {
                this.logEvent(this, "err", var7_7);
                var3_3 = true;
            }
            var6_36 = null;
            var1_1.getOperationState().setStatusDetail("");
            ** if (this.installed == null) goto lbl-1000
        }
        catch (Throwable var5_38) {
            var6_37 = null;
            var1_1.getOperationState().setStatusDetail("");
            if (this.installed != null) {
                try {
                    this.installed.close();
                }
                catch (IOException v2) {}
            }
            throw var5_38;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.installed.close();
            }
            catch (IOException v1) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var3_3) {
            var1_1.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.installError", new String[]{this.getBeanId()}));
        }
    }

    public boolean isBuilding() {
        return this.building;
    }

    protected boolean isDirectory(File file) {
        return file.isDirectory();
    }

    private void logDebugEvent(String string) {
        this.logEvent(this, WizardLog.subclassEvent("dbg", "files"), string);
    }

    private void logEvent(ProductBuilderSupport productBuilderSupport, Object object, String string, Object object2) {
        if (productBuilderSupport != null) {
            productBuilderSupport.logEvent(object, string, object2);
        }
    }

    private String mapResponse(String string) {
        String string2 = YES_RESPONSE;
        if (string.equals(this.resolveString(YES))) {
            string2 = YES_RESPONSE;
        } else if (string.equals(this.resolveString(YES_TO_ALL))) {
            string2 = YES_TO_ALL_RESPONSE;
        } else if (string.equals(this.resolveString(NO))) {
            string2 = NO_RESPONSE;
        } else if (string.equals(this.resolveString(NO_TO_ALL))) {
            string2 = NO_TO_ALL_RESPONSE;
        }
        return string2;
    }

    private boolean matchPattern(String string, String string2, boolean bl) throws RegExprSyntaxException {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";", false);
        boolean bl2 = false;
        while (!bl2 && stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3 == null || string3.length() <= 0) continue;
            bl2 = bl ? this.rexMatches(string, string3) : this.rexMatches(string, String.valueOf(this.translateToGNUPattern(string3)) + "$");
        }
        return bl2;
    }

    protected void moveFileWithFileService(String string, File file, MutableOperationState mutableOperationState, FileService fileService, ArchiveIndexAccessor archiveIndexAccessor, int n, ProductActionSupport productActionSupport) throws IOException, ServiceException {
        fileService.moveFile(string, file.getAbsolutePath(), true);
    }

    protected void overwritingFileDuringInstall(String string, int n, ArchiveIndexAccessor archiveIndexAccessor, int n2, ProductActionSupport productActionSupport) {
    }

    protected void overwritingFileDuringReplace(String string, int n, ArchiveIndexAccessor archiveIndexAccessor, int n2, ProductActionSupport productActionSupport) {
    }

    private String[] parseImplementationVersion(String string) {
        String[] stringArray = new String[4];
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = "";
            ++n;
        }
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < 4) {
            stringArray[n2] = stringTokenizer.nextToken();
            ++n2;
        }
        if (stringTokenizer.hasMoreTokens()) {
            throw new NumberFormatException();
        }
        if (stringArray[0] == null || stringArray[1] == null || !this.validInteger(stringArray[0])) {
            throw new NumberFormatException();
        }
        int n3 = this.getOptionalIndex(stringArray[1], 0);
        if (n3 >= 0) {
            stringArray[3] = stringArray[1].substring(n3 + 1);
            if (stringArray[3].length() <= 0) {
                throw new NumberFormatException();
            }
            stringArray[1] = stringArray[1].substring(0, n3);
        } else {
            n3 = this.getOptionalIndex(stringArray[2], 0);
            if (n3 >= 0) {
                stringArray[3] = stringArray[2].substring(n3 + 1);
                if (stringArray[3].length() <= 0) {
                    throw new NumberFormatException();
                }
                stringArray[2] = stringArray[2].substring(0, n3);
            }
        }
        if (!this.validInteger(stringArray[1])) {
            throw new NumberFormatException();
        }
        if (stringArray[2].length() > 0 && !this.validInteger(stringArray[2])) {
            throw new NumberFormatException();
        }
        return stringArray;
    }

    protected void processedFileDuringInstall(String string) {
    }

    protected void processedFileDuringReplace(String string) {
    }

    protected void processedFileDuringUninstall(String string) {
    }

    protected void refreshRemoveExistingResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_EXISTING);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileExisting", new String[]{this.formatPathForMessage(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            string = this.mapResponse(string);
            this.setValue(REMOVE_EXISTING, string);
        }
    }

    protected void refreshRemoveModifiedResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REMOVE_MODIFIED);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.removeExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.fileModified", new String[]{this.formatPathForMessage(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            string = this.mapResponse(string);
            this.setValue(REMOVE_MODIFIED, string);
        }
    }

    protected final void refreshReplaceExistingResponse(File file, boolean bl) throws ServiceException {
        String string = (String)this.getValue(REPLACE_EXISTING);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            String string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.alreadyExist", new String[]{this.formatPathForMessage(file.getAbsolutePath())});
            if (bl) {
                string2 = LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.olderVersionExists", new String[]{this.formatPathForMessage(file.getAbsolutePath())});
            }
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceExistingFile"), string2, new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(YES));
            string = this.mapResponse(string);
            this.setValue(REPLACE_EXISTING, string);
        }
    }

    protected final void refreshReplaceNewerResponse(File file) throws ServiceException {
        String string = (String)this.getValue(REPLACE_NEWER);
        if (!string.equals(YES_TO_ALL_RESPONSE) && !string.equals(NO_TO_ALL_RESPONSE)) {
            string = (String)this.getServices().getUserInput(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceExistingFile"), LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.newerVersionExist", new String[]{this.formatPathForMessage(file.getAbsolutePath())}), new Object[]{this.resolveString(YES), this.resolveString(YES_TO_ALL), this.resolveString(NO), this.resolveString(NO_TO_ALL)}, this.resolveString(NO));
            string = this.mapResponse(string);
            this.setValue(REPLACE_NEWER, string);
        }
    }

    public void removeFile(int n) {
        this.files.removeElementAt(n);
    }

    public void removeFile(SourceFile sourceFile) {
        this.files.removeElement(sourceFile);
    }

    public void removeFiles(int[] nArray) {
        if (nArray != null && nArray.length > 0) {
            SourceFile[] sourceFileArray = new SourceFile[nArray.length];
            int n = 0;
            while (n < nArray.length) {
                sourceFileArray[n] = this.getFile(nArray[n]);
                ++n;
            }
            int n2 = 0;
            while (n2 < sourceFileArray.length) {
                this.removeFile(sourceFileArray[n2]);
                ++n2;
            }
        }
    }

    public void replace(ProductAction productAction, ProductActionSupport productActionSupport) throws ProductException {
        boolean bl;
        block40: {
            bl = false;
            Hashtable<String, Long> hashtable = new Hashtable<String, Long>();
            Vector<String> vector = new Vector<String>();
            InstalledFiles installedFiles = null;
            try {
                try {
                    boolean bl2;
                    Object object;
                    Object object2;
                    Object object3;
                    String string = productAction.getProductTree().getInstallLocation(productAction);
                    MutableOperationState mutableOperationState = productActionSupport.getOperationState();
                    this.timeToInstall = this.getEstimatedTimeToInstall();
                    int n = this.getProductTree().getReplaceOption(this);
                    ArchiveIndexAccessor archiveIndexAccessor = this.getArchiveIndexAccessor();
                    FileService fileService = (FileService)this.getService("fileService");
                    String string2 = this.resolveString(this.group);
                    String string3 = this.resolveString(this.owner);
                    int n2 = this.archiveIndexOffset + this.archiveIndexLength;
                    int n3 = this.archiveIndexOffset;
                    while (!mutableOperationState.isCanceled() && n3 < n2) {
                        FileAttributes fileAttributes = archiveIndexAccessor.getAttributes(n3);
                        if (fileAttributes != null && fileAttributes.getAttributeState(4096)) {
                            object3 = archiveIndexAccessor.getFileName(n3).replace('/', File.separatorChar);
                            object2 = new File(string, (String)object3);
                            if (!this.destinationExists((File)object2)) {
                                object = this.createDirs((File)object2);
                                bl2 = false;
                                while (bl2 < ((String[])object).length) {
                                    hashtable.put(object[bl2], new Long(-1L));
                                    vector.addElement(object[bl2]);
                                    bl2 += 1;
                                }
                            }
                            this.setAttributes(((File)object2).getAbsolutePath(), archiveIndexAccessor, n3, fileService, productActionSupport);
                            if (string2 != null && string2.length() > 0) {
                                this.setFileGroup(((File)object2).getAbsolutePath(), string2, fileService);
                            }
                            if (string3 != null && string3.length() > 0) {
                                this.setFileOwner(((File)object2).getAbsolutePath(), string3, fileService);
                            }
                            mutableOperationState.updatePercentComplete(this.timeToInstall, archiveIndexAccessor.getSize(n3), this.totalBytes);
                        }
                        ++n3;
                    }
                    int n4 = this.archiveIndexOffset;
                    while (!mutableOperationState.isCanceled() && n4 < n2) {
                        object3 = archiveIndexAccessor.getAttributes(n4);
                        if (object3 == null || !((FileAttributes)object3).getAttributeState(4096)) {
                            object2 = archiveIndexAccessor.getFileName(n4).replace('/', File.separatorChar);
                            object = new File(string, (String)object2);
                            if (this.canCopyFile((File)object, n, archiveIndexAccessor, n4, productActionSupport)) {
                                bl2 = this.destinationExists((File)object);
                                if (bl2) {
                                    this.overwritingFileDuringReplace(((File)object).getAbsolutePath(), n, archiveIndexAccessor, n4, productActionSupport);
                                }
                                mutableOperationState.setStatusDetail(this.formatPathForCaption(((File)object).getAbsolutePath()));
                                File file = new File(((File)object).getParent());
                                if (!this.destinationExists(file)) {
                                    String[] stringArray = this.createDirs(file);
                                    int n5 = 0;
                                    while (n5 < stringArray.length) {
                                        hashtable.put(stringArray[n5], new Long(-1L));
                                        vector.addElement(stringArray[n5]);
                                        ++n5;
                                    }
                                }
                                try {
                                    InputStream inputStream = this.getResourceInputStream(n4);
                                    int n6 = archiveIndexAccessor.getType(n4);
                                    boolean bl3 = false;
                                    try {
                                        String string4 = ((File)object).getAbsolutePath();
                                        if (n6 != 2) {
                                            inputStream = new NativeAsciiInputStream(inputStream, n6);
                                        }
                                        this.copy(inputStream, string4, mutableOperationState);
                                        bl3 = true;
                                    }
                                    catch (IOException iOException) {
                                        this.copyFileWithFileService(inputStream, (File)object, mutableOperationState, fileService, archiveIndexAccessor, n4, productActionSupport);
                                    }
                                    inputStream.close();
                                    if (bl3 && !mutableOperationState.isCanceled()) {
                                        this.setAttributes(((File)object).getAbsolutePath(), archiveIndexAccessor, n4, fileService, productActionSupport);
                                        this.setFileTimes(((File)object).getAbsolutePath(), archiveIndexAccessor, n4, fileService, productActionSupport);
                                    }
                                    if (string2 != null && string2.length() > 0) {
                                        this.setFileGroup(((File)object).getAbsolutePath(), string2, fileService);
                                    }
                                    if (string3 != null && string3.length() > 0) {
                                        this.setFileOwner(((File)object).getAbsolutePath(), string3, fileService);
                                    }
                                    this.wroteFileDuringReplace(((File)object).getAbsolutePath(), bl2);
                                    this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), REPLACE_FILE, object));
                                }
                                finally {
                                    Object var25_29 = null;
                                    hashtable.put(((File)object).getAbsolutePath(), new Long(this.getLastModifiedDate((File)object)));
                                    vector.addElement(((File)object).getAbsolutePath());
                                }
                            }
                            mutableOperationState.updatePercentComplete(this.timeToInstall, archiveIndexAccessor.getSize(n4), this.totalBytes);
                            this.processedFileDuringReplace(((File)object).getAbsolutePath());
                        }
                        ++n4;
                    }
                    productActionSupport.getOperationState().setStatusDetail(LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.updatingUninstallerInfo"));
                    this.installed = new InstalledFiles();
                    object3 = String.valueOf(this.getBeanId()) + "/installed";
                    productActionSupport.putUninstallerResource(this.installed.getIndexFileName(), (String)object3);
                    productActionSupport.removeUninstallerResourceExclusion((String)object3);
                    installedFiles = new InstalledFiles(this.getResource(String.valueOf(productAction.getBeanId()) + "/installed"));
                    object2 = installedFiles.read();
                    while (object2 != null) {
                        if (!hashtable.containsKey(((InstalledFile)object2).fileName)) {
                            this.installed.add(((InstalledFile)object2).fileName, ((InstalledFile)object2).lastModified);
                        } else {
                            this.installed.add(((InstalledFile)object2).fileName, (Long)hashtable.get(((InstalledFile)object2).fileName));
                            hashtable.remove(((InstalledFile)object2).fileName);
                        }
                        object2 = installedFiles.read();
                    }
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        String string5 = (String)object.nextElement();
                        if (!hashtable.containsKey(string5)) continue;
                        this.installed.add(string5, (Long)hashtable.get(string5));
                    }
                }
                catch (IOException iOException) {
                    this.logEvent(this, "err", iOException);
                    bl = true;
                }
                catch (ServiceException serviceException) {
                    this.logEvent(this, "err", serviceException);
                    bl = true;
                }
                Object var8_36 = null;
                productActionSupport.getOperationState().setStatusDetail("");
                if (installedFiles == null) break block40;
            }
            catch (Throwable throwable) {
                Object var8_37 = null;
                productActionSupport.getOperationState().setStatusDetail("");
                if (installedFiles != null) {
                    try {
                        installedFiles.close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.installed != null) {
                    try {
                        this.installed.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                installedFiles.close();
            }
            catch (IOException iOException) {}
        }
        if (this.installed != null) {
            try {
                this.installed.close();
            }
            catch (IOException iOException) {}
        }
        if (bl) {
            productActionSupport.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.replaceError", new String[]{productAction.getBeanId(), this.getBeanId()}));
        }
    }

    private boolean rexMatches(String string, String string2) throws RegExprSyntaxException {
        String string3 = string;
        String string4 = "\n";
        if (!string3.endsWith(string4)) {
            string3 = String.valueOf(string3) + string4;
        }
        return Rex.matches(string3, string2);
    }

    public void setArchiveIndexEntry(String string) {
        block2: {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            if (stringTokenizer.countTokens() != 2) break block2;
            try {
                this.archiveIndexOffset = Integer.parseInt(stringTokenizer.nextToken());
                this.archiveIndexLength = Integer.parseInt(stringTokenizer.nextToken());
            }
            catch (NumberFormatException numberFormatException) {
                this.archiveIndexOffset = -1;
                this.archiveIndexLength = -1;
            }
        }
    }

    private void setAttributes(String string, ArchiveIndexAccessor archiveIndexAccessor, int n, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        FileAttributes fileAttributes;
        if (this.getAttributesSupported() && (fileAttributes = archiveIndexAccessor.getAttributes(n)) != null) {
            this.setAttributes(string, fileAttributes, fileService, productActionSupport);
        }
    }

    private void setAttributes(String string, FileAttributes fileAttributes, FileService fileService, ProductActionSupport productActionSupport) {
        block3: {
            if (!this.getAttributesSupported()) break block3;
            try {
                fileService.setFileAttributes(string, fileAttributes);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file attributes: operation is not supported by the current file service implementation.");
                    this.setAttributesSupported();
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    private void setAttributesSupported() {
        this.setValue(CANT_SET_ATTRIBUTES_FLAG, "1");
    }

    public void setExternalResourceLocation(String string) {
        this.externalResourceLocation = string;
    }

    public void setExternalResourceMediaId(int n) {
        this.externalResourceMediaId = n;
    }

    private void setFileGroup(String string, String string2, FileService fileService) {
        block3: {
            if (this.getValue(CANT_SET_GROUP_FLAG) != null) break block3;
            try {
                fileService.setFileOwnerGroup(string, string2);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file group: operation is not supported by the current file service implementation.");
                    this.setValue(CANT_SET_GROUP_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    private void setFileOwner(String string, String string2, FileService fileService) {
        block3: {
            if (this.getValue(CANT_SET_OWNER_FLAG) != null) break block3;
            try {
                fileService.setFileOwner(string, string2);
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file owner: operation is not supported by the current file service implementation.");
                    this.setValue(CANT_SET_OWNER_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    protected final void setFileTimes(String string, ArchiveIndexAccessor archiveIndexAccessor, int n, FileService fileService, ProductActionSupport productActionSupport) throws IOException {
        block3: {
            long l;
            if (this.getValue(CANT_SET_FILE_TIMES_FLAG) != null || (l = archiveIndexAccessor.getLastModified(n)) <= 0L) break block3;
            try {
                fileService.setFileModified(string, archiveIndexAccessor.getLastModified(n));
            }
            catch (ServiceException serviceException) {
                if (serviceException.getErrorCode() == 305) {
                    this.logEvent(this, "wrn", "Cannot set file times: operation is not supported by the current file service implementation.");
                    this.setValue(CANT_SET_FILE_TIMES_FLAG, "1");
                    break block3;
                }
                this.logEvent(this, "err", serviceException);
            }
        }
    }

    public void setFiles(SourceFile[] sourceFileArray) {
        this.files.removeAllElements();
        if (sourceFileArray != null) {
            int n = 0;
            while (n < sourceFileArray.length) {
                this.files.addElement(sourceFileArray[n]);
                ++n;
            }
        }
    }

    public void setGroup(String string) {
        this.group = string;
    }

    public void setInstallLocation(String string) {
        this.installLocation = string.trim().length() == 0 ? null : string;
    }

    public void setOwner(String string) {
        this.owner = string;
    }

    public void setReplaceType(int n) {
        this.replaceType = n;
    }

    public void setStoredAs(int n) {
        this.storedAs = n;
    }

    public void setTotalBytes(long l) {
        this.totalBytes = l;
    }

    public void setUseJARVersion(boolean bl) {
        this.useJARVersion = bl;
    }

    protected void setValue(String string, Object object) {
        this.getServices().setValue(string, object);
    }

    private String translateToGNUPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) != '*' && string.charAt(n) != '?' && string.charAt(n) != '\\') {
                stringBuffer.append('\"');
                stringBuffer.append(string.charAt(n));
                stringBuffer.append('\"');
            } else if (string.charAt(n) == '\\') {
                stringBuffer.append('\\');
                stringBuffer.append('\\');
            } else if (string.charAt(n) == '*') {
                stringBuffer.append('.');
                stringBuffer.append('*');
            } else if (string.charAt(n) == '?') {
                stringBuffer.append('.');
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    /*
     * Unable to fully structure code
     */
    public void uninstall(ProductActionSupport var1_1) throws ProductException {
        var2_2 = false;
        var3_3 = false;
        var4_4 = new Vector<File>();
        try {
            try {
                var7_5 = this.getProductTree().getRemoveOption(this);
                if (this.installed != null) {
                    this.installed = new InstalledFiles(new URL("ismpfile", "", -1, URLUtils.encode(this.installed.getIndexFileName())));
                } else if (this.installed == null) {
                    this.installed = new InstalledFiles(this.getResource(String.valueOf(this.getBeanId()) + "/installed"));
                }
                var8_9 = this.installed.read();
                while (var8_9 != null) {
                    block34: {
                        var9_10 = new File(var8_9.fileName);
                        if (this.isDirectory(var9_10)) {
                            var4_4.addElement(var9_10);
                        } else {
                            try {
                                if (!this.canRemoveFile(var9_10, var7_5, var8_9.lastModified, var1_1)) break block34;
                                this.deletingFileDuringUninstall(var9_10.getAbsolutePath());
                                var10_12 = false;
                                try {
                                    if (this.deleteWithFile(var9_10)) {
                                        var10_12 = true;
                                    }
                                }
                                catch (Throwable v0) {}
                                if (!var10_12) {
                                    if (!this.deleteFileWithFileService(var9_10)) {
                                        this.logEvent(this, "wrn", "Could not delete file " + var9_10.getAbsolutePath());
                                        var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotDeleteFile", new String[]{var9_10.getAbsolutePath()}));
                                        var3_3 = true;
                                    } else {
                                        var10_12 = true;
                                    }
                                }
                                if (var10_12) {
                                    this.deletedFileDuringUninstall(var8_9.fileName);
                                    this.fireProductActionEvent(new ProductActionEvent(this, this.getParentComponent(), "deleteFile", var8_9.fileName));
                                }
                            }
                            catch (ServiceException var10_13) {
                                this.logEvent(this, "err", var10_13);
                            }
                        }
                    }
                    this.processedFileDuringUninstall(var8_9.fileName);
                    var8_9 = this.installed.read();
                }
                var9_11 = -1;
                while (var9_11 != 0) {
                    var9_11 = 0;
                    var10_14 = 0;
                    while (var10_14 < var4_4.size()) {
                        var11_16 = (File)var4_4.elementAt(var10_14);
                        if (var11_16 != null && this.deleteWithFile(var11_16)) {
                            var4_4.setElementAt(null, var10_14);
                            ++var9_11;
                        }
                        ++var10_14;
                    }
                }
                do {
                    var10_15 = false;
                    var11_17 = 0;
                    while (var11_17 < var4_4.size()) {
                        var12_18 = (File)var4_4.elementAt(var11_17);
                        if (var12_18 != null && this.deleteDirWithFileService(var12_18)) {
                            var10_15 = true;
                            var4_4.setElementAt(null, var11_17);
                        }
                        ++var11_17;
                    }
                } while (var10_15);
                var11_17 = 0;
                while (var11_17 < var4_4.size()) {
                    var12_18 = (File)var4_4.elementAt(var11_17);
                    if (var12_18 != null) {
                        var1_1.putInstalledDirectory(var12_18.getAbsolutePath());
                    }
                    ++var11_17;
                }
            }
            catch (IOException var7_6) {
                this.logEvent(this, "err", var7_6);
                var2_2 = true;
            }
            var6_19 = null;
            ** if (this.installed == null) goto lbl-1000
        }
        catch (Throwable var5_21) {
            var6_20 = null;
            if (this.installed != null) {
                try {
                    this.installed.close();
                    var7_8 = String.valueOf(this.getBeanId()) + "/installed";
                    var1_1.putUninstallerResourceExclusion(var7_8);
                }
                catch (IOException v2) {}
            }
            throw var5_21;
        }
lbl-1000:
        // 1 sources

        {
            try {
                this.installed.close();
                var7_7 = String.valueOf(this.getBeanId()) + "/installed";
                var1_1.putUninstallerResourceExclusion(var7_7);
            }
            catch (IOException v1) {}
        }
lbl-1000:
        // 2 sources

        {
        }
        if (var2_2) {
            var1_1.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.uninstallError", new String[]{this.getBeanId()}));
        }
        if (var3_3) {
            var1_1.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "Files.couldNotUninstallFiles", new String[]{this.getBeanId()}));
        }
    }

    private boolean usingJarVersion() {
        return (this.getReplaceType() == 101 || this.getReplaceType() == 102) && this.getUseJARVersion();
    }

    private boolean usingLastModifiedDate() {
        return this.getReplaceType() == 100 || this.getReplaceType() == 102;
    }

    private boolean usingVersionChecker(FilesExtra filesExtra) {
        return (this.getReplaceType() == 101 || this.getReplaceType() == 102) && filesExtra.isVersionCheckingEnabled();
    }

    private boolean validInteger(String string) {
        try {
            int n = Integer.parseInt(string);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public void writeFinished(BuildEvent buildEvent) {
    }

    public void writeStarting(BuildEvent buildEvent) {
    }

    protected void wroteFileDuringInstall(String string, boolean bl) {
    }

    protected void wroteFileDuringReplace(String string, boolean bl) {
    }

    protected class InstalledFiles {
        private final int READ = 1;
        private final int WRITE = 2;
        private final byte EOF = (byte)-128;
        private int mode;
        private String indexFileName;
        private DataOutputStream out;
        private DataInputStream in;

        public InstalledFiles() throws IOException {
            this.mode = 2;
            this.indexFileName = FileUtils.createTempFile();
            FileOutputStream fileOutputStream = new FileOutputStream(this.indexFileName);
            this.out = new DataOutputStream(fileOutputStream);
        }

        public InstalledFiles(URL uRL) throws IOException {
            this.mode = 1;
            this.in = new DataInputStream(uRL.openStream());
        }

        public void add(String string, long l) throws IOException {
            if (this.mode != 2) {
                throw new Error();
            }
            this.out.writeByte(0);
            this.out.writeUTF(string);
            this.out.writeLong(l);
        }

        public void close() throws IOException {
            if (this.mode == 2) {
                this.out.writeByte(-128);
                this.out.flush();
                this.out.close();
            } else if (this.mode == 1) {
                this.in.close();
            } else {
                throw new Error();
            }
        }

        public String getIndexFileName() {
            return this.indexFileName;
        }

        public InstalledFile read() throws IOException {
            if (this.mode != 1) {
                throw new Error();
            }
            if (this.in.readByte() == -128) {
                return null;
            }
            String string = this.in.readUTF();
            long l = this.in.readLong();
            return new InstalledFile(string, l);
        }
    }

    protected class InstalledFile {
        public final String fileName;
        public final long lastModified;

        public InstalledFile(String string, long l) {
            this.fileName = string;
            this.lastModified = l;
        }
    }

    private class NativeAsciiInputStream
    extends InputStream {
        private byte[] lineSeparatorBytes;
        boolean processingLineSeparator;
        int lineSeparatorIndex;
        int currReadIndex;
        int readBufferSize;
        private InputStream in;
        private int lineDelimiter;
        private byte[] readBuffer = new byte[5120];

        NativeAsciiInputStream(InputStream inputStream, int n) {
            this.lineSeparatorBytes = System.getProperty("line.separator").getBytes();
            if (this.lineSeparatorBytes == null || this.lineSeparatorBytes.length == 0) {
                this.lineSeparatorBytes = new String("\r\n").getBytes();
            }
            this.in = inputStream;
            this.lineDelimiter = n;
            this.lineSeparatorIndex = 0;
            this.processingLineSeparator = false;
            this.currReadIndex = -1;
            this.readBufferSize = -1;
        }

        public void close() throws IOException {
            this.in.close();
            super.close();
        }

        private byte getNextLineSeparatorByte() {
            byte by = this.lineSeparatorBytes[this.lineSeparatorIndex];
            ++this.lineSeparatorIndex;
            if (this.lineSeparatorIndex >= this.lineSeparatorBytes.length) {
                ++this.currReadIndex;
                this.processingLineSeparator = false;
                this.lineSeparatorIndex = 0;
            }
            return by;
        }

        private boolean isByteAvailable() throws IOException {
            if (this.processingLineSeparator) {
                return true;
            }
            if (this.currReadIndex < 0 || this.currReadIndex >= this.readBufferSize) {
                this.readBufferSize = this.in.read(this.readBuffer);
                this.currReadIndex = 0;
            }
            return this.readBufferSize != -1 && this.currReadIndex >= 0 && this.currReadIndex < this.readBufferSize;
        }

        public int read() throws IOException {
            if (this.isByteAvailable()) {
                return this.translateByte();
            }
            return -1;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (!this.isByteAvailable()) {
                return -1;
            }
            int n3 = 0;
            while (n3 < n2 && this.isByteAvailable()) {
                byArray[n3] = this.translateByte();
                ++n3;
            }
            return n3;
        }

        private byte translateByte() throws IOException {
            boolean bl = false;
            boolean bl2 = false;
            int n = -1;
            while (!bl2 && this.isByteAvailable()) {
                if (this.processingLineSeparator) {
                    n = this.getNextLineSeparatorByte();
                    bl2 = true;
                    continue;
                }
                if (this.lineDelimiter == 0 && this.readBuffer[this.currReadIndex] == 10) {
                    this.processingLineSeparator = true;
                    n = this.getNextLineSeparatorByte();
                    bl2 = true;
                    continue;
                }
                if (this.lineDelimiter == 1 && this.readBuffer[this.currReadIndex] == 13) {
                    if (bl) {
                        n = 13;
                        bl2 = true;
                        continue;
                    }
                    bl = true;
                    ++this.currReadIndex;
                    continue;
                }
                if (this.lineDelimiter == 1 && this.readBuffer[this.currReadIndex] == 10 && bl) {
                    this.processingLineSeparator = true;
                    n = this.getNextLineSeparatorByte();
                    bl2 = true;
                    continue;
                }
                if (bl) {
                    n = 13;
                } else {
                    n = this.readBuffer[this.currReadIndex];
                    ++this.currReadIndex;
                }
                bl2 = true;
            }
            return (byte)n;
        }
    }
}

