/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.actions;

import com.installshield.product.ProductAction;
import com.installshield.product.ProductActionSupport;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.product.ProductException;
import com.installshield.product.RequiredBytesTable;
import com.installshield.util.FileUtils;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class MoveFile
extends ProductAction {
    private String source = "";
    private String target = "";
    private boolean removeOnUninstall = true;
    private boolean enableOnReinstall = true;
    private String movedFile = "";

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.source.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Source property must be specified");
        }
        if (this.target.equals("")) {
            productBuilderSupport.logEvent(this, "err", "Target property must be specified");
        }
        productBuilderSupport.putRequiredService("fileService");
    }

    public boolean getEnableOnReinstall() {
        return this.enableOnReinstall;
    }

    public int getEstimatedTimeToInstall() {
        int n = 0;
        try {
            FileService fileService = (FileService)this.getService("fileService");
            String string = fileService.createFileName(this.getParentComponent().getAbsoluteInstallLocation(), this.resolveString(this.source));
            if (fileService.isFile(string)) {
                n = fileService.getFileSize(string);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", serviceException);
        }
        return Math.max(1, Math.round((float)n * 2.5E-7f));
    }

    public int getEstimatedTimeToReplace() {
        return this.getEstimatedTimeToInstall();
    }

    public String getMovedFile() {
        return this.movedFile;
    }

    public boolean getRemoveOnUninstall() {
        return this.removeOnUninstall;
    }

    public RequiredBytesTable getRequiredBytes() {
        RequiredBytesTable requiredBytesTable = new RequiredBytesTable();
        try {
            String string;
            FileService fileService = (FileService)this.getService("fileService");
            String string2 = this.getParentComponent().getAbsoluteInstallLocation();
            String string3 = fileService.createFileName(string2, this.resolveString(this.source));
            String string4 = fileService.createFileName(string2, this.resolveString(this.target));
            if (!fileService.isFile(string3)) {
                return requiredBytesTable;
            }
            if (fileService.isFile(string4)) {
                return requiredBytesTable;
            }
            String string5 = fileService.getPartitionName(string3, fileService.getPartitionNames());
            if (string5.equals(string = fileService.getPartitionName(string4, fileService.getPartitionNames()))) {
                return requiredBytesTable;
            }
            long l = fileService.getFileSize(string3);
            if (fileService.isDirectory(string4)) {
                requiredBytesTable.addBytes(string4, l);
            } else {
                requiredBytesTable.addBytes(fileService.getParent(string4), l);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "wrn", "Unable to calculate Required Bytes: " + serviceException);
        }
        return requiredBytesTable;
    }

    public RequiredBytesTable getRequiredBytesForReplace() {
        return this.getRequiredBytes();
    }

    public String getSource() {
        return this.source;
    }

    public String getTarget() {
        return this.target;
    }

    public void install(ProductActionSupport productActionSupport) throws ProductException {
        productActionSupport.getOperationState().setStatusDetail(this.resolveString("$L(com.installshield.product.i18n.ProductResources, copyingFiles)"));
        try {
            FileService fileService = (FileService)this.getService("fileService");
            String string = this.getParentComponent().getAbsoluteInstallLocation();
            String string2 = fileService.createFileName(string, this.resolveString(this.source));
            String string3 = fileService.createFileName(string, this.resolveString(this.target));
            if (!fileService.isFile(string2)) {
                throw new ProductException(601, "err", String.valueOf(string2) + " is not an existing file");
            }
            if (fileService.isFile(string3)) {
                throw new ProductException(601, "err", "Can not copy " + string2 + " since " + string3 + " already exists");
            }
            productActionSupport.getOperationState().updatePercentComplete(this.getEstimatedTimeToInstall(), 1L, 2L);
            if (fileService.isDirectory(string3)) {
                String string4 = FileUtils.getName(string2);
                string3 = fileService.createFileName(string3, string4);
                fileService.moveFile(string2, string3, true);
            } else {
                String string5 = fileService.getParent(string3);
                if (fileService.isDirectory(string5)) {
                    fileService.moveFile(string2, string3, true);
                } else {
                    throw new ProductException(601, "err", "Can not copy " + string2 + " since " + string5 + " does not exist");
                }
            }
            productActionSupport.getOperationState().updatePercentComplete(this.getEstimatedTimeToInstall(), 1L, 2L);
            productActionSupport.getOperationState().setStatusDetail("");
            this.movedFile = string3;
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, "err", "Can not move file with FileService : " + serviceException);
        }
    }

    public void setEnableOnReinstall(boolean bl) {
        this.enableOnReinstall = bl;
    }

    public void setMovedFile(String string) {
        this.movedFile = string;
    }

    public void setRemoveOnUninstall(boolean bl) {
        this.removeOnUninstall = bl;
    }

    public void setSource(String string) {
        this.source = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void uninstall(ProductActionSupport productActionSupport) throws ProductException {
        if (!this.removeOnUninstall) {
            return;
        }
        try {
            FileService fileService = (FileService)this.getService("fileService");
            if (fileService.fileExists(this.movedFile)) {
                fileService.deleteFile(this.movedFile);
            }
        }
        catch (ServiceException serviceException) {
            throw new ProductException(601, "err", "Could not delete " + this.movedFile + " : " + serviceException);
        }
    }
}

