/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.conditions;

import com.installshield.product.ProductBeanCondition;
import com.installshield.product.ProductBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizard.service.file.FileService;

public class FileExistsProductBeanCondition
extends ProductBeanCondition {
    private String[] pathList = new String[0];

    public FileExistsProductBeanCondition() {
        this.setImmutable(true);
    }

    public void build(ProductBuilderSupport productBuilderSupport) {
        if (this.pathList.length == 0) {
            productBuilderSupport.logEvent(this, "err", "No paths specified");
        }
        productBuilderSupport.putRequiredService("fileService");
    }

    public String defaultName() {
        return "FileExistsProductBeanCondition";
    }

    public String describe() {
        String string = "Files must ";
        if (this.getEvaluate() == 2) {
            string = String.valueOf(string) + "not ";
        }
        string = String.valueOf(string) + "exist";
        return string;
    }

    public boolean evaluateTrueCondition() {
        try {
            FileService fileService = (FileService)this.getProductBean().getServices().getService("fileService");
            int n = 0;
            while (n < this.pathList.length) {
                String string = this.getProductBean().getServices().resolveString(this.pathList[n]);
                if (fileService.fileExists(string)) {
                    return true;
                }
                ++n;
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
        return false;
    }

    public String[] getPathList() {
        return this.pathList;
    }

    public void setPathList(String[] stringArray) {
        this.pathList = stringArray;
    }
}

