/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectReference;
import java.util.Vector;

public class InstallStatusProductTreeIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;
    private Vector installStatusList;
    private boolean testEqual = true;

    public InstallStatusProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator, int n) {
        this(filteredProductTreeIterator, n, true);
    }

    public InstallStatusProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator, int n, boolean bl) {
        this(filteredProductTreeIterator, new int[]{n}, bl);
    }

    public InstallStatusProductTreeIterator(FilteredProductTreeIterator filteredProductTreeIterator, int[] nArray, boolean bl) {
        this.testEqual = bl;
        this.iter = filteredProductTreeIterator;
        this.installStatusList = new Vector();
        int n = 0;
        while (n < nArray.length) {
            Integer n2 = new Integer(nArray[n]);
            if (!this.installStatusList.contains(n2)) {
                this.installStatusList.addElement(n2);
            }
            ++n;
        }
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        SoftwareObject softwareObject = null;
        SoftwareObjectReference softwareObjectReference = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
        } else if (productBean instanceof SoftwareObjectReference) {
            softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
        }
        if (softwareObject != null) {
            if (this.testEqual) {
                return this.installStatusList.contains(new Integer(softwareObject.getInstallStatus()));
            }
            return this.installStatusList.contains(new Integer(softwareObject.getInstallStatus())) ^ true;
        }
        return true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        return this.iter.getNext(productBean);
    }

    public ProductBean getPrevious(ProductBean productBean) {
        return this.iter.getPrevious(productBean);
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

