/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.iterators;

import com.installshield.product.FilteredProductTreeIterator;
import com.installshield.product.ProductBean;
import com.installshield.product.ProductBeanFilter;
import com.installshield.product.SoftwareObject;
import com.installshield.product.SoftwareObjectKey;
import com.installshield.product.SoftwareObjectReference;
import com.installshield.product.service.registry.RegistryService;
import com.installshield.wizard.service.ServiceException;
import java.util.Vector;

public class PubliclySharedParentIterator
implements FilteredProductTreeIterator,
ProductBeanFilter {
    private FilteredProductTreeIterator iter;
    private RegistryService regService;
    private Vector publiclyShared = new Vector();

    public PubliclySharedParentIterator(FilteredProductTreeIterator filteredProductTreeIterator, RegistryService registryService) {
        this.iter = filteredProductTreeIterator;
        this.regService = registryService;
        filteredProductTreeIterator.addFilter(this);
    }

    public boolean accept(ProductBean productBean) {
        boolean bl = false;
        ProductBean productBean2 = productBean.getProductTree().getParent(productBean);
        SoftwareObjectKey softwareObjectKey = null;
        if (productBean2 instanceof SoftwareObject) {
            softwareObjectKey = ((SoftwareObject)((Object)productBean2)).getKey();
        } else if (productBean2 instanceof SoftwareObjectReference) {
            softwareObjectKey = ((SoftwareObjectReference)productBean2).getKey();
        }
        if (softwareObjectKey != null && this.publiclyShared.contains(softwareObjectKey)) {
            bl = true;
        }
        return bl ^ true;
    }

    public void addFilter(ProductBeanFilter productBeanFilter) {
        this.iter.addFilter(productBeanFilter);
    }

    public ProductBean begin() {
        return this.iter.begin();
    }

    private void checkForPubliclyShared(ProductBean productBean) {
        SoftwareObject softwareObject = null;
        SoftwareObject softwareObject2 = null;
        if (productBean instanceof SoftwareObject) {
            softwareObject = (SoftwareObject)((Object)productBean);
        } else if (productBean instanceof SoftwareObjectReference) {
            SoftwareObjectReference softwareObjectReference = (SoftwareObjectReference)productBean;
            softwareObject = productBean.getProductTree().resolveKey(softwareObjectReference.getKey());
        }
        if (softwareObject != null && softwareObject.isPubliclyShareable()) {
            try {
                softwareObject2 = this.regService.getSoftwareObject(softwareObject.getKey());
            }
            catch (ServiceException serviceException) {
                softwareObject2 = null;
            }
            if (softwareObject2 != null && !this.publiclyShared.contains(softwareObject.getKey())) {
                this.publiclyShared.addElement(softwareObject.getKey());
            }
        }
    }

    public ProductBean end() {
        return this.iter.end();
    }

    public ProductBean getNext(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getNext(productBean);
        this.checkForPubliclyShared(productBean2);
        return productBean2;
    }

    public ProductBean getPrevious(ProductBean productBean) {
        ProductBean productBean2 = this.iter.getPrevious(productBean);
        this.checkForPubliclyShared(productBean2);
        return productBean2;
    }

    public void removeFilter(ProductBeanFilter productBeanFilter) {
        this.iter.removeFilter(productBeanFilter);
    }
}

