/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.service.product.ProductService;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.UserInputRequest;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.service.ServiceException;
import com.installshield.wizardx.panels.TextDisplayPanel;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class InstallCheckPanel
extends TextDisplayPanel {
    public static final int EXECUTE_ONLY_CHECK_NAMES = 1;
    public static final int EXECUTE_ALL_BUT_CHECK_NAMES = 2;
    public static final int DISABLE_NEXT = 1;
    public static final int CONTINUE = 2;
    public static final int CONTINUE_WITH_OVERRIDE = 3;
    private int operation = 1;
    private int onFailure = 1;
    private String stopMessage = "$L(com.installshield.product.i18n.ProductResources, ProductCheckPanel.defaultStopMessage)";
    private String overrideMessage = "$L(com.installshield.product.i18n.ProductResources, ProductCheckPanel.defaultOverrideMessage)";
    private static final String YES = "$L(com.installshield.wizard.i18n.WizardResources, yesWithMn)";
    private static final String NO = "$L(com.installshield.wizard.i18n.WizardResources, noWithMn)";
    private String[] checkNames = new String[]{"patch", "patchtarget", "update", "diskspace", "dependencies"};
    private boolean canContinue = true;
    private String[] failedCheckNames = new String[0];

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        super.build(wizardBuilderSupport);
        wizardBuilderSupport.putRequiredService("productService");
        try {
            wizardBuilderSupport.putResourceBundles("com.installshield.product.i18n.ProductResources");
        }
        catch (IOException iOException) {
            wizardBuilderSupport.logEvent(this, "err", iOException);
        }
    }

    public boolean entered(WizardBeanEvent wizardBeanEvent) {
        wizardBeanEvent.getUserInterface().setStopped(this.onFailure == 1 && !this.canContinue);
        return true;
    }

    public void execute(WizardBeanEvent wizardBeanEvent) {
        try {
            boolean bl;
            Properties properties = this.executeChecks("text");
            String string = (String)((Hashtable)properties).get("summary.error.count");
            String string2 = (String)((Hashtable)properties).get("summary.warning.count");
            boolean bl2 = string != null && !string.equals("0");
            boolean bl3 = bl = string2 != null && !string2.equals("0");
            if (bl2) {
                this.logEvent(this, "err", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "ProductCheckPanel.defaultCancelWizardMessage"));
                this.getWizard().exit(2003);
            }
            if (bl) {
                this.logEvent(this, "wrn", LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "ProductCheckPanel.defaultCancelWizardMessage"));
                this.getWizard().exit(2003);
            }
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
        }
    }

    private Properties executeChecks(String string) throws ServiceException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (this.checkNames != null && n < this.checkNames.length) {
            hashtable.put(this.resolveString(this.checkNames[n]), "");
            ++n;
        }
        ProductService productService = (ProductService)this.getService("productService");
        String[] stringArray = productService.getInstallCheckNames("/product.xml");
        Vector<String> vector = new Vector<String>();
        boolean bl = this.operation == 1;
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (bl && hashtable.containsKey(stringArray[n2]) || !bl && !hashtable.containsKey(stringArray[n2])) {
                vector.addElement(stringArray[n2]);
            }
            ++n2;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        Properties properties = productService.executeChecks("/product.xml", (String[])objectArray, string);
        this.canContinue = true;
        Vector<Object> vector2 = new Vector<Object>();
        int n3 = 0;
        while (n3 < objectArray.length) {
            Integer n4 = (Integer)((Hashtable)properties).get(String.valueOf(objectArray[n3]) + "." + "passed");
            if (n4 != null && n4 == 2) {
                vector2.addElement(objectArray[n3]);
                this.canContinue = false;
            }
            ++n3;
        }
        if (this.canContinue) {
            this.failedCheckNames = new String[0];
        } else {
            this.failedCheckNames = new String[vector2.size()];
            vector2.copyInto(this.failedCheckNames);
        }
        return properties;
    }

    public String[] getCheckNames() {
        return this.checkNames;
    }

    public int getOnFailure() {
        return this.onFailure;
    }

    public int getOperation() {
        return this.operation;
    }

    public String getOverrideMessage() {
        return this.overrideMessage;
    }

    public String getStopMessage() {
        return this.stopMessage;
    }

    public boolean queryEnter(WizardBeanEvent wizardBeanEvent) {
        super.queryEnter(wizardBeanEvent);
        boolean bl = false;
        try {
            Properties properties = this.executeChecks("html");
            String string = (String)((Hashtable)properties).get("summary.error.count");
            String string2 = (String)((Hashtable)properties).get("summary.warning.count");
            bl = string != null && !string.equals("0") && string2 != null && !string2.equals("0");
            this.setText((String)((Hashtable)properties).get("summary.msg"));
        }
        catch (ServiceException serviceException) {
            this.logEvent(this, "err", serviceException);
            this.canContinue = false;
        }
        if (this.canContinue && bl) {
            return true;
        }
        return this.canContinue ^ true;
    }

    public boolean queryExit(WizardBeanEvent wizardBeanEvent) {
        block4: {
            if (this.canContinue) break block4;
            try {
                if (this.onFailure == 2) {
                    wizardBeanEvent.getUserInterface().displayUserMessage(this.resolveString(this.getWizard().getTitle()), this.resolveString(this.stopMessage), 1);
                    break block4;
                }
                if (this.onFailure == 3) {
                    UserInputRequest userInputRequest = new UserInputRequest(this.resolveString(this.getWizard().getTitle()), this.resolveString(this.overrideMessage), new Object[]{this.resolveString(YES), this.resolveString(NO)}, this.resolveString(NO));
                    String string = (String)wizardBeanEvent.getUserInterface().userInputRequested(userInputRequest).getResponse();
                    if (!string.equals(this.resolveString(YES))) break block4;
                    this.canContinue = true;
                    ProductService productService = (ProductService)this.getService("productService");
                    productService.overrideChecks("/product.xml", this.failedCheckNames);
                    break block4;
                }
                this.canContinue = true;
                ProductService productService = (ProductService)this.getService("productService");
                productService.overrideChecks("/product.xml", this.failedCheckNames);
            }
            catch (ServiceException serviceException) {
                this.logEvent(this, "err", serviceException);
            }
        }
        return this.canContinue;
    }

    public void setCheckNames(String[] stringArray) {
        this.checkNames = stringArray;
    }

    public void setOnFailure(int n) {
        this.onFailure = n;
    }

    public void setOperation(int n) {
        this.operation = n;
    }

    public void setOverrideMessage(String string) {
        this.overrideMessage = string;
    }

    public void setStopMessage(String string) {
        this.stopMessage = string;
    }
}

