/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.product.wizardbeans;

import com.installshield.product.wizardbeans.SetupType;
import com.installshield.product.wizardbeans.SetupTypePanel;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.swing.DefaultSwingWizardPanelImpl;
import com.installshield.wizard.swing.SwingText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.MemoryImageSource;
import java.util.Hashtable;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

public class SetupTypePanelSwingImpl
extends DefaultSwingWizardPanelImpl
implements ItemListener,
LayoutManager {
    private JComponent view = null;
    private JScrollPane scroll = null;
    private Hashtable setupTypesPerCheckbox = new Hashtable();

    public void addLayoutComponent(String string, Component component) {
    }

    public void entering(WizardBeanEvent wizardBeanEvent) {
        super.entering(wizardBeanEvent);
        this.scroll.getHorizontalScrollBar().setValue(0);
        this.scroll.getVerticalScrollBar().setValue(0);
    }

    private SetupTypePanel getSTP() {
        return (SetupTypePanel)this.getPanel();
    }

    public void initialize(WizardBeanEvent wizardBeanEvent) {
        super.initialize(wizardBeanEvent);
        this.getContentPane().setLayout(new BorderLayout());
        this.scroll = new JScrollPane();
        this.getContentPane().add(this.scroll);
        this.view = new JPanel();
        this.scroll.setViewportView(this.view);
        this.scroll.getVerticalScrollBar().setUnitIncrement(20);
        this.view.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
        this.view.setLayout(this);
        SetupType[] setupTypeArray = this.getSTP().getSetupTypes();
        SetupType setupType = this.getSTP().getSelectedSetupType();
        ButtonGroup buttonGroup = new ButtonGroup();
        this.setupTypesPerCheckbox.clear();
        int n = 0;
        while (n < setupTypeArray.length) {
            MnemonicString mnemonicString = new MnemonicString(this.resolveString(setupTypeArray[n].getDisplayName()));
            JRadioButton jRadioButton = new JRadioButton(mnemonicString.toString());
            this.view.add(jRadioButton);
            buttonGroup.add(jRadioButton);
            jRadioButton.getAccessibleContext().setAccessibleName(String.valueOf(mnemonicString.toString()) + ". " + this.resolveString(setupTypeArray[n].getDescription()));
            jRadioButton.setSelected(setupType != null && setupType.equals(setupTypeArray[n]));
            jRadioButton.addItemListener(this);
            this.setupTypesPerCheckbox.put(jRadioButton, setupTypeArray[n]);
            if (mnemonicString.isMnemonicSpecified()) {
                jRadioButton.setMnemonic(mnemonicString.getMnemonicChar());
            }
            Image image = null;
            image = setupTypeArray[n].getId().equals("typical") ? Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(32, 32, SetupTypePanel.typicalImage, 0, 32)) : Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(32, 32, SetupTypePanel.customImage, 0, 32));
            JLabel jLabel = new JLabel(new ImageIcon(image));
            this.view.add(jLabel);
            jLabel.getAccessibleContext().setAccessibleName(mnemonicString.toString());
            jLabel.getAccessibleContext().setAccessibleDescription(String.valueOf(mnemonicString.toString()) + " " + LocalizedStringResolver.resolve("com.installshield.product.i18n.ProductResources", "SetupTypePanelSwingImpl.SetupTypeImage"));
            SwingText swingText = new SwingText(this.resolveString(setupTypeArray[n].getDescription()));
            this.view.add(swingText);
            ++n;
        }
        this.registerFocusListener(this, this.view);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        SetupType setupType = (SetupType)this.setupTypesPerCheckbox.get(itemEvent.getSource());
        this.getSTP().setSelectedSetupTypeId(setupType.getId());
    }

    public void layoutContainer(Container container) {
        this.layoutView(container, true);
    }

    private Dimension layoutView(Container container, boolean bl) {
        int n = 4;
        int n2 = 6;
        int n3 = 6;
        int n4 = 6;
        int n5 = 10;
        int n6 = 6;
        int n7 = 6;
        int n8 = 4;
        int n9 = 6;
        int n10 = 0;
        int n11 = 0;
        while (n11 < container.getComponentCount()) {
            Component component = container.getComponent(n11);
            if (n11 % 3 == 0) {
                n9 = 6;
                if (n11 > 0) {
                    n8 += 6;
                }
                if (bl) {
                    component.setLocation(6, n8);
                }
                component.setSize(component.getPreferredSize());
                n8 += component.getSize().height;
            } else if (n11 % 3 == 1) {
                n9 += 10;
                if (bl) {
                    component.setLocation(n9, n8);
                }
                component.setSize(component.getPreferredSize());
                n9 += component.getSize().width;
                n10 = component.getSize().height;
            } else if (n11 % 3 == 2) {
                n9 += 6;
                if (bl) {
                    component.setLocation(n9, n8);
                }
                int n12 = this.scroll.getViewport().getSize().width - n9 - 6;
                component.setSize(n12, component.getPreferredSize().height);
                if (component.getSize().height != component.getPreferredSize().height) {
                    component.setSize(n12, component.getPreferredSize().height);
                }
                n8 += Math.max(n10, component.getSize().height);
            }
            ++n11;
        }
        return new Dimension(this.scroll.getViewport().getSize().width, n8 += 6);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.layoutView(container, false);
    }

    public void removeLayoutComponent(Component component) {
    }
}

