/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.qjml;

import com.installshield.qjml.CloneOutputStream;
import com.installshield.qjml.QJMLException;
import com.installshield.util.MD5;
import com.jxml.quick.QContext;
import com.jxml.quick.QConvert;
import com.jxml.quick.QDoc;
import com.jxml.quick.QPE;
import com.jxml.quick.Quick;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Hashtable;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;

public class QJML {
    private static String parserClass = null;
    private static Parser parser = null;
    private static Hashtable schemaURLs = new Hashtable();
    private static Hashtable schemaDocs = new Hashtable();
    public static final String QJML_ENCODING = "UTF8";
    private static CloneOutputStream bytesOut = new CloneOutputStream(10240);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object clone(Object object, Class clazz) throws IOException, QJMLException {
        try {
            CloneOutputStream cloneOutputStream = bytesOut;
            synchronized (cloneOutputStream) {
                bytesOut.reset();
                bytesOut.write(QJML.expressBytes(object, clazz));
                QDoc qDoc = QJML.getSchemaDoc(clazz);
                QContext qContext = Quick.createContext(qDoc);
                QConvert qConvert = new QConvert(qContext);
                Parser parser = QJML.parser;
                synchronized (parser) {
                    Parser parser2 = QJML.getParser();
                    parser2.setDocumentHandler(qConvert);
                    InputSource inputSource = new InputSource(bytesOut.createInputStream());
                    inputSource.setEncoding(QJML_ENCODING);
                    parser2.parse(inputSource);
                    QDoc qDoc2 = qContext.doc;
                    return Quick.getRoot(qDoc2);
                }
            }
        }
        catch (SAXException sAXException) {
            if (System.getProperty("is.debug") == null) throw new QJMLException(3000, sAXException.getMessage());
            sAXException.printStackTrace();
            throw new QJMLException(3000, sAXException.getMessage());
        }
    }

    public static String createDigest(InputStream inputStream, Class clazz, byte[] byArray) throws IOException {
        int n;
        MD5 mD5 = new MD5();
        byte[] byArray2 = new byte[5120];
        while ((n = inputStream.read(byArray2)) != -1) {
            mD5.write(byArray2, 0, n);
        }
        mD5.write(byArray);
        return MD5.toHex(mD5.toHash());
    }

    public static String createDigest(Object object, Class clazz, byte[] byArray) throws IOException {
        MD5 mD5 = new MD5();
        mD5.write(QJML.expressBytes(object, clazz));
        mD5.write(byArray);
        return MD5.toHex(mD5.toHash());
    }

    public static String createDigest(URL uRL, Class clazz, byte[] byArray) throws IOException {
        InputStream inputStream = uRL.openStream();
        String string = QJML.createDigest(inputStream, clazz, byArray);
        inputStream.close();
        return string;
    }

    public static String express(Object object, Class clazz) throws IOException, QJMLException {
        try {
            QDoc qDoc = QJML.getSchemaDoc(clazz);
            QContext qContext = Quick.createContext(qDoc);
            QDoc qDoc2 = Quick.createDoc(object);
            return Quick.express(qDoc2, qContext);
        }
        catch (QPE qPE) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + qPE.getLineNumber() + "/" + qPE.getColumnNumber());
                qPE.printStackTrace();
            }
            throw new QJMLException(3002, qPE.getMessage());
        }
        catch (SAXException sAXException) {
            if (System.getProperty("is.debug") != null) {
                sAXException.printStackTrace();
            }
            throw new QJMLException(3000, sAXException.getMessage());
        }
    }

    private static byte[] express(Object object, Class clazz, String string) throws IOException, QJMLException {
        try {
            QDoc qDoc = QJML.getSchemaDoc(clazz);
            QContext qContext = Quick.createContext(qDoc);
            QDoc qDoc2 = Quick.createDoc(object);
            String string2 = Quick.express(qDoc2, qContext);
            return string2.getBytes(string);
        }
        catch (QPE qPE) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + qPE.getLineNumber() + "/" + qPE.getColumnNumber());
                qPE.printStackTrace();
            }
            throw new QJMLException(3002, qPE.getMessage());
        }
        catch (SAXException sAXException) {
            if (System.getProperty("is.debug") != null) {
                sAXException.printStackTrace();
            }
            throw new QJMLException(3000, sAXException.getMessage());
        }
    }

    public static byte[] expressBytes(Object object, Class clazz) throws IOException, QJMLException {
        return QJML.express(object, clazz, QJML_ENCODING);
    }

    public static String getClassSchema(Class clazz) {
        String string;
        block3: {
            string = (String)schemaURLs.get(clazz);
            if (string != null) break block3;
            String string2 = "/" + clazz.getName().replace('.', '/') + ".qjml";
            try {
                URL uRL = clazz.getResource(string2);
                if (uRL != null) {
                    string = uRL.toExternalForm();
                }
            }
            catch (Exception exception) {
                if (System.getProperty("is.debug") == null) break block3;
                exception.printStackTrace();
            }
        }
        return string;
    }

    public static Parser getParser() throws QJMLException {
        if (parser == null) {
            try {
                parser = parserClass != null ? ParserFactory.makeParser(parserClass) : ParserFactory.makeParser();
            }
            catch (Exception exception) {
                try {
                    parser = ParserFactory.makeParser("com.ibm.xml.parsers.SAXParser");
                }
                catch (Exception exception2) {
                    throw new QJMLException(3001, (Object)exception);
                }
            }
        }
        return parser;
    }

    public static String getParserClass() {
        return parserClass;
    }

    public static QDoc getSchemaDoc(Class clazz) throws QJMLException, IOException, SAXException {
        QDoc qDoc = (QDoc)schemaDocs.get(clazz);
        if (qDoc == null) {
            Parser parser = QJML.getParser();
            String string = QJML.getClassSchema(clazz);
            if (string == null) {
                throw new QJMLException(1002, clazz);
            }
            qDoc = Quick.parseSchema(parser, string);
            schemaDocs.put(clazz, qDoc);
        }
        return qDoc;
    }

    public static void main(String[] stringArray) {
        block3: {
            if (stringArray.length != 3) {
                System.err.println("use: QJML <factory class> <QJML type> <output file>");
                System.exit(-1);
            }
            try {
                Object obj = Class.forName(stringArray[0]).newInstance();
                Class<?> clazz = Class.forName(stringArray[1]);
                QJML.write(obj, clazz, stringArray[2]);
            }
            catch (Throwable throwable) {
                System.err.println("The following error occurred: " + throwable);
                if (System.getProperty("is.debug") == null) break block3;
                throwable.printStackTrace();
            }
        }
    }

    public static Object read(InputStream inputStream, Class clazz) throws IOException, QJMLException {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setEncoding(QJML_ENCODING);
        return QJML.read(inputSource, clazz);
    }

    public static Object read(URL uRL, Class clazz) throws IOException, QJMLException {
        InputSource inputSource = new InputSource(uRL.openStream());
        inputSource.setEncoding(QJML_ENCODING);
        return QJML.read(inputSource, clazz);
    }

    private static Object read(InputSource inputSource, Class clazz) throws IOException, QJMLException {
        try {
            QDoc qDoc = QJML.getSchemaDoc(clazz);
            QContext qContext = Quick.createContext(qDoc);
            QDoc qDoc2 = Quick.parse(QJML.getParser(), qContext, inputSource);
            return Quick.getRoot(qDoc2);
        }
        catch (QPE qPE) {
            if (System.getProperty("is.debug") != null) {
                System.err.println("line/col: " + qPE.getLineNumber() + "/" + qPE.getColumnNumber());
                qPE.printStackTrace();
            }
            throw new QJMLException(3002, qPE.getMessage());
        }
        catch (SAXException sAXException) {
            if (System.getProperty("is.debug") != null) {
                sAXException.printStackTrace();
            }
            throw new QJMLException(3000, sAXException.getMessage());
        }
    }

    public static void setClassSchema(Class clazz, String string) {
        if (string != null) {
            schemaURLs.put(clazz, string);
        } else {
            schemaURLs.remove(clazz);
        }
    }

    public static void setParserClass(String string) {
        parserClass = string;
    }

    public static void write(Object object, Class clazz, PrintWriter printWriter) throws IOException, QJMLException {
        String string = QJML.express(object, clazz);
        printWriter.write(string);
        printWriter.flush();
    }

    public static void write(Object object, Class clazz, String string) throws IOException, QJMLException {
        byte[] byArray = QJML.expressBytes(object, clazz);
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }
}

