/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.LockedFilesHandler;
import com.installshield.util.TempFileOwner;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class FileUtils {
    private static final boolean isFileSystemCaseSensitive;
    public static final String systemLF;
    private static Vector tempFiles;
    private static Vector tempFileOwners;
    private static final String isjeDirName = "ismp";
    private static int count;
    private static String curTempDirectory;
    private static LockedFilesHandler lockedFilesHandler;

    static {
        tempFiles = new Vector();
        tempFileOwners = new Vector();
        count = 1;
        curTempDirectory = null;
        lockedFilesHandler = null;
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows") || string.equals("OS/2")) {
            systemLF = "\r\n";
            isFileSystemCaseSensitive = false;
        } else if (string.equals("OS/400")) {
            systemLF = "\n";
            isFileSystemCaseSensitive = false;
        } else {
            systemLF = "\n";
            isFileSystemCaseSensitive = true;
        }
    }

    public static void addTempFile(String string) {
        if (!tempFiles.contains(string)) {
            tempFiles.addElement(string);
        }
    }

    public static void addTempFileOwner(TempFileOwner tempFileOwner) {
        tempFileOwners.addElement(tempFileOwner);
    }

    public static String appendSeparator(String string) {
        return FileUtils.appendSeparator(string, File.separator);
    }

    public static String appendSeparator(String string, String string2) {
        if (string.length() > 0 && !string.endsWith("/") && !string.endsWith(File.separator)) {
            return String.valueOf(string) + string2;
        }
        return string;
    }

    public static String canonizePath(String string) {
        String string2 = FileUtils.normalizeFileName(string);
        String string3 = String.valueOf(File.separator) + File.separator;
        int n = string2.lastIndexOf(string3);
        while (n != -1 && n != 0) {
            string2 = String.valueOf(string2.substring(0, n + 1)) + string2.substring(n + 2);
            n = string2.lastIndexOf(string3);
        }
        boolean bl = true;
        while (bl) {
            bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < string2.length()) {
                if (string2.charAt(n2) != File.separatorChar) {
                    stringBuffer.append(string2.charAt(n2));
                } else if (string2.length() != n2 + 1 && string2.charAt(n2 + 1) == '.') {
                    if (string2.length() == n2 + 2 || string2.charAt(n2 + 2) == File.separatorChar) {
                        ++n2;
                    } else if (string2.charAt(n2 + 2) == '.' && (string2.length() == n2 + 3 || string2.charAt(n2 + 3) == File.separatorChar)) {
                        String string4 = stringBuffer.toString();
                        String string5 = FileUtils.getParent(string4);
                        if (string5 == null) {
                            string5 = string4;
                        }
                        if (string5.endsWith(File.separator)) {
                            string5 = string5.substring(0, string5.length() - 1);
                        }
                        stringBuffer = new StringBuffer(string5);
                        n2 += 2;
                        bl = true;
                    } else {
                        stringBuffer.append(string2.charAt(n2));
                    }
                } else {
                    stringBuffer.append(string2.charAt(n2));
                }
                ++n2;
            }
            string2 = stringBuffer.toString();
        }
        if (string2.endsWith(File.separator)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static void clearTempFile(String string) {
        tempFiles.removeElement(string);
    }

    public static void clearTempFileOwners() {
        tempFileOwners.removeAllElements();
    }

    public static void clearTempFiles() {
        tempFiles.removeAllElements();
    }

    public static boolean compareBytes(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = 0;
        while (n < byArray.length) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public static boolean compareFileNames(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        if (isFileSystemCaseSensitive) {
            return string.equals(string2);
        }
        return string.equalsIgnoreCase(string2);
    }

    public static boolean comparePaths(String string, String string2) {
        if (string == null || string2 == null) {
            return false;
        }
        String string3 = FileUtils.canonizePath(string);
        String string4 = FileUtils.canonizePath(string2);
        if (!isFileSystemCaseSensitive) {
            return string3.equalsIgnoreCase(string4);
        }
        return string3.equals(string4);
    }

    public static int copy(int n, InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtils.copy(n, inputStream, outputStream, Integer.MAX_VALUE);
    }

    public static int copy(int n, InputStream inputStream, OutputStream outputStream, int n2) throws IOException {
        int n3 = 0;
        int n4 = 0;
        if (n2 > 0) {
            if (n > n2) {
                n = n2;
            }
            byte[] byArray = new byte[n];
            boolean bl = false;
            while (!bl && (n4 = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n4);
                int n5 = n2 - (n3 += n4);
                if (n5 <= 0) {
                    bl = true;
                    continue;
                }
                if (n5 >= n) continue;
                n = n5;
                byArray = new byte[n];
            }
        }
        return n3;
    }

    public static int copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        return FileUtils.copy(5120, inputStream, outputStream);
    }

    public static String[] createDirs(File file) throws IOException {
        Object object;
        Stack<File> stack = new Stack<File>();
        File file2 = file;
        while (file2 != null && !file2.exists()) {
            stack.push(file2);
            object = file2.getParent();
            File file3 = file2 = object != null ? new File((String)object) : null;
        }
        object = new Vector();
        while (!stack.isEmpty()) {
            file2 = (File)stack.pop();
            if (file2.exists()) continue;
            if (!file2.mkdir()) {
                throw new IOException("Could not create directory " + file2.getAbsolutePath());
            }
            ((Vector)object).addElement(file2.getAbsolutePath());
        }
        Object[] objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public static String createFileName(String string, String string2) {
        if (string == null) {
            string = "";
        }
        string = string.trim();
        if (string2 == null) {
            return FileUtils.normalizeFileName(string);
        }
        string2 = string2.trim();
        if (FileUtils.isAbsolute(string2 = FileUtils.normalizeFileName(string2))) {
            return string2;
        }
        if ((string = FileUtils.normalizeFileName(string)).endsWith(File.separator)) {
            return String.valueOf(string) + string2;
        }
        return String.valueOf(string) + File.separator + string2;
    }

    private static void createIsjeTempDir() {
        boolean bl = false;
        while (!bl) {
            String string = FileUtils.getIsjeTempDirName();
            File file = new File(string);
            if (!file.exists()) {
                file.mkdir();
                curTempDirectory = file.getAbsolutePath();
                if (!tempFiles.contains(curTempDirectory)) {
                    tempFiles.addElement(curTempDirectory);
                }
                bl = true;
                continue;
            }
            ++count;
        }
    }

    public static String createTempDir() throws IOException {
        File file;
        String string = FileUtils.getIsjeTempDir();
        while ((file = new File(string, FileUtils.createTempDirName())).exists()) {
        }
        String[] stringArray = FileUtils.createDirs(file);
        int n = 0;
        while (n < stringArray.length) {
            if (!tempFiles.contains(stringArray[n])) {
                tempFiles.addElement(stringArray[n]);
            }
            ++n;
        }
        String string2 = file.getAbsolutePath();
        return string2;
    }

    public static String createTempDirName() {
        return new Integer((int)(Math.random() * 1.0E7)).toString();
    }

    public static String createTempFile() throws IOException {
        File file;
        String string = FileUtils.getIsjeTempDir();
        while ((file = new File(string, FileUtils.createTempFileName())).exists()) {
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        fileOutputStream.close();
        String string2 = file.getAbsolutePath();
        tempFiles.addElement(string2);
        return string2;
    }

    public static String createTempFile(URL uRL) throws IOException {
        String string = FileUtils.createTempFile();
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        FileUtils.copy(inputStream, fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
        return string;
    }

    public static String createTempFile(URL uRL, String string) throws IOException {
        File file = new File(FileUtils.getIsjeTempDir(), string);
        if (file.exists()) {
            while ((file = new File(FileUtils.getIsjeTempDir(), FileUtils.createTempFileName())).exists()) {
            }
            if (!file.mkdirs()) {
                throw new IOException("could not create temp directory " + file.getAbsolutePath());
            }
            tempFiles.addElement(file.getAbsolutePath());
            file = new File(file, string);
        }
        tempFiles.addElement(file.getAbsolutePath());
        InputStream inputStream = uRL.openStream();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        FileUtils.copy(inputStream, fileOutputStream);
        inputStream.close();
        fileOutputStream.close();
        return file.getAbsolutePath();
    }

    public static String createTempFileName() {
        return String.valueOf((int)(Math.random() * 1.0E7)) + ".tmp";
    }

    public static synchronized byte[] decodeBytes(String string) throws IOException {
        byte[] byArray = new byte[string.length()];
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = (byte)string.charAt(n);
            ++n;
        }
        return FileUtils.decodeBytes(byArray);
    }

    public static synchronized byte[] decodeBytes(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("in cannot be null");
        }
        if (byArray.length < 8) {
            throw new IOException("bytes cannot be decoded");
        }
        byte[] byArray2 = new byte[6];
        byArray2[0] = (byte)((byArray[0] - 32 & 0x3F) << 2 | (byArray[1] - 32 & 0x3F) >> 4);
        byArray2[1] = (byte)((byArray[1] - 32 & 0x3F) << 4 | (byArray[2] - 32 & 0x3F) >> 2);
        byArray2[2] = (byte)((byArray[2] - 32 & 0x3F) << 6 | byArray[3] - 32 & 0x3F);
        byArray2[3] = (byte)((byArray[4] - 32 & 0x3F) << 2 | (byArray[5] - 32 & 0x3F) >> 4);
        int n = (0xFF & byArray2[0]) << 24 | (0xFF & byArray2[1]) << 16 | (0xFF & byArray2[2]) << 8 | 0xFF & byArray2[3];
        if (n < 0) {
            throw new IOException("bytes cannot be decoded");
        }
        byte[] byArray3 = new byte[n];
        int n2 = 8;
        int n3 = 0;
        while (n3 < n) {
            byte[] byArray4 = new byte[4];
            int n4 = 0;
            while (n4 < byArray4.length) {
                byArray4[n4] = n2 < byArray.length ? byArray[n2++] : (byte)0;
                ++n4;
            }
            byArray3[n3++] = (byte)((byArray4[0] - 32 & 0x3F) << 2 | (byArray4[1] - 32 & 0x3F) >> 4);
            if (n3 >= n) continue;
            byArray3[n3++] = (byte)((byArray4[1] - 32 & 0x3F) << 4 | (byArray4[2] - 32 & 0x3F) >> 2);
            if (n3 >= n) continue;
            byArray3[n3++] = (byte)((byArray4[2] - 32 & 0x3F) << 6 | byArray4[3] - 32 & 0x3F);
        }
        return byArray3;
    }

    public static boolean deleteTempFile(String string) {
        boolean bl = new File(string).delete();
        if (bl) {
            tempFiles.removeElement(string);
        }
        return bl;
    }

    public static String[] deleteTempFiles() {
        Object[] objectArray;
        Serializable serializable;
        int n;
        boolean bl;
        Enumeration enumeration = FileUtils.tempFileOwners();
        while (enumeration.hasMoreElements()) {
            ((TempFileOwner)enumeration.nextElement()).closeTempFile();
        }
        Vector<File> vector = new Vector<File>();
        Vector<String> vector2 = new Vector<String>();
        Enumeration enumeration2 = FileUtils.tempFiles();
        while (enumeration2.hasMoreElements()) {
            File file = new File((String)enumeration2.nextElement());
            if (file.isFile()) {
                if (file.delete()) continue;
                vector2.addElement(file.getAbsolutePath());
                continue;
            }
            if (!file.isDirectory()) continue;
            vector.addElement(file);
        }
        do {
            bl = false;
            n = 0;
            while (!bl && n < vector.size()) {
                serializable = (File)vector.elementAt(n);
                if (((File)serializable).delete()) {
                    vector.removeElementAt(n);
                    bl = true;
                }
                ++n;
            }
        } while (bl);
        n = 0;
        while (n < vector.size()) {
            vector2.addElement(((File)vector.elementAt(n)).getAbsolutePath());
            ++n;
        }
        serializable = new Vector();
        if (lockedFilesHandler != null) {
            objectArray = new String[vector2.size()];
            vector2.copyInto(objectArray);
            lockedFilesHandler.deleteLockedFiles((String[])objectArray);
        } else {
            int n2 = 0;
            while (n2 < vector2.size()) {
                String string = (String)vector2.elementAt(n2);
                ((Vector)serializable).addElement(string);
                ++n2;
            }
        }
        curTempDirectory = null;
        objectArray = new String[((Vector)serializable).size()];
        ((Vector)serializable).copyInto(objectArray);
        return objectArray;
    }

    public static String formatSizeAsBytes(long l) {
        String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "MB");
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "KB");
        double d = l;
        double d2 = 1048576.0;
        double d3 = 0.0;
        String string3 = null;
        if ((double)l > d2) {
            d3 = d / d2;
            string3 = string;
        } else {
            d3 = d / 1024.0;
            if (d3 < 1.0 && d3 > 0.0) {
                d3 = 1.0;
            }
            string3 = string2;
        }
        String string4 = "{0, number, #0.#} {1}";
        return MessageFormat.format(string4, new Double(d3), string3);
    }

    private static String getIsjeTempDir() {
        if (curTempDirectory == null) {
            FileUtils.createIsjeTempDir();
        }
        return curTempDirectory;
    }

    private static String getIsjeTempDirName() {
        String string = "";
        string = count < 10 ? "00" + count : (count >= 10 && count < 100 ? "0" + count : String.valueOf(count));
        return String.valueOf(FileUtils.appendSeparator(FileUtils.getTempDir())) + isjeDirName + string;
    }

    public static LockedFilesHandler getLockedFilesHandler() {
        return lockedFilesHandler;
    }

    public static String getName(String string) {
        return new File(FileUtils.normalizeFileName(string)).getName();
    }

    public static String getParent(String string) {
        String string2 = FileUtils.normalizeFileName(string);
        int n = string2.length();
        if (string2.endsWith(File.separator) && n > 1) {
            string2 = string2.substring(0, n - 1);
        }
        return new File(string2).getParent();
    }

    private static void getPartitionMatches(String string, String[] stringArray, Vector vector) {
        boolean bl = isFileSystemCaseSensitive;
        int n = 0;
        while (n < stringArray.length) {
            if (bl && string.startsWith(stringArray[n]) || !bl && string.toUpperCase().startsWith(stringArray[n].toUpperCase())) {
                vector.addElement(new Integer(n));
            }
            ++n;
        }
    }

    public static String getPartitionName(String string, String[] stringArray) {
        return FileUtils.getPartitionName(string, stringArray, "");
    }

    public static String getPartitionName(String string, String[] stringArray, String string2) {
        String string3;
        String string4;
        try {
            string4 = new File(string).getCanonicalPath();
        }
        catch (Exception exception) {
            if (System.getProperty("is.debug") != null) {
                System.out.println("FileUtils.getPartitionName(): Problem converting path to canonical form: " + string);
                exception.printStackTrace();
            }
            string4 = string;
        }
        String[] stringArray2 = (String[])stringArray.clone();
        int n = 0;
        while (n < stringArray2.length) {
            stringArray2[n] = FileUtils.appendSeparator(stringArray2[n]).replace(File.separatorChar, '/');
            ++n;
        }
        String string5 = string4.replace(File.separatorChar, '/');
        Vector vector = new Vector();
        FileUtils.getPartitionMatches(string5, stringArray2, vector);
        string5 = FileUtils.appendSeparator(string5).replace(File.separatorChar, '/');
        FileUtils.getPartitionMatches(string5, stringArray2, vector);
        if (vector.size() != 0 || string2.equals("")) {
            string3 = string4;
            int n2 = 0;
            int n3 = 0;
            while (n3 < vector.size()) {
                String string6 = stringArray[(Integer)vector.elementAt(n3)];
                if (string6.length() > n2) {
                    string3 = string6;
                    n2 = string6.length();
                }
                ++n3;
            }
        } else {
            string3 = string2;
        }
        return string3;
    }

    public static String getTempDir() {
        String string = System.getProperty("temp.dir");
        if (string == null) {
            string = System.getProperty("java.io.tmpdir");
        }
        if (string == null) {
            string = System.getProperty("user.home");
        }
        return string;
    }

    public static boolean isAbsolute(String string) {
        string = FileUtils.normalizeFileName(string);
        File file = new File(string);
        return string.startsWith(File.separator) || file.isAbsolute();
    }

    public static boolean isFileSystemCaseSensitive() {
        return isFileSystemCaseSensitive;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 0) {
            System.err.println("use: FileUtils [options]");
            System.err.println("\noptions:\n");
            System.err.println("   -temp : prints the temporary directory for the current JVM");
        } else {
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equals("-temp")) {
                    System.out.println(FileUtils.getTempDir());
                } else {
                    System.err.println("Unknown option: " + stringArray[n]);
                    System.exit(-1);
                }
                ++n;
            }
        }
    }

    public static String normalizeFileName(String string) {
        return FileUtils.normalizeFileName(string, File.separatorChar);
    }

    public static String normalizeFileName(String string, char c) {
        if (string == null) {
            throw new NullPointerException("fileName cannot be null");
        }
        return string.replace('/', c).replace('\\', c);
    }

    public static byte[] readFully(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        FileUtils.copy(inputStream, byteArrayOutputStream);
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public static void removeTempFileOwner(TempFileOwner tempFileOwner) {
        tempFileOwners.removeElement(tempFileOwner);
    }

    public static String removeTerminalSeparator(String string) {
        String string2 = string;
        while (string2.length() > 0 && (string2.endsWith("/") || string2.endsWith(File.separator))) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        return string2;
    }

    public static void setLockedFilesHandler(LockedFilesHandler lockedFilesHandler) {
        FileUtils.lockedFilesHandler = lockedFilesHandler;
    }

    public static Enumeration tempFileOwners() {
        return tempFileOwners.elements();
    }

    public static Enumeration tempFiles() {
        return tempFiles.elements();
    }
}

