/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.TextConverter;
import java.util.Hashtable;

public class HtmlToTextConverter
implements TextConverter {
    private Hashtable conversions = null;

    public void clearConversions() {
        if (this.conversions != null) {
            this.conversions.clear();
        }
    }

    public String convertText(String string) {
        this.verifyConversions();
        if (string.length() == 0) {
            return string;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        boolean bl = false;
        while (n < cArray.length) {
            String string2;
            boolean bl2 = false;
            if (Character.isWhitespace(cArray[n])) {
                if (!bl) {
                    if (stringBuffer.length() > 0) {
                        stringBuffer.append(' ');
                    }
                    bl = true;
                }
                ++n;
            } else if (cArray[n] == '<') {
                string2 = this.parseWord(cArray, n + 1, '>', false);
                if (string2 != null) {
                    if (this.conversions.containsKey(string2 = string2.toLowerCase())) {
                        stringBuffer.append(this.conversions.get(string2).toString());
                        bl = false;
                    }
                    n = this.skipPastChar(cArray, '>', n);
                } else {
                    bl2 = true;
                }
            } else if (cArray[n] == '&') {
                string2 = this.parseWord(cArray, n, ';', true);
                if (string2 != null) {
                    if (this.conversions.containsKey(string2 = string2.toLowerCase())) {
                        stringBuffer.append(this.conversions.get(string2.toLowerCase()).toString());
                        bl = false;
                    }
                    n = this.skipPastChar(cArray, ';', n);
                } else {
                    bl2 = true;
                }
            } else {
                bl2 = true;
            }
            if (!bl2) continue;
            stringBuffer.append(cArray[n]);
            ++n;
            bl = false;
        }
        return stringBuffer.toString();
    }

    private String parseWord(char[] cArray, int n, char c, boolean bl) {
        int n2 = n;
        while (n2 < cArray.length && !Character.isWhitespace(cArray[n2]) && cArray[n2] != c) {
            ++n2;
        }
        if (n2 < cArray.length && n2 > n) {
            if (bl && cArray[n2] == c) {
                return new String(cArray, n, n2 - n + 1);
            }
            return new String(cArray, n, n2 - n);
        }
        return null;
    }

    public void putConversion(String string, Object object) {
        this.verifyConversions();
        this.conversions.put(string, object);
    }

    public void removeConversion(String string) {
        this.verifyConversions();
        this.conversions.remove(string);
    }

    private int skipPastChar(char[] cArray, char c, int n) {
        int n2 = n;
        while (n2 < cArray.length && cArray[n2] != c) {
            ++n2;
        }
        if (n2 < cArray.length) {
            ++n2;
        }
        return n2;
    }

    private void verifyConversions() {
        if (this.conversions == null) {
            this.conversions = new Hashtable(24);
            String string = System.getProperty("line.separator");
            this.putConversion("br", string);
            this.putConversion("p", String.valueOf(string) + string);
            this.putConversion("/ul", string);
            this.putConversion("/ol", string);
            this.putConversion("/title", String.valueOf(string) + string);
            this.putConversion("li", String.valueOf(string) + "  - ");
            this.putConversion("blockquote", String.valueOf(string) + string);
            this.putConversion("/blockquote", String.valueOf(string) + string);
            this.putConversion("&lt;", "<");
            this.putConversion("&gt;", ">");
            this.putConversion("&amp;", "&");
            this.putConversion("&nbsp;", " ");
            this.putConversion("&copy;", "(C)");
        }
    }
}

