/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util;

import com.installshield.util.FileUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.StringUtils;
import java.util.Locale;
import java.util.Vector;

public class LocaleUtils {
    public static final int LANGUAGE = 1;
    public static final int COUNTRY = 2;
    public static final int VARIANT = 3;
    public static boolean isDefaultSupported = true;

    public static String createLocalizedFileName(String string, Locale locale, int n) {
        String string2 = FileUtils.normalizeFileName(string, '/');
        int n2 = string2.lastIndexOf(46);
        if (n2 == -1 || n2 < string2.lastIndexOf(47)) {
            n2 = string2.length();
        }
        String string3 = string2.substring(0, n2);
        String string4 = string2.substring(n2);
        String string5 = "";
        if (locale.getLanguage().length() > 0) {
            string5 = String.valueOf(string5) + "_" + locale.getLanguage();
            if (n > 1 && locale.getCountry().length() > 0) {
                string5 = String.valueOf(string5) + "_" + locale.getCountry();
                if (n > 2 && locale.getVariant().length() > 0) {
                    string5 = String.valueOf(string5) + "_" + locale.getVariant();
                }
            }
        }
        return FileUtils.normalizeFileName(String.valueOf(string3) + string5 + string4);
    }

    public static Locale findBestMatch(Locale[] localeArray, Locale locale) {
        Object object;
        Object object2;
        Object object3;
        String string = locale.getLanguage();
        String string2 = locale.getCountry();
        String string3 = locale.getVariant();
        Locale locale2 = null;
        Vector<Locale> vector = new Vector<Locale>();
        Vector<Object> vector2 = new Vector<Object>();
        Vector<Object> vector3 = new Vector<Object>();
        int n = 0;
        while (n < localeArray.length) {
            object3 = localeArray[n].getLanguage();
            if (((String)object3).equals(string)) {
                vector.addElement(localeArray[n]);
            }
            ++n;
        }
        object3 = vector.elements();
        while (object3.hasMoreElements()) {
            object2 = (Locale)object3.nextElement();
            object = ((Locale)object2).getCountry();
            if (!((String)object).equals(string2)) continue;
            vector2.addElement(object2);
        }
        object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            object = (Locale)object2.nextElement();
            String string4 = ((Locale)object).getVariant();
            if (!string4.equals(string3)) continue;
            vector3.addElement(object);
        }
        if (vector3.size() > 0) {
            locale2 = (Locale)vector3.elementAt(0);
        } else if (vector2.size() > 0) {
            locale2 = (Locale)vector2.elementAt(0);
        } else if (vector.size() > 0) {
            locale2 = (Locale)vector.elementAt(0);
        }
        return locale2;
    }

    private static String getChineseLocaleDisplayName(String string, String string2) {
        String string3 = "Chinese";
        if (string2 == null || string2.length() <= 0) {
            string2 = "CN";
        }
        if (string == null || string.length() <= 0) {
            string = "CN";
        }
        string2 = string2.toUpperCase();
        string = string.toUpperCase();
        string3 = string2.indexOf("TW") >= 0 || string2.indexOf("HK") >= 0 ? (string.indexOf("TW") >= 0 || string.indexOf("HK") >= 0 ? "\u7e41\u9ad4\u4e2d\u6587" : "\u7c21\u9ad4\u4e2d\u6587") : (string.indexOf("TW") >= 0 || string.indexOf("HK") >= 0 ? "\u7e41\u4f53\u4e2d\u6587" : "\u7b80\u4f53\u4e2d\u6587");
        return string3;
    }

    public static String getLocaleDisplayName(Locale locale) {
        String string = locale.getDisplayName();
        Locale locale2 = Locale.getDefault();
        if (locale.getLanguage().equalsIgnoreCase("zh")) {
            if (locale2.getLanguage().equalsIgnoreCase("zh")) {
                return LocaleUtils.getChineseLocaleDisplayName(locale.getCountry(), locale2.getCountry());
            }
            return LocaleUtils.getNonChineseLocaleDisplayName(locale.getCountry());
        }
        if (!isDefaultSupported) {
            return LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils." + locale.getLanguage());
        }
        return string;
    }

    public static String[] getLocalizedFileNames(String string, Locale[] localeArray) {
        String[] stringArray = new String[localeArray.length];
        int n = 0;
        while (n < localeArray.length) {
            stringArray[n] = LocaleUtils.createLocalizedFileName(string, localeArray[n], 3);
            ++n;
        }
        return stringArray;
    }

    private static String getNonChineseLocaleDisplayName(String string) {
        String string2 = "Chinese";
        if (string == null || string.length() <= 0) {
            string = "CN";
        }
        string2 = (string = string.toUpperCase()).indexOf("TW") >= 0 || string.indexOf("HK") >= 0 ? LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.traditionalChinese") : LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "LocaleUtils.simplifiedChinese");
        return string2;
    }

    public static String[] parseLocales(String string) {
        return StringUtils.parseCommaDelimitedString(string);
    }
}

