/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.util.sort;

import com.installshield.util.sort.ObjectCompare;

public class SortUtils {
    public static void mergeSort(Object[] objectArray) {
        SortUtils.mergeSort(objectArray, new ObjectCompare());
    }

    public static void mergeSort(Object[] objectArray, ObjectCompare objectCompare) {
        SortUtils.mergeSort(objectArray, objectCompare, 0, objectArray.length);
    }

    private static void mergeSort(Object[] objectArray, ObjectCompare objectCompare, int n, int n2) {
        SortUtils.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = (Object[])objectArray.clone();
        SortUtils.mergeSort(objectArray2, objectArray, objectCompare, n, n2);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, ObjectCompare objectCompare, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 7) {
            int n4 = n;
            while (n4 < n2) {
                int n5 = n4;
                while (n5 > n && objectCompare.compareTo(objectArray2[n5 - 1], objectArray2[n5]) > 0) {
                    SortUtils.swap(objectArray2, n5, n5 - 1);
                    --n5;
                }
                ++n4;
            }
            return;
        }
        int n6 = (n + n2) / 2;
        SortUtils.mergeSort(objectArray2, objectArray, objectCompare, n, n6);
        SortUtils.mergeSort(objectArray2, objectArray, objectCompare, n6, n2);
        if (objectCompare.compareTo(objectArray[n6 - 1], objectArray[n6]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n, n3);
            return;
        }
        int n7 = n;
        int n8 = n;
        int n9 = n6;
        while (n7 < n2) {
            objectArray2[n7] = n9 >= n2 || n8 < n6 && objectCompare.compareTo(objectArray[n8], objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
            ++n7;
        }
    }

    public static void qsort(Object[] objectArray) {
        SortUtils.qsort(objectArray, new ObjectCompare());
    }

    public static void qsort(Object[] objectArray, ObjectCompare objectCompare) {
        SortUtils.qsort(objectArray, objectCompare, 0, objectArray.length - 1);
    }

    /*
     * Unable to fully structure code
     */
    private static void qsort(Object[] var0, ObjectCompare var1_1, int var2_2, int var3_3) {
        if (var3_3 <= var2_2) {
            return;
        }
        var4_4 = var0[var2_2];
        var5_5 = var2_2;
        var6_6 = var3_3 + 1;
        ** GOTO lbl19
        {
            ++var5_5;
            do {
                if (var5_5 < var6_6 - 1 && !var1_1.lessThan(var4_4, var0[var5_5 + 1])) continue block0;
                while (var6_6 > var5_5 + 1 && var1_1.lessThan(var4_4, var0[var6_6 - 1])) {
                    --var6_6;
                }
                if (var6_6 - var5_5 <= 1) continue;
                var7_7 = var0[var6_6 - 1];
                var0[var6_6 - 1] = var0[var5_5 + 1];
                var0[var5_5 + 1] = var7_7;
                ++var5_5;
                --var6_6;
lbl19:
                // 3 sources

            } while (var6_6 - var5_5 > 1);
        }
        var0[var2_2] = var0[var5_5];
        var0[var5_5] = var4_4;
        SortUtils.qsort(var0, var1_1, var2_2, var5_5 - 1);
        SortUtils.qsort(var0, var1_1, var6_6, var3_3);
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }
}

