/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.Log;
import com.installshield.util.Progress;
import com.installshield.util.StringResolverUtil;
import com.installshield.wizard.ProgressRendererImpl;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardUI;

public abstract class ProgressRenderer
implements PropertyAccessible,
WizardBuilder {
    private ProgressRendererImpl impl = null;
    private RunnableWizardBean runnable = null;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        WizardUI[] wizardUIArray = wizardBuilderSupport.getWizard().getInterfaces();
        int n = 0;
        while (n < wizardUIArray.length) {
            Class clazz = this.getProgressRendererImpl(wizardUIArray[n].getName());
            if (clazz != null) {
                try {
                    wizardBuilderSupport.putClass(clazz.getName());
                    ProgressRendererImpl progressRendererImpl = (ProgressRendererImpl)clazz.newInstance();
                    progressRendererImpl.setProgressRenderer(this);
                    progressRendererImpl.build(wizardBuilderSupport);
                }
                catch (Exception exception) {
                    wizardBuilderSupport.logEvent(this, "err", exception);
                }
            }
            ++n;
        }
    }

    public void endProgress() {
        if (this.impl != null) {
            this.impl.endProgress();
        }
    }

    public ProgressRendererImpl getProgressRendererImpl() {
        return this.impl;
    }

    public Class getProgressRendererImpl(String string) {
        String string2;
        if (string.equals("awt")) {
            string2 = "AWTImpl";
        } else if (string.equals("swing")) {
            string2 = "SwingImpl";
        } else if (string.equals("console")) {
            string2 = "ConsoleImpl";
        } else {
            return null;
        }
        Class<?> clazz = this.getClass();
        Class<?> clazz2 = null;
        while (clazz != null && clazz2 == null) {
            try {
                clazz2 = Class.forName(String.valueOf(clazz.getName()) + string2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                clazz = clazz.getSuperclass();
            }
        }
        if (clazz2 == null) {
            this.getRunnableWizardBean().getWizard().getServices().logEvent(this, "dbg", "could not find " + string + " impl for " + this.getClass());
        }
        return clazz2;
    }

    public RunnableWizardBean getRunnableWizardBean() {
        return this.runnable;
    }

    protected String resolveString(String string, String string2, Log log) {
        return StringResolverUtil.resolveString(string, string2, log, this, this.getRunnableWizardBean().getWizard().getServices());
    }

    public void setProgressRendererImpl(ProgressRendererImpl progressRendererImpl) {
        this.impl = progressRendererImpl;
    }

    public void setRunnableWizardBean(RunnableWizardBean runnableWizardBean) {
        this.runnable = runnableWizardBean;
    }

    public void startProgress() {
        if (this.impl != null) {
            this.impl.startProgress();
        }
    }

    public void starting() {
        if (this.impl != null) {
            this.impl.starting();
        }
    }

    public void updateProgress(Progress progress) {
        if (this.impl != null) {
            this.impl.updateProgress(progress);
        }
    }
}

