/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.awt;

import com.installshield.util.MnemonicString;
import com.installshield.wizard.awt.ButtonPanel;
import com.installshield.wizard.awt.ColumnConstraints;
import com.installshield.wizard.awt.ColumnLayout;
import com.installshield.wizard.awt.ISBranding;
import com.installshield.wizard.awt.ImagePanel;
import com.installshield.wizard.awt.InsetsPanel;
import com.installshield.wizard.awt.MultilineLabel;
import com.installshield.wizard.awt.Spacing;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;

public class TextInputDialog
extends Dialog
implements ActionListener,
KeyListener {
    public static final int TEXT = 0;
    public static final int PATH_FILES_AND_DIRECTORIES = 1;
    public static final int PATH_DIRECTORIES_ONLY = 2;
    public static final int PATH_FILES_ONLY = 3;
    private String textValue;
    private int result;
    private int type;
    private TextField userInputField = null;
    private Button[] buttons;
    private int transferFocusIndex = 0;
    private final int captionWidth = 10;

    public TextInputDialog(Frame frame, String string, String string2, int n, String string3, String[] stringArray, int n2, Image image, String string4) {
        super(frame, string, true);
        Component component;
        Panel panel;
        if (stringArray == null) {
            throw new IllegalArgumentException("options parameter cannot be null");
        }
        if (n2 < 0 || n2 >= stringArray.length) {
            throw new IllegalArgumentException("defaultOptionIndex parameter must indicate acceptable index within the options array");
        }
        this.type = n;
        this.textValue = string3 != null ? string3 : "";
        this.transferFocusIndex = this.result = n2 >= 0 && n2 < stringArray.length ? n2 : 0;
        this.setForeground(SystemColor.controlText);
        ((Component)this).setBackground(SystemColor.control);
        this.setLayout(new ColumnLayout());
        this.setTitle(string);
        InsetsPanel insetsPanel = new InsetsPanel(10, 10, 10, 10);
        insetsPanel.setLayout(new ColumnLayout());
        this.add((Component)insetsPanel, ColumnConstraints.createLeftAlign());
        Panel panel2 = new Panel(new FlowLayout(0, 0, 0));
        if (image != null) {
            panel = new ImagePanel(image);
            panel2.add(panel);
            panel2.add(Spacing.createHorizontalSpacing(5));
        }
        panel = new Panel(new ColumnLayout());
        MultilineLabel multilineLabel = new MultilineLabel(MnemonicString.stripMn(string2));
        panel.add((Component)multilineLabel, ColumnConstraints.createLeftAlign());
        panel2.add(panel);
        insetsPanel.add((Component)panel2, ColumnConstraints.createLeftAlign());
        if (n == 0) {
            insetsPanel.add(Spacing.createVerticalSpacing(4));
            this.userInputField = new TextField(this.textValue);
            insetsPanel.add((Component)this.userInputField, ColumnConstraints.createHorizontalFill());
        } else {
            this.userInputField = new TextField(40);
            this.userInputField.setText(this.textValue);
            insetsPanel.add(Spacing.createVerticalSpacing(4));
            insetsPanel.add((Component)this.userInputField, ColumnConstraints.createHorizontalFill());
        }
        this.userInputField.addKeyListener(this);
        if (string4 != null && string4.trim().length() != 0) {
            component = new ISBranding(string4);
            insetsPanel.add(Spacing.createVerticalSpacing(4));
            insetsPanel.add(component, ColumnConstraints.createHorizontalFill());
        }
        component = new Panel(new FlowLayout(1, 5, 0));
        ButtonPanel buttonPanel = new ButtonPanel(1);
        ((Container)component).add(buttonPanel);
        this.buttons = new Button[stringArray.length];
        int n3 = 0;
        while (n3 < stringArray.length) {
            this.buttons[n3] = this.createButton(stringArray[n3]);
            buttonPanel.addButton(this.buttons[n3]);
            ++n3;
        }
        insetsPanel.add(Spacing.createVerticalSpacing(10));
        insetsPanel.add(component, ColumnConstraints.createCenterAlign());
        ((Component)this).setSize(375, 175);
        this.enableEvents(64L);
        this.pack();
        Frame frame2 = frame;
        synchronized (frame2) {
            Dimension dimension = frame.isVisible() ? frame.getSize() : Toolkit.getDefaultToolkit().getScreenSize();
            Point point = frame.isVisible() ? frame.getLocation() : new Point(0, 0);
            ((Component)this).setLocation(point.x + (dimension.width - this.getSize().width) / 2, point.y + (dimension.height - this.getSize().height) / 2);
        }
        this.setResizable(false);
    }

    public TextInputDialog(Frame frame, String string, String string2, String string3, String[] stringArray, int n) {
        this(frame, string, string2, 0, string3, stringArray, n, null, null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.result = -1;
        int n = 0;
        while (n < this.buttons.length) {
            if (this.buttons[n] == actionEvent.getSource()) {
                this.result = n;
                break;
            }
            ++n;
        }
        this.textValue = this.userInputField.getText();
        ((Component)this).setVisible(false);
    }

    private Button createButton(String string) {
        Button button = new Button(this.pad(MnemonicString.stripMn(string)));
        button.addActionListener(this);
        button.addKeyListener(this);
        return button;
    }

    public static Frame getParentFrame(Component component) {
        Container container = component.getParent();
        if (container instanceof Frame) {
            return (Frame)container;
        }
        if (container != null) {
            return TextInputDialog.getParentFrame(container);
        }
        return null;
    }

    public int getResult() {
        return this.result;
    }

    public String getTextValue() {
        return this.textValue;
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            this.actionPerformed(new ActionEvent(keyEvent.getSource(), 1001, ""));
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    private String pad(String string) {
        int n = 10 - string.length();
        if (n > 0) {
            n /= 2;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append(string);
            int n3 = 0;
            while (n3 < n) {
                stringBuffer.append(' ');
                ++n3;
            }
            return stringBuffer.toString();
        }
        return string;
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        if (windowEvent.getID() == 202) {
            this.result = -1;
            ((Component)this).setVisible(false);
        } else if (windowEvent.getID() == 200) {
            this.userInputField.requestFocus();
            this.userInputField.setSelectionStart(0);
            this.userInputField.setSelectionEnd(this.userInputField.getText().length());
        }
    }
}

