/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.console;

import com.installshield.qjml.PropertyAccessible;
import com.installshield.util.LocaleUtils;
import com.installshield.util.LocalizedStringResolver;
import com.installshield.util.MnemonicString;
import com.installshield.util.OperationRejectedException;
import com.installshield.util.TTYDisplay;
import com.installshield.util.TTYPrompt;
import com.installshield.util.UserInputRequest;
import com.installshield.util.UserInputResponse;
import com.installshield.wizard.AccessibilityMode;
import com.installshield.wizard.DefaultProgressRenderer;
import com.installshield.wizard.NavigatableWizardBean;
import com.installshield.wizard.ProgressRenderer;
import com.installshield.wizard.RunnableWizardBean;
import com.installshield.wizard.RunnableWizardBeanEvent;
import com.installshield.wizard.RunnableWizardBeanListener;
import com.installshield.wizard.Wizard;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanEvent;
import com.installshield.wizard.WizardBuilder;
import com.installshield.wizard.WizardBuilderSupport;
import com.installshield.wizard.WizardEvent;
import com.installshield.wizard.WizardPanel;
import com.installshield.wizard.WizardTreeIterator;
import com.installshield.wizard.WizardUI;
import com.installshield.wizard.console.ConsoleChoice;
import com.installshield.wizard.console.ConsoleMode;
import com.installshield.wizard.console.ConsoleProgressRendererImpl;
import com.installshield.wizard.console.ConsoleWizardPanelImpl;
import com.installshield.wizard.console.DefaultProgressRendererConsoleImpl;
import java.io.IOException;
import java.util.Locale;
import java.util.Vector;

public class ConsoleWizardUI
implements WizardUI,
RunnableWizardBeanListener,
WizardBuilder,
PropertyAccessible {
    private String name = "console";
    private Wizard wizard = null;
    private TTYDisplay tty = new TTYDisplay();
    private ProgressRenderer currentProgressRenderer = null;
    private RunnableWizardBean currentRunnableWizardBean = null;
    private ConsoleWizardPanelImpl currentConsoleImpl = null;
    private WizardBeanEvent currentBeanEvent = null;
    private ConsoleNavigationController controller = null;
    private Vector skipped = new Vector();
    private boolean stopped = false;
    private boolean accessibilityEnabled = false;
    static /* synthetic */ Class class$com$installshield$wizard$console$ConsoleWizardPanelImpl;
    static /* synthetic */ Class class$com$installshield$wizard$AccessibilityMode;

    public void build(WizardBuilderSupport wizardBuilderSupport) {
        try {
            wizardBuilderSupport.putPackage("com.installshield.wizard.console");
            wizardBuilderSupport.putClass((class$com$installshield$wizard$AccessibilityMode != null ? class$com$installshield$wizard$AccessibilityMode : (class$com$installshield$wizard$AccessibilityMode = ConsoleWizardUI.class$("com.installshield.wizard.AccessibilityMode"))).getName());
            wizardBuilderSupport.getWizard().addStartupBean(new ConsoleMode());
            wizardBuilderSupport.getWizard().addStartupBean(new AccessibilityMode());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public void clearBusy() {
    }

    protected boolean confirmExit() {
        String string = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "yes");
        String string2 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "no");
        String string3 = LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "ConsoleWizardUI.confirmExit");
        boolean bl = this.suspendCurrentOperation();
        UserInputRequest userInputRequest = new UserInputRequest(string3, LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.wantToExit"), 2, new String[]{string, string2}, string2);
        boolean bl2 = this.userInputRequested(userInputRequest).getResponse().equals(string);
        if (bl && !bl2) {
            this.resumeCurrentOperation();
        }
        return bl2;
    }

    public boolean currentBeanChanged(WizardEvent wizardEvent) {
        WizardBean wizardBean = wizardEvent.getWizard().getCurrentBean();
        if (!this.isConsolePanel(wizardBean)) {
            return false;
        }
        WizardBeanEvent wizardBeanEvent = new WizardBeanEvent(wizardEvent, this);
        try {
            this.currentConsoleImpl = this.getConsoleImpl(wizardBean);
            this.currentBeanEvent = new WizardBeanEvent(wizardEvent, this);
            boolean bl = true;
            if (this.currentConsoleImpl.getPanel().queryEnter(wizardBeanEvent)) {
                if (!this.currentConsoleImpl.isInitialized()) {
                    this.currentConsoleImpl.initialize(wizardBeanEvent);
                    this.currentConsoleImpl.setInitialized(true);
                }
                this.skipped.removeElement(this.currentConsoleImpl);
                this.currentConsoleImpl.getPanel().setEntered(true);
                if (this.currentConsoleImpl.getPanel().entered(wizardBeanEvent)) {
                    this.tty.printLine();
                    this.tty.printHRule();
                    this.currentConsoleImpl.entered(wizardBeanEvent);
                    this.refreshNavigationOptions();
                    this.controller.displayOptions();
                    bl = false;
                }
            }
            if (bl) {
                this.skipped.addElement(wizardBean);
                this.currentConsoleImpl.getPanel().setEntered(false);
            }
            return true;
        }
        catch (Throwable throwable) {
            this.wizard.getServices().logEvent(this, "err", throwable);
            this.wizard.getServices().logEvent(this, "err", "could not display error message panel -- exiting wizard");
            this.wizard.exit(1005);
            this.waitForExit(120);
            throw new Error("wizard failed to exit within timeout period");
        }
    }

    public void destroy() {
    }

    public void displayUserMessage(String string, String string2, int n) {
        this.userInputRequested(new UserInputRequest(string, string2, n));
    }

    public void doCancel() {
        this.currentConsoleImpl.exiting(this.currentBeanEvent);
        if (this.controller.getCancelType() == 2) {
            this.currentConsoleImpl.getPanel().exited(this.currentBeanEvent);
        }
        if (this.controller.getCancelType() == 2) {
            this.wizard.exit(0);
        } else if (this.confirmExit()) {
            this.wizard.exit(1000);
        } else {
            this.controller.displayOptions();
        }
    }

    public void doNext() {
        this.currentConsoleImpl.exiting(this.currentBeanEvent);
        if (this.currentConsoleImpl.getPanel().queryExit(this.currentBeanEvent)) {
            this.currentConsoleImpl.getPanel().exited(this.currentBeanEvent);
            this.currentConsoleImpl.getPanel().setEntered(false);
        } else {
            WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
            WizardBean wizardBean = wizardTreeIterator.getPrevious(this.currentConsoleImpl.getPanel());
            if (wizardBean == null) {
                wizardBean = wizardTreeIterator.begin();
            }
            this.wizard.setCurrentBean(wizardBean);
        }
    }

    public void doPrevious() {
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        WizardBean wizardBean = wizardTreeIterator.getPrevious(this.wizard.getCurrentBean());
        while (wizardBean != wizardTreeIterator.begin() && !this.isConsolePanel(wizardBean) || this.skipped.contains(wizardBean)) {
            wizardBean = wizardTreeIterator.getPrevious(wizardBean);
        }
        this.currentConsoleImpl.getPanel().setEntered(false);
        if (wizardBean == wizardTreeIterator.begin()) {
            this.wizard.setCurrentBean(wizardTreeIterator.getNext(wizardBean));
        } else {
            this.wizard.setCurrentBean(wizardTreeIterator.getPrevious(wizardBean));
        }
        if (this.isStopped()) {
            this.setStopped(false);
        }
    }

    private ConsoleWizardPanelImpl getConsoleImpl(WizardBean wizardBean) throws IllegalAccessException, InstantiationException {
        if (!(wizardBean instanceof WizardPanel)) {
            throw new Error("bean must extend WizardPanel");
        }
        WizardPanel wizardPanel = (WizardPanel)wizardBean;
        if (wizardPanel.getWizardPanelImpl() != null && !(wizardPanel.getWizardPanelImpl() instanceof ConsoleWizardPanelImpl)) {
            throw new Error("unexpected wizard panel impl type");
        }
        ConsoleWizardPanelImpl consoleWizardPanelImpl = (ConsoleWizardPanelImpl)wizardPanel.getWizardPanelImpl();
        if (consoleWizardPanelImpl == null) {
            Class clazz = ((WizardPanel)wizardBean).getWizardPanelImpl("console");
            if (clazz == null) {
                throw new Error("bean does not support console interface");
            }
            consoleWizardPanelImpl = (ConsoleWizardPanelImpl)clazz.newInstance();
            consoleWizardPanelImpl.setPanel(wizardPanel);
            wizardPanel.setWizardPanelImpl(consoleWizardPanelImpl);
        }
        return consoleWizardPanelImpl;
    }

    public Locale getDefaultLocale(Locale[] localeArray, Locale locale) {
        return this.getDefaultLocale(localeArray, locale, null);
    }

    public Locale getDefaultLocale(Locale[] localeArray, Locale locale, Wizard wizard) {
        LocaleSelector localeSelector = new LocaleSelector(localeArray, locale);
        return localeSelector.getSelectedLocale();
    }

    private ProgressRenderer getDefaultProgressRenderer() {
        DefaultProgressRenderer defaultProgressRenderer = new DefaultProgressRenderer();
        DefaultProgressRendererConsoleImpl defaultProgressRendererConsoleImpl = new DefaultProgressRendererConsoleImpl();
        defaultProgressRenderer.setProgressRendererImpl(defaultProgressRendererConsoleImpl);
        defaultProgressRendererConsoleImpl.setConsoleWizardUI(this);
        defaultProgressRendererConsoleImpl.setProgressRenderer(defaultProgressRenderer);
        return defaultProgressRenderer;
    }

    public String getName() {
        return "console";
    }

    public WizardUI getNextUI(Wizard wizard) {
        return null;
    }

    public TTYDisplay getTTY() {
        return this.tty;
    }

    public Wizard getWizard() {
        return this.wizard;
    }

    public void initialize(Wizard wizard) {
        if (wizard == null) {
            throw new IllegalArgumentException("wizard cannot be null");
        }
        this.wizard = wizard;
        this.controller = new ConsoleNavigationController();
    }

    public boolean isAccessibilityEnabled() {
        return this.accessibilityEnabled;
    }

    private boolean isConsolePanel(WizardBean wizardBean) {
        if (!(wizardBean instanceof WizardPanel)) {
            return false;
        }
        Class clazz = ((WizardPanel)wizardBean).getWizardPanelImpl("console");
        if (clazz == null) {
            return false;
        }
        return (class$com$installshield$wizard$console$ConsoleWizardPanelImpl != null ? class$com$installshield$wizard$console$ConsoleWizardPanelImpl : (class$com$installshield$wizard$console$ConsoleWizardPanelImpl = ConsoleWizardUI.class$("com.installshield.wizard.console.ConsoleWizardPanelImpl"))).isAssignableFrom(clazz);
    }

    public boolean isNavigationEnabled() {
        return this.controller.showBack || this.controller.showNext || this.controller.showCancel;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public void redisplay() {
        this.tty.printLine();
        this.tty.printHRule();
        this.currentConsoleImpl.redisplay(this.currentBeanEvent);
    }

    private void refreshNavigationOptions() {
        boolean bl;
        boolean bl2;
        boolean bl3;
        WizardBean wizardBean;
        WizardTreeIterator wizardTreeIterator = this.wizard.getIterator();
        boolean bl4 = wizardTreeIterator.getNext(wizardBean = this.wizard.getCurrentBean()) == wizardTreeIterator.end();
        this.controller.setCancelType(bl4 ? 2 : 1);
        int n = 0;
        if (this.wizard.getCurrentBean() instanceof NavigatableWizardBean) {
            n = ((NavigatableWizardBean)((Object)wizardBean)).getNavigationOptions();
        }
        if (n == 0) {
            bl3 = bl4 ^ true;
            bl2 = true;
            if (!bl4) {
                WizardBean wizardBean2 = wizardTreeIterator.getPrevious(wizardBean);
                while (wizardBean2 != wizardTreeIterator.begin() && !this.isConsolePanel(wizardBean2)) {
                    wizardBean2 = wizardTreeIterator.getPrevious(wizardBean2);
                }
                bl = wizardBean2 != wizardTreeIterator.begin();
            } else {
                bl = false;
            }
        } else {
            bl = (n & 1) != 0;
            bl3 = (n & 2) != 0;
            bl2 = (n & 4) != 0;
        }
        this.controller.showBack(bl);
        this.controller.showNext(!this.stopped && bl3);
        this.controller.showCancel(bl2);
    }

    private void resumeCurrentOperation() {
        WizardBean wizardBean = this.wizard.getCurrentBean();
        if (!(wizardBean instanceof RunnableWizardBean)) {
            throw new IllegalStateException("expected current bean to be suspended");
        }
        ((RunnableWizardBean)((Object)wizardBean)).resume();
    }

    public void runnableBeanStarted(RunnableWizardBean runnableWizardBean) {
        this.currentRunnableWizardBean = runnableWizardBean;
        this.currentProgressRenderer = runnableWizardBean.getProgressRenderer();
        if (this.currentProgressRenderer == null) {
            this.currentProgressRenderer = this.getDefaultProgressRenderer();
        }
        this.verifyProgressRendererImpl(this.currentProgressRenderer);
        runnableWizardBean.getState().setWizardRunnableListener(this);
        this.currentProgressRenderer.startProgress();
    }

    public void runnableBeanStopped(RunnableWizardBean runnableWizardBean) {
        if (this.currentProgressRenderer != null) {
            this.currentProgressRenderer.endProgress();
            this.currentProgressRenderer = null;
        }
        this.currentRunnableWizardBean = null;
    }

    public void runnableWizardBeanStateChanged(RunnableWizardBeanEvent runnableWizardBeanEvent) {
        if (this.currentProgressRenderer != null) {
            this.currentProgressRenderer.updateProgress(runnableWizardBeanEvent.getBean().getState());
        }
    }

    public void setAccessibilityEnabled(boolean bl) {
        this.accessibilityEnabled = bl;
        this.tty.setAccessibilityEnabled(bl);
    }

    public void setBusy() {
        this.setBusy(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "pleaseWait"));
    }

    public void setBusy(String string) {
        this.tty.printLine();
        this.tty.printLine(string);
    }

    public void setNavigationEnabled(boolean bl) {
        if (bl) {
            this.refreshNavigationOptions();
        } else {
            this.controller.showBack(false);
            this.controller.showNext(false);
            this.controller.showCancel(false);
        }
    }

    public void setStopped(boolean bl) {
        this.stopped = bl;
    }

    private boolean suspendCurrentOperation() {
        if (this.currentRunnableWizardBean != null) {
            try {
                this.currentRunnableWizardBean.suspend();
                return true;
            }
            catch (OperationRejectedException operationRejectedException) {
            }
        }
        return false;
    }

    public UserInputResponse userInputRequested(UserInputRequest userInputRequest) {
        Object object;
        Object object2 = this;
        synchronized (object2) {
            try {
                this.wait(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.tty.printLine();
        object2 = new UserInputResponse();
        boolean bl = false;
        if (userInputRequest.getType() == 5 || userInputRequest.getType() == 7 || userInputRequest.getType() == 6 || userInputRequest.getType() == 8 || userInputRequest.getType() == 9) {
            object = new TTYPrompt();
            ((TTYPrompt)object).setText(MnemonicString.stripMn(userInputRequest.getPrompt()));
            if (userInputRequest.getTextValue() != null) {
                ((TTYPrompt)object).setDefaultValue(userInputRequest.getTextValue());
            }
            this.tty.printLine();
            ((UserInputResponse)object2).setResponseText(this.tty.prompt((TTYPrompt)object));
            bl = true;
            this.tty.printLine();
        }
        if (userInputRequest.getResponseOptions() != null && userInputRequest.getResponseOptions().length > 1) {
            Object object3;
            int n = -1;
            String[] stringArray = null;
            stringArray = new String[userInputRequest.getResponseOptions().length];
            int n2 = 0;
            while (n2 < stringArray.length) {
                object3 = MnemonicString.stripMn(userInputRequest.getResponseOptions()[n2].toString());
                if (userInputRequest.getResponseOptions()[n2].equals(userInputRequest.getDefaultResponse())) {
                    n = n2;
                }
                stringArray[n2] = object3;
                ++n2;
            }
            object3 = new TTYPrompt();
            if (!bl) {
                ((TTYPrompt)object3).setText(userInputRequest.getPrompt());
            }
            ((TTYPrompt)object3).setOptions(stringArray);
            ((TTYPrompt)object3).setDefaultValue(n + 1);
            ((TTYPrompt)object3).setPromptForOptionIndex(true);
            int n3 = this.tty.promptInt((TTYPrompt)object3);
            ((UserInputResponse)object2).setResponse(userInputRequest.getResponseOptions()[n3 - 1]);
        } else if (userInputRequest.getResponseOptions() != null && userInputRequest.getResponseOptions().length == 1) {
            object = MnemonicString.stripMn(userInputRequest.getResponseOptions()[0].toString());
            this.tty.printMessage(userInputRequest.getPrompt(), (String)object);
            ((UserInputResponse)object2).setResponse(userInputRequest.getResponseOptions()[0]);
        } else {
            this.tty.printLine(userInputRequest.getPrompt());
            ((UserInputResponse)object2).setResponse(userInputRequest.getDefaultResponse());
        }
        if (this.currentRunnableWizardBean != null) {
            this.currentRunnableWizardBean.getState().setRedisplayProgress(true);
        }
        return object2;
    }

    private void verifyProgressRendererImpl(ProgressRenderer progressRenderer) {
        block4: {
            if (progressRenderer.getProgressRendererImpl() != null && !(progressRenderer.getProgressRendererImpl() instanceof ConsoleProgressRendererImpl)) {
                throw new Error("unexpected progress renderer impl type");
            }
            ConsoleProgressRendererImpl consoleProgressRendererImpl = (ConsoleProgressRendererImpl)progressRenderer.getProgressRendererImpl();
            if (consoleProgressRendererImpl != null) break block4;
            try {
                Class clazz = this.currentProgressRenderer.getProgressRendererImpl("console");
                if (clazz != null) {
                    consoleProgressRendererImpl = (ConsoleProgressRendererImpl)clazz.newInstance();
                    consoleProgressRendererImpl.setProgressRenderer(this.currentProgressRenderer);
                    consoleProgressRendererImpl.setConsoleWizardUI(this);
                    this.currentProgressRenderer.setProgressRendererImpl(consoleProgressRendererImpl);
                }
            }
            catch (Throwable throwable) {
                if (System.getProperty("is.debug") == null) break block4;
                throwable.printStackTrace();
            }
        }
    }

    private void waitForExit(int n) {
        ConsoleWizardUI consoleWizardUI = this;
        synchronized (consoleWizardUI) {
            try {
                this.wait(n * 1000);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private class LocaleSelector {
        private ConsoleChoice choice;
        private Locale[] available;
        private Locale selectedLocale;

        public LocaleSelector(Locale[] localeArray, Locale locale) {
            this.available = localeArray;
            this.selectedLocale = locale;
            Locale locale2 = Locale.getDefault();
            this.choice = new ConsoleChoice();
            this.choice.setCaption(LocalizedStringResolver.resolve("com.installshield.wizardx.i18n.WizardXResources", "ChoiceComponent.caption"));
            String[] stringArray = new String[localeArray.length];
            boolean bl = false;
            int n = 0;
            while (n < localeArray.length) {
                if (locale2.getLanguage().equalsIgnoreCase(localeArray[n].getLanguage())) {
                    bl = true;
                }
                ++n;
            }
            LocaleUtils.isDefaultSupported = bl;
            int n2 = -1;
            int n3 = 0;
            while (n3 < localeArray.length) {
                stringArray[n3] = LocaleUtils.getLocaleDisplayName(localeArray[n3]);
                if (locale.equals(localeArray[n3])) {
                    n2 = n3;
                }
                ++n3;
            }
            this.choice.setOptions(stringArray);
            this.choice.setMultiSelect(false);
            this.choice.setSelected(n2);
            ConsoleWizardUI.this.tty.printLine();
            ConsoleWizardUI.this.tty.printHRule();
            ConsoleWizardUI.this.tty.printLine(MnemonicString.stripMn(LocalizedStringResolver.resolve("com.installshield.wizard.i18n.WizardResources", "AWTWizardUI.selectLanguage")));
            ConsoleWizardUI.this.tty.printLine();
            this.choice.consoleInteraction(ConsoleWizardUI.this.tty);
            this.selectedLocale = localeArray[this.choice.getSelectedIndex()];
        }

        public Locale getSelectedLocale() {
            return this.selectedLocale;
        }
    }

    class ConsoleNavigationController {
        public final int CANCEL = 1;
        public final int CLOSE = 2;
        private final String NEXT_OPTION = "1";
        private final String BACK_OPTION = "2";
        private final String CANCEL_OPTION = "3";
        private final String REDISPLAY_OPTION = "4";
        private int cancelType = 1;
        private boolean showBack = true;
        private boolean showNext = true;
        private boolean showCancel = true;

        ConsoleNavigationController() {
        }

        public void displayOptions() {
            if (ConsoleWizardUI.this.getWizard().isFinished()) {
                return;
            }
            boolean bl = false;
            String string = "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.invalidMsg)";
            do {
                ConsoleWizardUI.this.tty.printLine();
                String string2 = ConsoleWizardUI.this.tty.prompt(this.getNavigationString(), this.getDefaultOption());
                if (string2.equals("2") && this.showBack) {
                    ConsoleWizardUI.this.doPrevious();
                    bl = false;
                    continue;
                }
                if (string2.equals("1") && this.showNext) {
                    ConsoleWizardUI.this.doNext();
                    bl = false;
                    continue;
                }
                if (string2.equals("3") && this.showCancel) {
                    ConsoleWizardUI.this.doCancel();
                    bl = false;
                    continue;
                }
                if (string2.equals("4")) {
                    ConsoleWizardUI.this.redisplay();
                    bl = true;
                    continue;
                }
                ConsoleWizardUI.this.tty.printLine();
                ConsoleWizardUI.this.tty.printLine(ConsoleWizardUI.this.wizard.getServices().resolveString(string));
                bl = true;
            } while (bl);
        }

        public int getCancelType() {
            return this.cancelType;
        }

        private String getDefaultOption() {
            if (this.showNext) {
                return "1";
            }
            if (this.showBack) {
                return "2";
            }
            if (this.cancelType == 2) {
                return "3";
            }
            return "3";
        }

        private String getNavigationString() {
            String string = "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.press)";
            String string2 = "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.backMsg,2)";
            String string3 = "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.nextMsg,1)";
            String string4 = "";
            string4 = this.cancelType == 2 ? "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.finishMsg,3)" : "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.cancelMsg,3)";
            String string5 = "$L(com.installshield.wizard.i18n.WizardResources,ConsoleWizardUI.redisplayMsg,4)";
            Vector<String> vector = new Vector<String>(4);
            if (this.showNext) {
                vector.addElement(ConsoleWizardUI.this.wizard.getServices().resolveString(string3));
            }
            if (this.showBack) {
                vector.addElement(ConsoleWizardUI.this.wizard.getServices().resolveString(string2));
            }
            if (this.showCancel) {
                vector.addElement(ConsoleWizardUI.this.wizard.getServices().resolveString(string4));
            }
            vector.addElement(ConsoleWizardUI.this.wizard.getServices().resolveString(string5));
            String string6 = String.valueOf(ConsoleWizardUI.this.wizard.getServices().resolveString(string)) + " ";
            int n = 0;
            while (n < vector.size()) {
                if (((String)vector.elementAt(n)).length() > 0) {
                    if (n > 0 && n < vector.size() - 1) {
                        string6 = String.valueOf(string6) + ", ";
                    } else if (n == vector.size() - 1) {
                        string6 = String.valueOf(string6) + " " + ConsoleWizardUI.this.wizard.getServices().resolveString("$L(com.installshield.wizard.i18n.WizardResources, ConsoleWizardUI.or)") + " ";
                    }
                    string6 = String.valueOf(string6) + (String)vector.elementAt(n);
                }
                ++n;
            }
            return string6;
        }

        public void setCancelType(int n) {
            this.cancelType = n;
        }

        public void showBack(boolean bl) {
            this.showBack = bl;
        }

        public void showCancel(boolean bl) {
            this.showCancel = bl;
        }

        public void showNext(boolean bl) {
            this.showNext = bl;
        }
    }
}

