/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.iterators;

import com.installshield.wizard.FilteredWizardTreeIterator;
import com.installshield.wizard.WizardBean;
import com.installshield.wizard.WizardBeanFilter;

public class WizardBeanTypeTreeIterator
implements FilteredWizardTreeIterator {
    private FilteredWizardTreeIterator iter;
    private Class[] classTypes;
    private boolean strictComparison;

    public WizardBeanTypeTreeIterator(FilteredWizardTreeIterator filteredWizardTreeIterator, Class clazz) {
        this(filteredWizardTreeIterator, new Class[]{clazz}, false);
    }

    public WizardBeanTypeTreeIterator(FilteredWizardTreeIterator filteredWizardTreeIterator, Class clazz, boolean bl) {
        this(filteredWizardTreeIterator, new Class[]{clazz}, bl);
    }

    public WizardBeanTypeTreeIterator(FilteredWizardTreeIterator filteredWizardTreeIterator, Class[] classArray) {
        this(filteredWizardTreeIterator, classArray, false);
    }

    public WizardBeanTypeTreeIterator(FilteredWizardTreeIterator filteredWizardTreeIterator, Class[] classArray, boolean bl) {
        this.iter = filteredWizardTreeIterator;
        this.classTypes = classArray;
        this.strictComparison = bl;
    }

    public void addFilter(WizardBeanFilter wizardBeanFilter) {
        this.iter.addFilter(wizardBeanFilter);
    }

    public WizardBean begin() {
        return this.iter.begin();
    }

    public WizardBean end() {
        return this.iter.end();
    }

    public WizardBean getNext(WizardBean wizardBean) {
        WizardBean wizardBean2 = this.iter.getNext(wizardBean);
        while (wizardBean2 != this.end() && !this.isWizardBeanType(wizardBean2)) {
            wizardBean2 = this.iter.getNext(wizardBean2);
        }
        return wizardBean2;
    }

    public WizardBean getPrevious(WizardBean wizardBean) {
        WizardBean wizardBean2 = this.iter.getPrevious(wizardBean);
        while (wizardBean2 != this.begin() && !this.isWizardBeanType(wizardBean2)) {
            wizardBean2 = this.iter.getPrevious(wizardBean2);
        }
        return wizardBean2;
    }

    public boolean isWizardBeanType(WizardBean wizardBean) {
        boolean bl = false;
        int n = 0;
        while (n < this.classTypes.length && !bl) {
            bl = this.strictComparison ? wizardBean.getClass() == this.classTypes[n] : this.classTypes[n].isAssignableFrom(wizardBean.getClass());
            ++n;
        }
        return bl;
    }

    public void removeFilter(WizardBeanFilter wizardBeanFilter) {
        this.iter.removeFilter(wizardBeanFilter);
    }
}

