/*
 * Decompiled with CFR 0.152.
 */
package com.installshield.wizard.platform.genericunix.distribution;

import com.installshield.util.jvm.LaunchScript;
import com.installshield.wizard.service.WizardServices;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class ShellScriptLaunchScript
extends LaunchScript {
    private String archiveExpression = "";

    protected void appendClasspath(StringBuffer stringBuffer, String[] stringArray) {
        stringBuffer.append("$CLASSPATH_SWITCH").append(' ');
        stringBuffer.append('.').append(':');
        stringBuffer.append("$PREPEND_CLASSPATH").append(':');
        stringBuffer.append("$CP1").append(':');
        stringBuffer.append("\"$JVM_CLASSPATH\"").append(':');
        stringBuffer.append("$CP").append(':');
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append(stringArray[n]);
                stringBuffer.append(':');
                ++n;
            }
        }
        stringBuffer.append("$INSTALLER_ARCHIVE").append(':');
        stringBuffer.append("$EMBEDDED_JARS").append(':');
        stringBuffer.append("$CP2").append(':');
        stringBuffer.append("$CLASSPATH").append(':');
        stringBuffer.append("$APPEND_CLASSPATH").append(':');
    }

    protected void appendJavaExe(StringBuffer stringBuffer) {
        stringBuffer.append("\"$JVM_HOME/$JVM_EXE\"");
    }

    protected void appendOtherArgs(StringBuffer stringBuffer, String string) {
        stringBuffer.append(string);
    }

    protected void appendRuntimeSystemProperties(StringBuffer stringBuffer) {
        stringBuffer.append("\"$RUNTIME_SYSTEMPROP\"");
    }

    protected void appendSystemProperty(StringBuffer stringBuffer, String string, String string2) {
        stringBuffer.append("-D");
        stringBuffer.append(string);
        stringBuffer.append('=');
        stringBuffer.append('\\').append('\"');
        stringBuffer.append(string2);
        stringBuffer.append('\\').append('\"');
    }

    public long calculateSize() throws IOException {
        return this.getBytes().length;
    }

    public String[] createLaunchScriptClassPath(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(this.formatClassPath(stringArray[n]));
            ++n;
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public Dictionary createLaunchScriptSystemProperties(String[] stringArray, WizardServices wizardServices) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < stringArray.length) {
            String string = stringArray[n];
            int n2 = string.indexOf(61);
            String string2 = n2 != -1 ? string.substring(0, n2) : string;
            String string3 = n2 != -1 ? string.substring(n2 + 1) : "";
            hashtable.put(wizardServices.resolveString(string2), wizardServices.resolveString(string3));
            ++n;
        }
        return hashtable;
    }

    private String formatClassPath(String string) {
        if (string.length() > 1) {
            if (string.startsWith("\"")) {
                string = string.substring(1);
            }
            if (string.endsWith("\"")) {
                string = string.substring(0, string.length() - 1);
            }
            string = "\\\"" + string + "\\" + "\"";
            return string;
        }
        return string;
    }

    public static String formatValue(String string) {
        return string;
    }

    public String getArchiveExpression() {
        return this.archiveExpression;
    }

    private byte[] getBytes() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        this.appendJavaExe(stringBuffer);
        stringBuffer.append(' ');
        this.appendClasspath(stringBuffer, this.getClassPath());
        stringBuffer.append(' ');
        this.writeSystemProperties(stringBuffer);
        this.appendRuntimeSystemProperties(stringBuffer);
        stringBuffer.append(' ');
        this.appendOtherArgs(stringBuffer, "$JAVA_ARGS");
        stringBuffer.append(' ');
        String string = this.getMainClass();
        if (string != null && string.length() > 0) {
            stringBuffer.append(string);
        }
        stringBuffer.append(' ');
        String string2 = this.getMainClassArgs();
        if (string2 != null && string2.length() > 0) {
            stringBuffer.append(string2).append(' ');
        }
        stringBuffer.append("\"$app_args\"").append(' ');
        stringBuffer.append("1>$APP_STDOUT 2>$APP_STDERR");
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append("Launch()").append('\n');
        stringBuffer2.append("{").append('\n');
        if (this.getOtherArgs() != null && this.getOtherArgs().length() > 0) {
            stringBuffer2.append("JAVA_ARGS_UNRESOLVED=").append('\"').append(this.getOtherArgs()).append('\"').append('\n');
        }
        if (this.getConsoleVisible()) {
            stringBuffer2.append("CONSOLE_ON=true").append('\n');
        }
        stringBuffer2.append(this.archiveExpression).append('\n');
        stringBuffer2.append("resolveLaunchCommand").append(' ').append("\"$RESOLVED_JVM\"").append('\n');
        stringBuffer2.append("if [ $resolve -ne 0 ]; then").append('\n');
        stringBuffer2.append(" dbg \"Launch Script can't not be resolved. Run the installer with -is:log <logfile> to view the errors.\"").append('\n');
        stringBuffer2.append("cleanupandexit 3").append('\n');
        stringBuffer2.append("else").append('\n');
        if (this.getTitle() != null && this.getTitle().length() > 0) {
            stringBuffer2.append("pbmesg").append('=').append('\"').append("Launching ").append(this.getTitle()).append('\"').append('\n');
        } else {
            stringBuffer2.append("pbmesg").append('=').append('\"').append("Launching the Application").append('\"').append('\n');
        }
        stringBuffer2.append("pbc=8").append('\n');
        stringBuffer2.append("pb").append('\n');
        stringBuffer2.append("pbl").append('\n');
        stringBuffer2.append("pbl").append('\n');
        stringBuffer2.append("JC=").append('\"').append(stringBuffer.toString()).append('\"').append('\n');
        stringBuffer2.append("dbg LAUNCH_COMMAND=\"$JC\"").append('\n');
        stringBuffer2.append("eval $JC").append('\n');
        stringBuffer2.append("applicationExitStatus=$?").append('\n');
        stringBuffer2.append("fi").append('\n');
        stringBuffer2.append("}").append('\n');
        return stringBuffer2.toString().getBytes();
    }

    public InputStream getInputStream() throws IOException {
        byte[] byArray = this.getBytes();
        return new ByteArrayInputStream(byArray);
    }

    public void setArchiveExpression(String string) {
        this.archiveExpression = string;
    }

    private void writeSystemProperties(StringBuffer stringBuffer) {
        Dictionary dictionary = this.getSystemProperties();
        if (dictionary != null) {
            Object object = null;
            Object object2 = null;
            Enumeration enumeration = dictionary.keys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                if (object != null) {
                    object2 = dictionary.get(object);
                }
                if (object2 == null) continue;
                this.appendSystemProperty(stringBuffer, object.toString(), object2.toString());
                stringBuffer.append(' ');
            }
        }
    }
}

